/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class URCapFileValidationHelper {
    private static final String BUNDLE_CATEGORY = "Bundle-Category";
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";

    public boolean validateRequiredProperties(File file) {
        Properties properties = this.getManifestProperties(file);
        if (properties != null) {
            String symbolicName = properties.getProperty("Bundle-SymbolicName");
            String version = properties.getProperty("Bundle-Version");
            return StringUtils.isNotEmpty((String)symbolicName) && StringUtils.isNotEmpty((String)version);
        }
        return false;
    }

    public String getBundleCategory(File file) {
        Properties properties = this.getManifestProperties(file);
        if (properties != null) {
            return properties.getProperty(BUNDLE_CATEGORY);
        }
        return null;
    }

    public String getSymbolicNameAndVersion(File urCapFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zipFile = new ZipFile(urCapFile);){
            ZipEntry zipEntry = zipFile.getEntry(MANIFEST_FILE);
            Properties properties = this.getProperties(zipFile.getInputStream(zipEntry));
            String symbolicName = properties.getProperty("Bundle-SymbolicName");
            String version = properties.getProperty("Bundle-Version");
            return String.valueOf(symbolicName) + "-" + version;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ZipEntry getManifestFile(File file) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                return zipFile.getEntry(MANIFEST_FILE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasManifestFile(File file) {
        return this.getManifestFile(file) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIfManifestExistsAsFirstTwoEntriesInJar(File file) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ZipFile urcapZip = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = urcapZip.entries();
                String[] firstTwoEntries = new String[2];
                int i = 0;
                while (true) {
                    if (i >= 2 || !entries.hasMoreElements()) {
                        if (firstTwoEntries[0].equals(MANIFEST_FILE)) return true;
                        if (!firstTwoEntries[1].equals(MANIFEST_FILE)) return false;
                        return true;
                    }
                    firstTwoEntries[i] = entries.nextElement().getName();
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private Properties getManifestProperties(File file) {
        this.getManifestFile(file);
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry zipEntry = zipFile.getEntry(MANIFEST_FILE);
                return this.getProperties(zipFile.getInputStream(zipEntry));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Properties getProperties(InputStream inputStream) {
        Properties properties = new Properties();
        Scanner scan = new Scanner(inputStream, "utf-8");
        String key = "";
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.contains(": ")) {
                String[] lineSplit = line.split(":");
                key = lineSplit[0];
                String value = lineSplit[1].substring(1);
                properties.put(key, value);
            }
            if (!line.startsWith(" ") || properties.getProperty(key) == null) continue;
            properties.put(key, properties.getProperty(key).concat(line.substring(1)));
        }
        return properties;
    }

    public Bundle getBundleWithDuplicateSymbolicNameAndVersion(File file, BundleContext context) {
        Properties properties = this.getManifestProperties(file);
        if (properties == null) {
            return null;
        }
        String symbolicName = (String)properties.get("Bundle-SymbolicName");
        String version = (String)properties.get("Bundle-Version");
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (this.isSameSymbolicName(symbolicName, bundle) && this.isSameVersion(version, bundle)) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    private boolean isSameSymbolicName(String symbolicName, Bundle bundle) {
        return bundle.getSymbolicName().equalsIgnoreCase(symbolicName);
    }

    private boolean isSameVersion(String version, Bundle bundle) {
        return bundle.getVersion().compareTo(new Version(version)) == 0;
    }

    public String getURCapName(File file) {
        Properties properties = this.getManifestProperties(file);
        String name = null;
        if (properties != null && (name = (String)properties.get("Bundle-Name")) == null) {
            name = (String)properties.get("Bundle-SymbolicName");
        }
        return name != null ? name : file.getName();
    }

    public boolean isMetadataFileMissing(File urCapXFile) {
        boolean isValid = false;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(urCapXFile);){
                ZipEntry zipEntry = zipFile.getEntry("manifest.yaml");
                isValid = zipEntry == null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Log.error((String)("Error validating manifest file for URCap" + urCapXFile.getName()), (Throwable)e);
        }
        return isValid;
    }

    public boolean isMetadataFileEmpty(File urCapXFile) {
        boolean isValid = false;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(urCapXFile);){
                ZipEntry zipEntry = zipFile.getEntry("manifest.yaml");
                isValid = zipEntry.getSize() == 0L;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Log.error((String)("Error validating metadata file for URCap" + urCapXFile.getName()), (Throwable)e);
        }
        return isValid;
    }
}

