/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityValidationResult;
import com.ur.swing.SwingUtil;
import com.ur.urcap.osgi.infrastructure.InvalidURCapBundle;
import com.ur.urcap.osgi.infrastructure.URCapInstallExceptionHandler;
import com.ur.util.logging.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;

class URCapInstallErrorLogging {
    private static final String CANNOT_INSTALL_S = "Cannot install '%s'. ";
    private final URCapInstallExceptionHandler urCapInstallExceptionHandler;

    @Inject
    public URCapInstallErrorLogging(URCapInstallExceptionHandler urCapInstallExceptionHandler) {
        this.urCapInstallExceptionHandler = urCapInstallExceptionHandler;
    }

    public void onFailToCopyURCapFile(File urCapFile, Throwable e) {
        SwingUtil.invokeLater(() -> {
            String message = e.getMessage();
            if (message != null && message.toLowerCase(Locale.ENGLISH).contains("not enough space")) {
                this.displayFailToCopyFileNoDiskSpaceDialog(urCapFile);
            } else {
                this.displayFailToCopyFileOtherReasonsDialog(urCapFile);
            }
        });
    }

    public void onInvalidURCap(File sourceFile) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, sourceFile.getName());
        Log.error((String)(String.valueOf(failToInstallMessage) + String.format("'%s' is not a valid URCap file", sourceFile.getName())));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayNotAValidURCapDialog(sourceFile));
    }

    public void logErrorForMissingManifest(File sourceFile, File polyscopeBundle) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, sourceFile.getName());
        Log.error((String)(String.valueOf(failToInstallMessage) + String.format("PolyScope bundle '%s' is not valid. The manifest file ('META-INF/MANIFEST.MF') is missing.", polyscopeBundle.getName())));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayMissingManifestErrorDialog(sourceFile, polyscopeBundle));
    }

    public void logErrorForInvalidBundleCategory(File sourceFile, File polyscopeBundle) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, sourceFile.getName());
        Log.error((String)(String.valueOf(failToInstallMessage) + String.format("PolyScope bundle '%s' is not valid. The 'Bundle-Category' attribute in the manifest file ('META-INF/MANIFEST.MF') must be present and have the value 'URCap'.", polyscopeBundle.getName())));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayInvalidBundleCategoryErrorDialog(sourceFile, polyscopeBundle));
    }

    public void onMissingBundlePropertiesInManifest(File sourceFile, File polyscopeBundle) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, sourceFile.getName());
        Log.error((String)(String.valueOf(failToInstallMessage) + String.format("PolyScope bundle '%s' has an invalid manifest file ('META-INF/MANIFEST.MF'). The 'Bundle-SymbolicName' and 'Bundle-Version' attributes in the manifest file ('META-INF/MANIFEST.MF') must be present.", polyscopeBundle.getName())));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayMissingBundlePropertiesDialog(sourceFile));
    }

    public void onExceptionDueToInvalidManifest(File sourceFile, File polyscopeBundle, String cause) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, sourceFile.getName());
        Log.error((String)(String.valueOf(failToInstallMessage) + String.format("PolyScope bundle '%s' has an invalid manifest file ('META-INF/MANIFEST.MF'). ", polyscopeBundle.getName()) + cause));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayInvalidManifestDialogWithCause(sourceFile, polyscopeBundle, cause));
    }

    public void onInvalidManifest(File sourceFile, File polyscopeBundle) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, sourceFile.getName());
        Log.error((String)(String.valueOf(failToInstallMessage) + String.format("PolyScope bundle '%s' has an invalid manifest file ('META-INF/MANIFEST.MF'). ", polyscopeBundle.getName())));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayInvalidManifestDialog(sourceFile, polyscopeBundle));
    }

    public void onDuplicateBundleExists(String urcapName, String duplicateBundleName) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, urcapName);
        Log.error((String)(String.valueOf(failToInstallMessage) + String.format("The already running URCap '%s' has same symbolic name and version", duplicateBundleName)));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayBundleAlreadyInstalledDialog(duplicateBundleName, urcapName));
    }

    public void onIncompatibleFile(File sourceFile, CompatibilityValidationResult validationResult) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, sourceFile.getName());
        Log.error((String)(String.valueOf(failToInstallMessage) + validationResult.getError().getMessage()));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayFailToInstallIncompatibleBundleDialog(validationResult));
    }

    public void onFailToInstallURCap(File urcapFile, Exception e) {
        Log.error((String)("Cannot install URCap " + urcapFile.getName() + " : " + e));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayFailToInstallExceptionDialog(urcapFile, e));
    }

    public void logErrorForMissingMetadataFile(File sourceFile) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, sourceFile.getName());
        Log.error((String)(String.valueOf(failToInstallMessage) + String.format("URCap '%s' is not valid. The manifest file ('manifest.yaml') file is missing.", sourceFile.getName())));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayMissingMetadataFileErrorDialog(sourceFile));
    }

    public void logErrorForEmptyMetadataFile(File sourceFile) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, sourceFile.getName());
        Log.error((String)(String.valueOf(failToInstallMessage) + String.format("URCap '%s' is not valid. The metadata file ('manifest.yaml') file is empty.", sourceFile.getName())));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayEmptyMetadataFileErrorDialog(sourceFile));
    }

    public void logErrorForMissingOSGIBundle(File sourceFile, List<InvalidURCapBundle> missingBundles) {
        if (missingBundles.size() == 1) {
            this.logErrorForSingleMissingOSGIBundle(sourceFile, (ArrayList)missingBundles);
        } else {
            this.logErrorForMultipleMissingOSGIBundle(sourceFile, (ArrayList)missingBundles);
        }
    }

    private void logErrorForMultipleMissingOSGIBundle(File sourceFile, ArrayList<InvalidURCapBundle> missingBundles) {
        String initialMessage = this.initialInstallErrorMessage(sourceFile);
        String missingBundlesMessage = String.format(" Could not find the folder or file for the '%s' PolyScope bundles specified in the manifest file ('manifest.yaml')", missingBundles.toString());
        Log.error((String)(String.valueOf(initialMessage) + missingBundlesMessage));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayMissingMultipleOSGIBundleErrorDialog(sourceFile, missingBundles));
    }

    private void logErrorForSingleMissingOSGIBundle(File sourceFile, ArrayList<InvalidURCapBundle> missingBundles) {
        String initialMessage = this.initialInstallErrorMessage(sourceFile);
        String missingBundlesMessage = String.format(" Could not find the folder or file for the '%s' PolyScope bundle specified in the manifest file ('manifest.yaml')", missingBundles.get(0).getName());
        Log.error((String)(String.valueOf(initialMessage) + missingBundlesMessage));
        SwingUtil.invokeLater(() -> this.urCapInstallExceptionHandler.displayMissingSingleOSGIBundleErrorDialog(sourceFile, missingBundles));
    }

    private String initialInstallErrorMessage(File sourceFile) {
        String failToInstallMessage = String.format(CANNOT_INSTALL_S, sourceFile.getName());
        String invalidURCap = String.format("URCap '%s' is not a valid URCap file. ", sourceFile.getName());
        return String.valueOf(failToInstallMessage) + invalidURCap;
    }

    private void displayFailToCopyFileNoDiskSpaceDialog(File urCapFile) {
        this.urCapInstallExceptionHandler.displayFailToCopyFileNoDiskSpaceDialog(urCapFile);
    }

    private void displayFailToCopyFileOtherReasonsDialog(File urCapFile) {
        this.urCapInstallExceptionHandler.displayFailToCopyFileOtherReasonsDialog(urCapFile);
    }
}

