/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityError;
import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityValidationResult;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.urcap.html.util.HTMLBuilder;
import com.ur.urcap.osgi.infrastructure.InvalidURCapBundle;
import gui.tools.DialogCreator;
import gui.tools.dialogs.MessageDialogPanel;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class URCapInstallExceptionHandler {
    private final TextResource urcapTextResource;
    private final com.ur.i18n.TextResource textResource;
    private final DialogCreator dialogCreator;

    @Inject
    public URCapInstallExceptionHandler(DialogCreator dialogCreator, TextResource urcapTextResource, com.ur.i18n.TextResource textResource) {
        this.dialogCreator = dialogCreator;
        this.urcapTextResource = urcapTextResource;
        this.textResource = textResource;
    }

    public void displayFailToInstallExceptionDialog(File urCapFile, Exception e) {
        ErrorMessage errorMessage = new ErrorMessage(this.urcapTextResource.CannotInstallURCap(urCapFile.getName()), "");
        errorMessage.setId(e.hashCode());
        String message = this.urcapTextResource.InstallationFailedReasonUnknown();
        String advancedMessage = e.toString();
        this.dialogCreator.showErrorMessageWithCustomPanel((DialogMessage)errorMessage, (URDialogPanel)this.getDialogPanelWithAdvancedDetails(message, "", advancedMessage), null);
    }

    public void displayFailToCopyFileOtherReasonsDialog(File urCapFile) {
        ErrorMessage errorMessage = new ErrorMessage(this.urcapTextResource.CannotInstallURCap(urCapFile.getName()), this.urcapTextResource.FailToCopyURCapUnknownReason());
        this.dialogCreator.showErrorDialog(errorMessage, new OkDialogListener());
    }

    public void displayFailToCopyFileNoDiskSpaceDialog(File urCapFile) {
        ErrorMessage errorMessage = new ErrorMessage(this.urcapTextResource.CannotInstallURCap(urCapFile.getName()), this.urcapTextResource.NotEnoughDiskSpace());
        this.dialogCreator.showErrorDialog(errorMessage, new OkDialogListener());
    }

    public void displayFailToInstallIncompatibleBundleDialog(CompatibilityValidationResult validationResult) {
        CompatibilityError error = validationResult.getError();
        ErrorMessage errorMessage = new ErrorMessage(error.getLocalizedTitle(), error.getLocalizedMessage(), error.getLocalizedSuggestion());
        this.dialogCreator.showErrorDialog(errorMessage, new OkDialogListener());
    }

    public void displayNotAValidURCapDialog(File urCapFile) {
        ErrorMessage errorMessage = new ErrorMessage(this.urcapTextResource.CannotInstallURCap(urCapFile.getName()), this.urcapTextResource.IsNotValidURCapFile(urCapFile.getName()));
        this.dialogCreator.showErrorDialog(errorMessage, new OkDialogListener());
    }

    public void displayMissingManifestErrorDialog(File urCapFile, File polyscopeBundle) {
        String urcapName = urCapFile.getName();
        this.displayErrorWithAdvancedMessageDialog(urcapName, this.urcapTextResource.IsNotValidURCapFile(polyscopeBundle.getName()), this.urcapTextResource.MissingManifestFile());
    }

    public void displayMissingMetadataFileErrorDialog(File urCapXFile) {
        String urcapName = urCapXFile.getName();
        this.displayErrorWithAdvancedMessageDialog(urcapName, this.urcapTextResource.IsNotValidURCapXFile(urcapName), this.urcapTextResource.MissingManifestYamlFile());
    }

    public void displayEmptyMetadataFileErrorDialog(File urCapXFile) {
        String urcapName = urCapXFile.getName();
        this.displayErrorWithAdvancedMessageDialog(urcapName, this.urcapTextResource.IsNotValidURCapXFile(urcapName), this.urcapTextResource.EmptyManifestFile());
    }

    public void displayMissingSingleOSGIBundleErrorDialog(File urCapXFile, List<InvalidURCapBundle> missingBundles) {
        String urcapName = urCapXFile.getName();
        this.displayErrorWithAdvancedMessageDialog(urcapName, this.urcapTextResource.IsNotValidURCapXFile(urcapName), this.urcapTextResource.MissingOSGIBundle(missingBundles.get(0).getName()));
    }

    public void displayMissingMultipleOSGIBundleErrorDialog(File urCapXFile, List<InvalidURCapBundle> missingBundles) {
        String urcapName = urCapXFile.getName();
        this.displayErrorWithAdvancedMessageDialog(urcapName, this.urcapTextResource.IsNotValidURCapXFile(urcapName), this.urcapTextResource.MissingMultipleOSGIBundle(missingBundles.toString()));
    }

    public void displayInvalidBundleCategoryErrorDialog(File urCapFile, File polyscopeBundle) {
        String urcapName = urCapFile.getName();
        this.displayErrorWithAdvancedMessageDialog(urcapName, this.urcapTextResource.IsNotValidURCapFile(polyscopeBundle.getName()), this.urcapTextResource.InvalidOrMissingBundleCategory());
    }

    public void displayInvalidManifestDialogWithCause(File urCapFile, File polyscopeBundle, String cause) {
        this.displayErrorWithAdvancedMessageDialog(this.urcapTextResource.CannotInstallURCap(urCapFile.getName()), this.urcapTextResource.InvalidBundleManifestFile(polyscopeBundle.getName()), cause);
    }

    public void displayInvalidManifestDialog(File urCapFile, File polyscopeBundle) {
        ErrorMessage errorMessage = new ErrorMessage(this.urcapTextResource.CannotInstallURCap(urCapFile.getName()), this.urcapTextResource.InvalidBundleManifestFile(polyscopeBundle.getName()));
        this.dialogCreator.showErrorDialog(errorMessage, new OkDialogListener());
    }

    public void displayMissingBundlePropertiesDialog(File urCapFile) {
        String advancedMessage = this.urcapTextResource.MissingBundleSymbolicNameOrVersionInManifest("Bundle-SymbolicName", "Bundle-Version");
        this.displayErrorWithAdvancedMessageDialog(this.urcapTextResource.CannotInstallURCap(urCapFile.getName()), this.urcapTextResource.InvalidManifestFile(), advancedMessage);
    }

    public void displayBundleAlreadyInstalledDialog(String installedUrcapName, String urcapName) {
        ErrorMessage errorMessage = new ErrorMessage(this.urcapTextResource.CannotInstallURCap(urcapName), this.urcapTextResource.AlreadyRunning(installedUrcapName));
        this.dialogCreator.showErrorDialog(errorMessage, new OkDialogListener());
    }

    private MessageDialogPanel getDialogPanelWithAdvancedDetails(String fullMessage, String suggestion, String advancedMessage) {
        HTMLBuilder html = new HTMLBuilder();
        html.start("p");
        html.text(fullMessage);
        html.end("p");
        if (suggestion != null && !suggestion.isEmpty()) {
            html.br();
            html.start("p");
            html.b(suggestion);
            html.end("p");
        }
        String message = html.toString();
        return MessageDialogPanel.createWarningDialog((String)message, null, (String)advancedMessage, (String)"", null, (String)this.textResource.AdvancedDetails());
    }

    private void displayErrorWithAdvancedMessageDialog(String urcapName, String message, String advancedMessage) {
        ErrorMessage title = new ErrorMessage(this.urcapTextResource.CannotInstallURCap(urcapName), "");
        title.setId(advancedMessage.hashCode());
        this.dialogCreator.showErrorMessageWithCustomPanel((DialogMessage)title, (URDialogPanel)this.getDialogPanelWithAdvancedDetails(message, "", advancedMessage), null);
    }
}

