/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.urcap.osgi.infrastructure.URCapInstallInfrastructureUtil;
import com.ur.urcap.osgi.infrastructure.URCapsServiceImpl;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;

public class URCapInstallInfrastructureUtilImpl
implements URCapInstallInfrastructureUtil {
    @Override
    public void deleteFile(String file) {
        int index = file.indexOf("file:");
        if (index > -1) {
            file = file.substring(index + 5);
        }
        this.delete(new File(file));
    }

    @Override
    public void delete(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            Log.error((String)"Unable to delete file", (Throwable)e);
        }
    }

    @Override
    public void copyFile(File urCapFile, File destFile) throws IOException {
        if (destFile == null) {
            return;
        }
        File dir = new File(URCapsServiceImpl.THIRD_PARTY_BUNDLE_INSTALL_DIR);
        if (!dir.exists()) {
            this.makeDir(dir);
        }
        this.copy(urCapFile, destFile);
    }

    @Override
    public void makeDir(File dir) {
        dir.mkdir();
    }

    @Override
    public void copy(File srcFile, File destFile) throws IOException {
        FileUtils.copy((File)srcFile, (File)destFile);
    }

    @Override
    public void createURCapSymlink(File urcapFolder) {
        try {
            File urcapSymLinkFolder = this.getSymLinkFolder();
            if (urcapFolder == null || urcapSymLinkFolder == null) {
                return;
            }
            Process symLinkProcess = this.createSymLinkProcess(urcapFolder, urcapSymLinkFolder);
            this.runProcess(symLinkProcess);
        }
        catch (Exception e) {
            Log.warning((String)("Failed to create symLink to: " + urcapFolder.getAbsolutePath()), (Throwable)e);
        }
    }

    private void runProcess(Process process) throws InterruptedException {
        process.waitFor();
        process.destroy();
    }

    @Override
    public Process createSymLinkProcess(File urcapFolder, File urcapSymLinkFolder) throws IOException {
        return Runtime.getRuntime().exec(new String[]{"ln", "-s", urcapFolder.getAbsolutePath(), urcapSymLinkFolder.getAbsolutePath()});
    }

    @Override
    public boolean hasSymLink() {
        try {
            return this.isSymlink(this.getSymLinkFolder());
        }
        catch (Exception e) {
            Log.warning((String)"Failed to check for symLink", (Throwable)e);
            return false;
        }
    }

    @Override
    public File getSymLinkFolder() {
        try {
            File bundleDirectory = this.getBundleDirectory();
            return new File(bundleDirectory, "urcaps");
        }
        catch (MalformedURLException e) {
            Log.warning((String)"Malformed URL", (Throwable)e);
            return null;
        }
    }

    private File getBundleDirectory() throws MalformedURLException {
        return new File(new URL("file:bundle").getFile());
    }

    private boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }
}

