/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.urcap.osgi.infrastructure.ThirdPartyBundleManager;
import com.ur.urcap.osgi.infrastructure.URCapInstallErrorLogging;
import com.ur.urcap.osgi.infrastructure.URCapInstallInfrastructureUtil;
import com.ur.urcap.osgi.infrastructure.URCapsServiceImpl;
import gui.tools.DialogCreator;
import java.io.File;
import javax.inject.Inject;
import org.osgi.framework.Bundle;

public class URCapTaskCallbacks {
    private final ThirdPartyBundleManager thirdPartyBundleManager;
    private final URCapInstallErrorLogging errorLogging;
    private final DialogCreator dialogCreator;
    private final TextResource textResource;
    private final URCapInstallInfrastructureUtil infrastructureUtil;

    @Inject
    public URCapTaskCallbacks(URCapInstallErrorLogging errorLogging, URCapInstallInfrastructureUtil infrastructureUtil, ThirdPartyBundleManager thirdPartyBundleManager, DialogCreator dialogCreator, TextResource textResource) {
        this.thirdPartyBundleManager = thirdPartyBundleManager;
        this.errorLogging = errorLogging;
        this.dialogCreator = dialogCreator;
        this.textResource = textResource;
        this.infrastructureUtil = infrastructureUtil;
    }

    public void onAfterInstallBundleBasedURCap(Bundle bundle, URCapsServiceImpl.BundleBasedURCapCallback installCallback) {
        this.thirdPartyBundleManager.processBundle(bundle);
        if (this.thirdPartyBundleManager.moreThanOneVersionInstalled(bundle)) {
            SwingUtil.invokeLater(() -> this.dialogCreator.showMessageDialog(new DialogMessage(this.textResource.URCapDifferentVersionTitle(), this.textResource.URCapDifferentVersion()), MessageDialogType.WARNING, new OkDialogListener()));
        }
        installCallback.onNewURCapInstalled();
    }

    public void onErrorInstallBundleBasedURCap(File urCapFile, File destinationFile, Exception e) {
        this.infrastructureUtil.delete(destinationFile);
        this.errorLogging.onFailToInstallURCap(urCapFile, e);
    }
}

