/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.lang.StringUtils;
import com.ur.polyscope.urcaps.BundleUtils;
import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.URCapZipInfo;
import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityError;
import com.ur.urcap.html.util.HTMLBuilder;
import com.ur.urcap.osgi.bundle.BundleFileInfo;
import com.ur.urcap.osgi.error.URCapError;
import com.ur.urcap.osgi.infrastructure.BundleWrapper;
import com.ur.util.swing.HTML;
import java.util.EnumSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgi.framework.Bundle;

@Singleton
public class URCapsMetaInfoBuilder {
    private com.ur.i18n.TextResource textResource;
    private TextResource urcapTextResource;
    private static final String NEWLINE = HTML.br();

    @Inject
    public URCapsMetaInfoBuilder(com.ur.i18n.TextResource textResource, TextResource urcapTextResource) {
        this.textResource = textResource;
        this.urcapTextResource = urcapTextResource;
    }

    public String getMetaInfo(BundleUtils bundleUtils, BundleWrapper bundleWrapper) {
        String urcapInfo = this.buildMetaInfo(bundleUtils, bundleWrapper);
        if (this.isBundleWithError(bundleWrapper)) {
            String message = this.buildCompatibilityErrorMessage(bundleWrapper);
            urcapInfo = String.valueOf(message) + urcapInfo;
        }
        return urcapInfo;
    }

    private String buildMetaInfo(BundleUtils bundleUtils, BundleWrapper bundleWrapper) {
        switch (bundleWrapper.getType()) {
            case BUNDLE: {
                return this.buildBundleMetaInfo(bundleUtils, bundleWrapper.getBundle());
            }
            case FILE: {
                return this.buildFileMetaInfo(bundleUtils, bundleWrapper.getBundleFileInfo());
            }
            case ZIP: {
                return this.buildZipMetaInfo(bundleWrapper.getZipBasedInfo());
            }
        }
        return "";
    }

    private String buildZipMetaInfo(URCapZipInfo urCapZipInfo) {
        if (urCapZipInfo == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(HTML.fontBold((String)this.urcapTextResource.urcapName())).append(": ").append(urCapZipInfo.getName()).append(NEWLINE);
        sb.append(HTML.fontBold((String)this.urcapTextResource.urcapVersion())).append(": ").append(urCapZipInfo.getVersion()).append(NEWLINE);
        sb.append(HTML.fontBold((String)this.urcapTextResource.Developer())).append(": ").append(urCapZipInfo.getVendorName()).append(NEWLINE);
        sb.append(HTML.fontBold((String)this.urcapTextResource.urcapContactinfo())).append(": ").append(urCapZipInfo.getContactInfo()).append(NEWLINE);
        sb.append(HTML.fontBold((String)this.urcapTextResource.urcapDescription())).append(": ").append(urCapZipInfo.getDescription()).append(NEWLINE);
        sb.append(HTML.fontBold((String)this.urcapTextResource.urcapCopyright())).append(": ").append(urCapZipInfo.getCopyRight()).append(NEWLINE);
        sb.append(HTML.fontBold((String)this.urcapTextResource.urcapLicensetype())).append(": ").append(urCapZipInfo.getLicenseType()).append(NEWLINE);
        if (!StringUtils.isNullOrEmpty((String)urCapZipInfo.getLicense())) {
            sb.append(HTML.fontBold((String)this.urcapTextResource.urcapLicense())).append(": ").append(NEWLINE).append(URCapsMetaInfoBuilder.formatLicenseContents(urCapZipInfo.getLicense())).append(NEWLINE);
        }
        return sb.toString();
    }

    private static String formatLicenseContents(String licenseContents) {
        String[] temp = licenseContents.split("\n");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = temp;
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s).append(NEWLINE);
            ++n2;
        }
        return sb.toString();
    }

    private String buildBundleMetaInfo(BundleUtils bundleUtils, Bundle bundle) {
        if (bundle == null) {
            return "";
        }
        return bundleUtils.buildMetaInfo(bundle);
    }

    private String buildFileMetaInfo(BundleUtils bundleUtils, BundleFileInfo bundleFileInfo) {
        if (bundleFileInfo == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        bundleUtils.buildMetaInfo(EnumSet.of(BundleUtils.BundleMetaField.NAME, BundleUtils.BundleMetaField.VERSION, BundleUtils.BundleMetaField.DEVELOPER, BundleUtils.BundleMetaField.CONTACT_INFO), bundleFileInfo.getHeaders(), sb);
        return sb.toString();
    }

    private boolean isBundleWithError(BundleWrapper bundleWrapper) {
        return bundleWrapper.getBundleError() != null;
    }

    private String buildCompatibilityErrorMessage(BundleWrapper bundleWrapper) {
        URCapError bundleError = bundleWrapper.getBundleError();
        if (bundleError == null) {
            return "";
        }
        HTMLBuilder html = new HTMLBuilder().start("font color=\"red\"").b(this.textResource.Error()).text(":").br();
        this.addMessageSection(html, bundleError);
        this.addIfNeededSuggestionSection(html, bundleError);
        this.addIfNeededAdvancedSection(html, bundleError);
        html.end("font").br();
        return html.toString();
    }

    private void addMessageSection(HTMLBuilder html, URCapError urCapError) {
        String message = urCapError.getLocalizedMessage();
        if (message == null || message.isEmpty()) {
            message = this.urcapTextResource.ErrorStartingURCapNoName();
        }
        html.text(message).br().br();
    }

    private void addIfNeededSuggestionSection(HTMLBuilder html, URCapError urcapError) {
        if (!StringUtils.isNullOrOnlyWhitespace((String)urcapError.getLocalizedSuggestion())) {
            html.b(this.textResource.Suggestion()).text(":").br().text(urcapError.getLocalizedSuggestion()).br().br();
        }
    }

    private void addIfNeededAdvancedSection(HTMLBuilder html, CompatibilityError compatibilityError) {
        if (URCapsMetaInfoBuilder.isRequireAdvancedSection(compatibilityError) && compatibilityError instanceof URCapError) {
            html.b(this.textResource.AdvancedDetails()).text(":").br().appendHtml(((URCapError)compatibilityError).getLocalizedAdvancedMessage()).br();
        }
    }

    private static boolean isRequireAdvancedSection(CompatibilityError compatibilityError) {
        return compatibilityError instanceof URCapError && ((URCapError)compatibilityError).getLocalizedAdvancedMessage() != null && !((URCapError)compatibilityError).getLocalizedAdvancedMessage().isEmpty();
    }
}

