/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.urcaps.contributions.compatibility.BundleCompatibilityValidator;
import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityValidationResult;
import com.ur.swing.taskprogress.TaskMonitor;
import com.ur.urcap.osgi.bundle.BundleFileInfo;
import com.ur.urcap.osgi.infrastructure.InstallBundleURCapTask;
import com.ur.urcap.osgi.infrastructure.InvalidURCapBundle;
import com.ur.urcap.osgi.infrastructure.ThirdPartyBundleManager;
import com.ur.urcap.osgi.infrastructure.URCapFileValidationHelper;
import com.ur.urcap.osgi.infrastructure.URCapInstallErrorLogging;
import com.ur.urcap.osgi.infrastructure.URCapInstallInfrastructureUtil;
import com.ur.urcap.osgi.infrastructure.URCapTaskFactory;
import com.ur.urcap.osgi.infrastructure.URCapsService;
import com.ur.util.concurrent.Task;
import com.ur.util.logging.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.yaml.snakeyaml.Yaml;

@Singleton
public class URCapsServiceImpl
implements URCapsService {
    public static final String THIRD_PARTY_BUNDLE_INSTALL_DIR = String.valueOf(System.getProperty("user.home")) + File.separator + ".urcaps";
    private final ThirdPartyBundleManager thirdPartyBundleManager;
    private final URCapInstallInfrastructureUtil infrastructureUtil;
    private final URCapInstallErrorLogging errorLogging;
    private final BundleCompatibilityValidator compatibilityValidator;
    private final URCapFileValidationHelper urCapFileValidationHelper;
    private final File tmpFile = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "/polyscopebundle/");
    private final TaskMonitor taskMonitor;
    private final File urcapFolder;
    private final FrameworkAdapter frameworkAdapter;
    private final URCapTaskFactory urCapTaskFactory;
    private BundleBasedURCapCallback bundleCallback = new NullBundleBasedURCapCallback();

    @Inject
    public URCapsServiceImpl(ThirdPartyBundleManager thirdPartyBundleManager, BundleCompatibilityValidator compatibilityValidator, URCapFileValidationHelper urCapFileValidationHelper, URCapInstallInfrastructureUtil infrastructureUtil, URCapInstallErrorLogging errorLogging, URCapTaskFactory taskCreatorFactory, TaskMonitor taskMonitor, FrameworkAdapter frameworkAdapter) {
        this.thirdPartyBundleManager = thirdPartyBundleManager;
        this.infrastructureUtil = infrastructureUtil;
        this.errorLogging = errorLogging;
        this.compatibilityValidator = compatibilityValidator;
        this.urCapFileValidationHelper = urCapFileValidationHelper;
        this.urCapTaskFactory = taskCreatorFactory;
        this.taskMonitor = taskMonitor;
        this.frameworkAdapter = frameworkAdapter;
        if (!infrastructureUtil.hasSymLink()) {
            infrastructureUtil.createURCapSymlink(new File(THIRD_PARTY_BUNDLE_INSTALL_DIR));
            this.urcapFolder = infrastructureUtil.getSymLinkFolder();
            this.installAllURCaps(this.urcapFolder);
        } else {
            this.urcapFolder = infrastructureUtil.getSymLinkFolder();
        }
    }

    private void installAllURCaps(File folder) {
        if (folder == null || !folder.exists()) {
            return;
        }
        File[] files = folder.listFiles((dir, name) -> {
            if (dir == null || name == null) {
                return false;
            }
            return name.toLowerCase().endsWith(".jar");
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.installBundle(file);
                ++n2;
            }
        }
    }

    @Override
    public void installURCap(File urCapFile) {
        this.installBundleBasedURCap(urCapFile);
    }

    @Override
    public boolean hasValidOsgiBundle(File urCapXFile) {
        ArrayList<InvalidURCapBundle> invalidOsgiBundles = this.listInvalidOsgiBundles(urCapXFile);
        return invalidOsgiBundles.isEmpty();
    }

    private ArrayList<InvalidURCapBundle> listInvalidOsgiBundles(File urCapXFile) {
        ArrayList<InvalidURCapBundle> invalidOsgiBundles = new ArrayList<InvalidURCapBundle>();
        try {
            try {
                List<String> polyscopeArtifactIds = this.getPolyscopeArtifactIdList(urCapXFile);
                for (String artifactId : polyscopeArtifactIds) {
                    this.validateBundle(urCapXFile, invalidOsgiBundles, artifactId);
                }
            }
            catch (IOException iOException) {
                invalidOsgiBundles.add(new InvalidURCapBundle(urCapXFile.getName()));
                Log.error((String)("Error validating polyscope bundles for URCap " + urCapXFile.getName()));
                this.deleteTempPolyscopeBundle();
            }
        }
        finally {
            this.deleteTempPolyscopeBundle();
        }
        return invalidOsgiBundles;
    }

    private void validateBundle(File urCapXFile, ArrayList<InvalidURCapBundle> invalidOsgiBundles, String artifactId) throws IOException {
        File polyscopeBundle = this.extractPolyscopeBundle(urCapXFile, artifactId);
        if (!this.isExtractedPolyscopeBundleValid(urCapXFile, polyscopeBundle)) {
            invalidOsgiBundles.add(new InvalidURCapBundle(artifactId));
        } else {
            this.validateAPICompatibility(invalidOsgiBundles, artifactId, polyscopeBundle);
        }
    }

    private boolean isExtractedPolyscopeBundleValid(File urCapXFile, File polyscopeBundle) {
        if (polyscopeBundle == null) {
            Log.warning((String)("Cannot obtain polyscope bundle for URCap " + urCapXFile.getName() + " for installing, skipping validations"));
            return false;
        }
        return this.validateURCapXBunlde(polyscopeBundle);
    }

    private boolean validateURCapXBunlde(File polyscopeBundle) {
        if (polyscopeBundle == null || !polyscopeBundle.exists()) {
            return false;
        }
        if (!this.urCapFileValidationHelper.hasManifestFile(polyscopeBundle)) {
            return false;
        }
        if (!this.isThirdPartyURCap(polyscopeBundle)) {
            return false;
        }
        if (!this.urCapFileValidationHelper.checkIfManifestExistsAsFirstTwoEntriesInJar(polyscopeBundle)) {
            return false;
        }
        return this.urCapFileValidationHelper.validateRequiredProperties(polyscopeBundle);
    }

    private void validateAPICompatibility(ArrayList<InvalidURCapBundle> invalidOsgiBundles, String artifactId, File polyscopeBundle) {
        CompatibilityValidationResult validationResult = this.compatibilityValidator.validateAPIRequirements(polyscopeBundle);
        if (!validationResult.isCompatible()) {
            invalidOsgiBundles.add(new InvalidURCapBundle(artifactId, validationResult));
        }
    }

    private void deleteTempPolyscopeBundle() {
        try {
            FileUtils.deleteDirectory((File)this.tmpFile);
        }
        catch (IOException e) {
            Log.error((String)"Could not delete tmp file", (Throwable)e);
        }
    }

    protected boolean isZipBased(File urCapFile) {
        String fileType = "";
        String urCapAbsolutPath = urCapFile.getAbsolutePath();
        try {
            fileType = this.getFiletype(urCapAbsolutPath);
        }
        catch (IOException ioException) {
            Log.error((String)ioException.getMessage(), (Throwable)ioException);
        }
        return fileType.contains("Zip") && urCapAbsolutPath.endsWith("urcapx");
    }

    private String getFiletype(String absolutePath) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command("file", "-b", absolutePath);
        Process process = processBuilder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        return reader.readLine();
    }

    private void installBundleBasedURCap(File urCapFile) {
        new Thread(() -> {
            if (!this.isValid(urCapFile, urCapFile) || !this.isCompatible(urCapFile)) {
                return;
            }
            try {
                this.uninstallOriginalIfUpdating(urCapFile);
                this.infrastructureUtil.copyFile(urCapFile, this.getDestinationFile(urCapFile));
                this.installBundle(urCapFile);
            }
            catch (IOException e) {
                Log.error((String)("Cannot install URCap: " + urCapFile.getAbsolutePath()), (Throwable)e);
                this.errorLogging.onFailToCopyURCapFile(urCapFile, e);
            }
        }).start();
    }

    private boolean isValid(File urCapFile, File polyscopeBundle) {
        if (!this.isValidFile(urCapFile, polyscopeBundle)) {
            return false;
        }
        return this.isZipBased(urCapFile) || this.isValidBundle(urCapFile, polyscopeBundle);
    }

    private boolean isValidFile(File urCapFile, File polyscopeBundle) {
        if (!this.urCapFileValidationHelper.hasManifestFile(polyscopeBundle)) {
            this.errorLogging.logErrorForMissingManifest(urCapFile, polyscopeBundle);
            return false;
        }
        if (!this.isThirdPartyURCap(polyscopeBundle)) {
            this.errorLogging.logErrorForInvalidBundleCategory(urCapFile, polyscopeBundle);
            return false;
        }
        if (!this.urCapFileValidationHelper.checkIfManifestExistsAsFirstTwoEntriesInJar(polyscopeBundle)) {
            this.errorLogging.onInvalidManifest(urCapFile, polyscopeBundle);
            return false;
        }
        if (!this.urCapFileValidationHelper.validateRequiredProperties(polyscopeBundle)) {
            this.errorLogging.onMissingBundlePropertiesInManifest(urCapFile, polyscopeBundle);
            return false;
        }
        return this.isZipBased(urCapFile) || !this.isDuplicateWithDifferentFileName(urCapFile, polyscopeBundle);
    }

    private boolean isCompatible(File file) {
        CompatibilityValidationResult validationResult = this.compatibilityValidator.validate(file);
        if (!validationResult.isCompatible()) {
            this.errorLogging.onIncompatibleFile(file, validationResult);
            return false;
        }
        return true;
    }

    private boolean isThirdPartyURCap(File file) {
        String bundleCategory = this.urCapFileValidationHelper.getBundleCategory(file);
        return "urcap".equalsIgnoreCase(bundleCategory);
    }

    private boolean isDuplicateWithDifferentFileName(File urCapFile, File polyscopeBundle) {
        Bundle dupBundle = this.urCapFileValidationHelper.getBundleWithDuplicateSymbolicNameAndVersion(polyscopeBundle, this.getBundleContext());
        if (dupBundle != null) {
            try {
                String urcapNameAfterInstallation = this.getDestinationURCapName(polyscopeBundle);
                String duplicateBundleName = new File(dupBundle.getLocation()).getName();
                if (!urcapNameAfterInstallation.equals(duplicateBundleName)) {
                    this.errorLogging.onDuplicateBundleExists(urCapFile.getName(), duplicateBundleName);
                    return true;
                }
            }
            catch (IOException iOException) {
                this.errorLogging.onInvalidURCap(urCapFile);
                return true;
            }
        }
        return false;
    }

    private boolean isValidBundle(File urCapFile, File polyscopeBundle) {
        boolean isValid;
        block13: {
            isValid = true;
            if (!this.isDuplicateWithSameName(polyscopeBundle)) {
                Bundle temporaryBundle = null;
                try {
                    try {
                        temporaryBundle = this.temporarilyInstallBundle(polyscopeBundle);
                    }
                    catch (BundleException e) {
                        Log.error((String)("Cannot install URCap: " + polyscopeBundle.getAbsolutePath()), (Throwable)e);
                        this.onFailToTemporarilyInstallURCap(urCapFile, polyscopeBundle, e);
                        isValid = false;
                        if (temporaryBundle == null) break block13;
                        try {
                            temporaryBundle.uninstall();
                        }
                        catch (BundleException e2) {
                            Log.error((String)"Failed to uninstall temporary urcap", (Throwable)e2);
                            isValid = false;
                        }
                    }
                }
                finally {
                    if (temporaryBundle != null) {
                        try {
                            temporaryBundle.uninstall();
                        }
                        catch (BundleException e) {
                            Log.error((String)"Failed to uninstall temporary urcap", (Throwable)e);
                            isValid = false;
                        }
                    }
                }
            }
        }
        return isValid;
    }

    private void onFailToTemporarilyInstallURCap(File urcapFile, File polyscopeBundle, BundleException e) {
        String message = e.getMessage();
        if (e.getCause() != null) {
            message = String.valueOf(message) + e.getCause().getMessage();
        }
        this.errorLogging.onExceptionDueToInvalidManifest(urcapFile, polyscopeBundle, message);
    }

    private Bundle temporarilyInstallBundle(File urCapFile) throws BundleException {
        String bundleURI = "reference:file:" + urCapFile.getPath();
        return this.getBundleContext().installBundle(bundleURI);
    }

    private boolean isDuplicateWithSameName(File urCapFile) {
        if (urCapFile == null) {
            return false;
        }
        Bundle dupBundle = this.urCapFileValidationHelper.getBundleWithDuplicateSymbolicNameAndVersion(urCapFile, this.getBundleContext());
        if (dupBundle != null) {
            String duplicateBundleName = new File(dupBundle.getLocation()).getName();
            File destinationFile = this.getDestinationFile(urCapFile);
            String destinationFileName = destinationFile != null ? destinationFile.getName() : "";
            return duplicateBundleName.equals(destinationFileName);
        }
        return false;
    }

    private String getDestinationURCapName(File urCapFile) throws IOException {
        return String.valueOf(this.urCapFileValidationHelper.getSymbolicNameAndVersion(urCapFile)) + ".jar";
    }

    private void uninstallOriginalIfUpdating(File urCapFile) {
        Bundle bundleToBeUpdated = this.urCapFileValidationHelper.getBundleWithDuplicateSymbolicNameAndVersion(urCapFile, this.getBundleContext());
        if (bundleToBeUpdated != null) {
            this.uninstallBundle(bundleToBeUpdated);
        }
    }

    private List<String> getPolyscopeArtifactIdList(File urCapXFile) throws IOException {
        ArrayList<String> polyscopeArtifactId = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(urCapXFile);){
                ZipEntry e = zipFile.getEntry("manifest.yaml");
                InputStream ip = zipFile.getInputStream(e);
                Yaml yaml = new Yaml();
                HashMap yamlMap = (HashMap)yaml.load(ip);
                LinkedHashMap artifacts = (LinkedHashMap)yamlMap.get("artifacts");
                ArrayList osgiBundles = (ArrayList)artifacts.get("osgiBundles");
                for (LinkedHashMap bundle : osgiBundles) {
                    polyscopeArtifactId.add((String)bundle.get("name"));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClassCastException exception) {
            Log.error((String)exception.getMessage());
            throw new IOException();
        }
        return polyscopeArtifactId;
    }

    private File extractPolyscopeBundle(File urCapFile, String polyscopeArtifactId) throws IOException {
        File jarBundleFile = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipFile zipFile = new ZipFile(urCapFile);){
            Enumeration<? extends ZipEntry> enu = zipFile.entries();
            while (enu.hasMoreElements()) {
                ZipEntry zipEntry = enu.nextElement();
                String name = zipEntry.getName();
                File file = new File(this.tmpFile.getCanonicalFile() + "/" + name);
                if (name.startsWith(polyscopeArtifactId) && name.endsWith(".jar")) {
                    jarBundleFile = file;
                }
                if (name.endsWith("/")) {
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                this.extractFile(zipFile, zipEntry, file);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return jarBundleFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractFile(ZipFile zipFile, ZipEntry zipEntry, File file) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)fileOutputStream, (byte[])new byte[0x100000]);
                }
                if (inputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public void uninstallURCap(Bundle bundle) {
        String file = bundle.getLocation();
        this.uninstallBundle(bundle);
        this.infrastructureUtil.deleteFile(file);
    }

    @Override
    public void uninstallURCapFile(BundleFileInfo bundleFileInfo) {
        String file = bundleFileInfo.getFileLocation();
        this.thirdPartyBundleManager.uninstall(bundleFileInfo);
        this.infrastructureUtil.deleteFile(file);
    }

    @Override
    public void addBundleListener(BundleListener bundleListener) {
        this.getBundleContext().addBundleListener(bundleListener);
    }

    @Override
    public void removeBundleListener(BundleListener bundleListener) {
        this.getBundleContext().removeBundleListener(bundleListener);
    }

    BundleContext getBundleContext() {
        return this.frameworkAdapter.getBundle(this.getClass()).getBundleContext();
    }

    private void uninstallBundle(Bundle bundle) {
        try {
            this.thirdPartyBundleManager.uninstall(bundle);
            bundle.uninstall();
        }
        catch (BundleException e) {
            Log.error((String)("Cannot uninstall bundle: " + bundle.getSymbolicName()), (Throwable)e);
        }
    }

    private File getDestinationFile(File sourceFile) {
        if (sourceFile == null || !sourceFile.exists()) {
            return null;
        }
        try {
            String destFileName = this.getDestinationURCapName(sourceFile);
            return new File(this.urcapFolder, destFileName);
        }
        catch (IOException e) {
            Log.error((String)("Cannot access URCap file " + sourceFile.getName()), (Throwable)e);
            this.errorLogging.onFailToCopyURCapFile(sourceFile, e);
            return null;
        }
    }

    private void installBundle(File urCapFile) {
        File destFile = this.getDestinationFile(urCapFile);
        if (destFile == null) {
            return;
        }
        this.spawnInstallBundleBasedURCapTask(urCapFile, destFile);
    }

    private void spawnInstallBundleBasedURCapTask(File urcapFile, File destinationFile) {
        new Thread(() -> {
            InstallBundleURCapTask installTask = this.urCapTaskFactory.getInstallTaskForJARBasedURCap(urcapFile, destinationFile, this.getBundleContext(), this.bundleCallback);
            this.taskMonitor.wait(this.taskMonitor.run((Task)installTask));
        }).start();
    }

    @Override
    public void setCallbackForBundleEvents(BundleBasedURCapCallback callback) {
        this.bundleCallback = callback;
    }

    public static abstract class BundleBasedURCapCallback {
        abstract void onNewURCapInstalled();
    }

    private static class NullBundleBasedURCapCallback
    extends BundleBasedURCapCallback {
        private NullBundleBasedURCapCallback() {
        }

        @Override
        void onNewURCapInstalled() {
        }
    }
}

