/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure.helper;

import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.urcaps.SourceLoggable;
import com.ur.polyscope.urcaps.URCapStartFilter;
import com.ur.polyscope.urcaps.contributions.compatibility.BundleCompatibilityValidator;
import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityError;
import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityValidationResult;
import com.ur.urcap.osgi.URCapFailureHandler;
import com.ur.urcap.osgi.URCapProblemHandler;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class URCapHelper {
    public static final String BUNDLE_CATEGORY = "Bundle-Category";
    private static final Logger LOG = LogFactory.createLogger(URCapHelper.class);
    private final URCapFailureHandler urCapFailureHandler;
    List<Bundle> filteredBundlesNotStarting = new ArrayList<Bundle>();

    public URCapHelper(URCapProblemHandler urCapProblemHandler) {
        this.urCapFailureHandler = urCapProblemHandler.getFailureHandler();
    }

    public static boolean isThirdPartyURCap(Bundle b) {
        boolean isThirdPartyURCap = false;
        if (b != null) {
            String categories = (String)b.getHeaders().get(BUNDLE_CATEGORY);
            isThirdPartyURCap = categories != null && "urcap".equalsIgnoreCase(categories);
        }
        return isThirdPartyURCap;
    }

    public List<Bundle> getFilteredBundlesNotStarting() {
        return this.filteredBundlesNotStarting;
    }

    public List<Bundle> getBundlesToStart(BundleContext context, URCapStartFilter[] urCapStartFilters, BundleCompatibilityValidator validator) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Bundle each : this.getThirdPartyBundles(context)) {
            if (!this.eligibleToStart(each, urCapStartFilters, validator) || each.getState() == 32) continue;
            this.onlyAddNewestVersionToList(bundles, each);
        }
        return bundles;
    }

    public ArrayList<Bundle> getThirdPartyBundles(BundleContext context) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (context != null) {
            Bundle[] bundleArray = context.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle each = bundleArray[n2];
                if (URCapHelper.isThirdPartyURCap(each)) {
                    bundles.add(each);
                }
                ++n2;
            }
        }
        return bundles;
    }

    public boolean eligibleToStart(Bundle bundle, URCapStartFilter[] urCapStartFilters, BundleCompatibilityValidator bundleCompatibilityValidator) {
        CompatibilityValidationResult validationResult;
        if (bundleCompatibilityValidator != null && !this.isZipInstalledJar(bundle) && !(validationResult = bundleCompatibilityValidator.validate(bundle)).isCompatible()) {
            CompatibilityError error = validationResult.getError();
            this.urCapFailureHandler.logCompatibilityError(error, bundle);
            return false;
        }
        URCapStartFilter[] uRCapStartFilterArray = urCapStartFilters;
        int n = urCapStartFilters.length;
        int n2 = 0;
        while (n2 < n) {
            URCapStartFilter filter = uRCapStartFilterArray[n2];
            this.setupStartFilterLogging(bundle, filter);
            if (!filter.allowStart(bundle)) {
                this.filteredBundlesNotStarting.add(bundle);
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isZipInstalledJar(Bundle bundle) {
        String bundleLocation = this.getBundleLocation(bundle);
        try {
            File bundleFile = new File(bundleLocation);
            return "zip".equalsIgnoreCase(bundleFile.getParentFile().getName());
        }
        catch (Exception e) {
            LOG.error("Unable to get bundle location", new Object[]{e.getMessage()});
            return false;
        }
    }

    private void setupStartFilterLogging(Bundle bundle, URCapStartFilter filter) {
        if (filter instanceof SourceLoggable) {
            ((SourceLoggable)filter).setLoggingCallback(error -> this.urCapFailureHandler.logCompatibilityError((CompatibilityError)error, bundle));
        }
    }

    private void onlyAddNewestVersionToList(ArrayList<Bundle> bundles, Bundle newBundle) {
        Bundle toRemove = null;
        for (Bundle bundleInList : bundles) {
            if (this.isBundleVersionB1LowerThanB2(bundleInList, newBundle)) {
                toRemove = bundleInList;
                this.filteredBundlesNotStarting.add(toRemove);
                break;
            }
            if (!this.isBundleVersionB1LowerThanB2(newBundle, bundleInList)) continue;
            Log.warning((String)("Not starting URCap because a newer version is installed: " + newBundle.getSymbolicName() + " (" + newBundle.getVersion() + ")"));
            this.filteredBundlesNotStarting.add(newBundle);
            return;
        }
        if (toRemove != null) {
            Log.warning((String)("Not starting URCap because a newer version is installed: " + toRemove.getSymbolicName() + " (" + toRemove.getVersion() + ")"));
            bundles.remove(toRemove);
        }
        bundles.add(newBundle);
    }

    private boolean isBundleVersionB1LowerThanB2(Bundle b1, Bundle b2) {
        return b1.getSymbolicName().equals(b2.getSymbolicName()) && b1.getVersion().compareTo(b2.getVersion()) < 0;
    }

    public String getBundleLocation(Bundle bundle) {
        String location = bundle.getLocation();
        location = this.removeFirst(location, "reference:");
        location = this.removeFirst(location, "file:");
        return location;
    }

    private String removeFirst(String location, String remove) {
        if (location.startsWith(remove)) {
            Log.info((String)("Removing '" + remove + "' from bundle location : " + location));
            return location.replaceFirst(remove, "");
        }
        return location;
    }

    public HashSet<String> getURCapPaths(List<Bundle> knownBundles) throws IOException {
        HashSet<String> result = new HashSet<String>();
        for (Bundle bundle : knownBundles) {
            String bundleLocation = this.getBundleLocation(bundle);
            result.add(new File(bundleLocation).getCanonicalPath());
        }
        return result;
    }
}

