/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.ui.main.impl;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.MoveTab;
import com.ur.polyscope.move.legacy.MoveCallback;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.urcaps.jointposition.robotposition.PositionParametersBuilder;
import com.ur.swing.FlipManager;
import com.ur.swing.SwingUtil;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.jointposition.JointPositionFactory;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.robotposition.PositionParameters;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.ui.main.impl.RobotPosition$RobotPositionMoveCallback$1$AjcClosure1;
import com.ur.urcap.ui.main.impl.RobotPosition$RobotPositionMoveCallback$2$AjcClosure1;
import com.ur.urcap.ui.main.impl.UserInteractionFactories;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import javax.inject.Provider;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

class RobotPosition {
    private final Provider<FlipManager> fmProvider;
    private final UserInteractionFactories factories;
    private final JointPositionFactory jointPositionFactory;
    private final PoseFactory poseFactory;
    private final Provider<PositionParametersBuilder> positionParametersBuilderProvider;

    @Inject
    RobotPosition(Provider<FlipManager> fmProvider, UserInteractionFactories factories, JointPositionFactory jointPositionFactory, PoseFactory poseFactory, Provider<PositionParametersBuilder> positionParametersBuilderProvider) {
        this.fmProvider = fmProvider;
        this.factories = factories;
        this.jointPositionFactory = jointPositionFactory;
        this.poseFactory = poseFactory;
        this.positionParametersBuilderProvider = positionParametersBuilderProvider;
    }

    public void getUserDefinedRobotPosition(final RobotPositionCallback2 callback) {
        CallbackAdapter callbackAdapter = new CallbackAdapter(){

            @Override
            public void onOk(Pose pose, JointPositions jointPositions, Pose tcpOffset) {
                PositionParametersBuilder builder = (PositionParametersBuilder)RobotPosition.this.positionParametersBuilderProvider.get();
                PositionParameters positionParameters = builder.setQNear(jointPositions).setTCPOffset(tcpOffset).build(pose);
                callback.onOk(positionParameters);
            }

            @Override
            public void onCancel() {
                callback.onCancel();
            }
        };
        this.doGetUserDefinedRobotPosition(callbackAdapter);
    }

    public void getUserDefinedRobotPosition(final RobotPositionCallback callback) {
        CallbackAdapter callbackAdapter = new CallbackAdapter(){

            @Override
            public void onOk(Pose pose, JointPositions jointPositions, Pose tcpOffset) {
                callback.onOk(pose, jointPositions);
            }

            @Override
            public void onCancel() {
                callback.onCancel();
            }
        };
        this.doGetUserDefinedRobotPosition(callbackAdapter);
    }

    private void doGetUserDefinedRobotPosition(CallbackAdapter robotPositionCallback) {
        FlipManager flipManager = (FlipManager)this.fmProvider.get();
        RobotPositionMoveCallback moveCallback = new RobotPositionMoveCallback(robotPositionCallback);
        new Thread(() -> {
            boolean bl = flipManager.stackCurrentCardAndSwitchTo(MoveTab.class, (Object)moveCallback);
        }).start();
    }

    private static interface CallbackAdapter {
        public void onOk(Pose var1, JointPositions var2, Pose var3);

        public void onCancel();
    }

    private class RobotPositionMoveCallback
    implements MoveCallback {
        private final CallbackAdapter robotPositionCallback;

        public RobotPositionMoveCallback(CallbackAdapter robotPositionCallback) {
            this.robotPositionCallback = robotPositionCallback;
        }

        public void onOk(Pose6d p, JointPositionVector jpv, Pose6d tcpOffset) {
            double[] joints = jpv.getJoints();
            final JointPositions jointPositions = RobotPosition.this.jointPositionFactory.createJointPositions(joints[0], joints[1], joints[2], joints[3], joints[4], joints[5], Angle.Unit.RAD);
            final Pose pose = RobotPosition.this.poseFactory.createPose(p.getX(), p.getY(), p.getZ(), p.getRX(), p.getRY(), p.getRZ(), Length.Unit.M, Angle.Unit.RAD);
            final Pose tcpOffsetPose = RobotPosition.this.poseFactory.createPose(tcpOffset.getX(), tcpOffset.getY(), tcpOffset.getZ(), tcpOffset.getRX(), tcpOffset.getRY(), tcpOffset.getRZ(), Length.Unit.M, Angle.Unit.RAD);
            SwingUtil.invokeLater((Runnable)new Runnable(){
                private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

                @Override
                public void run() {
                    try {
                        this.compoundProgramChangeWrappedOnOk();
                    }
                    catch (Exception exception) {
                        Log.error((String)"Error in robotPositionCallback.onOk", (Throwable)exception);
                        ((RobotPosition)((RobotPositionMoveCallback)RobotPositionMoveCallback.this).RobotPosition.this).factories.exceptionHandling.showURCapExceptionDialog(exception, Thread.currentThread().getStackTrace()[1], RobotPositionMoveCallback.this.robotPositionCallback.getClass());
                    }
                }

                @CompoundProgramChange
                private void compoundProgramChangeWrappedOnOk() {
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    Object[] objectArray = new Object[]{this, joinPoint};
                    RobotPosition$RobotPositionMoveCallback$1$AjcClosure1 robotPosition$RobotPositionMoveCallback$1$AjcClosure1 = new RobotPosition$RobotPositionMoveCallback$1$AjcClosure1(objectArray);
                    ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(robotPosition$RobotPositionMoveCallback$1$AjcClosure1.linkClosureAndJoinPoint(69648));
                }

                static {
                    1.ajc$preClinit();
                }

                static final /* synthetic */ void compoundProgramChangeWrappedOnOk_aroundBody0(1 ajc$this, JoinPoint joinPoint) {
                    ajc$this.RobotPositionMoveCallback.this.robotPositionCallback.onOk(ajc$this.pose, ajc$this.jointPositions, ajc$this.tcpOffsetPose);
                }

                private static /* synthetic */ void ajc$preClinit() {
                    Factory factory = new Factory("RobotPosition.java", 1.class);
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "compoundProgramChangeWrappedOnOk", "com.ur.urcap.ui.main.impl.RobotPosition$RobotPositionMoveCallback$1", "", "", "", "void"), 135);
                }
            });
        }

        public void onCancel() {
            SwingUtil.invokeLater((Runnable)new Runnable(){
                private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

                @Override
                public void run() {
                    try {
                        this.compoundProgramChangeWrappedOnCancel();
                    }
                    catch (Exception exception) {
                        Log.error((String)"Error in robotPositionCallback.onCancel", (Throwable)exception);
                        ((RobotPosition)((RobotPositionMoveCallback)RobotPositionMoveCallback.this).RobotPosition.this).factories.exceptionHandling.showURCapExceptionDialog(exception, Thread.currentThread().getStackTrace()[1], RobotPositionMoveCallback.this.robotPositionCallback.getClass());
                    }
                }

                @CompoundProgramChange
                private void compoundProgramChangeWrappedOnCancel() {
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                    Object[] objectArray = new Object[]{this, joinPoint};
                    RobotPosition$RobotPositionMoveCallback$2$AjcClosure1 robotPosition$RobotPositionMoveCallback$2$AjcClosure1 = new RobotPosition$RobotPositionMoveCallback$2$AjcClosure1(objectArray);
                    ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(robotPosition$RobotPositionMoveCallback$2$AjcClosure1.linkClosureAndJoinPoint(69648));
                }

                static {
                    2.ajc$preClinit();
                }

                static final /* synthetic */ void compoundProgramChangeWrappedOnCancel_aroundBody0(2 ajc$this, JoinPoint joinPoint) {
                    ajc$this.RobotPositionMoveCallback.this.robotPositionCallback.onCancel();
                }

                private static /* synthetic */ void ajc$preClinit() {
                    Factory factory = new Factory("RobotPosition.java", 2.class);
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "compoundProgramChangeWrappedOnCancel", "com.ur.urcap.ui.main.impl.RobotPosition$RobotPositionMoveCallback$2", "", "", "", "void"), 156);
                }
            });
        }
    }
}

