/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.ui.main.impl;

import com.ur.monitor.requirements.RunningRobotRequirement;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.SwingUtil;
import com.ur.urcap.ui.main.impl.URCapBundleRequirement;
import com.ur.urcap.ui.main.impl.UserInteractionFactories;
import com.ur.urcap.ui.main.impl.UserInteractionImpl;
import com.ur.util.Waiting;
import com.ur.view.gui.OpenCloseVeto;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Provider;

public class ScreenTransitionWorkflow {
    private static final Logger LOGGER = LogFactory.createLogger(ScreenTransitionWorkflow.class);
    private final Provider<FlipManager> flipManager;
    private final RunningRobotRequirement runningRobotRequirement;
    private final URCapBundleRequirement urCapBundleRequirement;
    private final UserInteractionFactories factories;

    @Inject
    ScreenTransitionWorkflow(Provider<FlipManager> flipManager, RunningRobotRequirement runningRobotRequirement, URCapBundleRequirement urCapBundleRequirement, UserInteractionFactories factories) {
        this.flipManager = flipManager;
        this.runningRobotRequirement = runningRobotRequirement;
        this.urCapBundleRequirement = urCapBundleRequirement;
        this.factories = factories;
    }

    void doTransition(UserInteractionImpl.EnsureOnceOnly callerInstance, SuccessfulTransition successfulTransition, CancelTransition cancelTransition) {
        if (!this.canTransition(callerInstance, (FlipManager)this.flipManager.get())) {
            cancelTransition.cancel();
            return;
        }
        CardPanel cardPanel = CardPanel.getCurrentPanel();
        try {
            ScreenTransitionWorkflow.enableVetoTransitionsForContributions(cardPanel);
            successfulTransition.transition();
        }
        finally {
            this.handleTransitionFailed(callerInstance, cardPanel, cancelTransition);
        }
    }

    private void handleTransitionFailed(UserInteractionImpl.EnsureOnceOnly callerInstance, CardPanel cardPanel, CancelTransition cancelTransition) {
        Runnable waitForTransition = () -> this.onWaitingToTransition(callerInstance, cardPanel);
        Function<Exception, Runnable> onFailedTransition = e -> () -> {
            LOGGER.error("Error occurred during transition", (Throwable)e);
            this.disableVetoTransitionForContributions(cardPanel);
            cancelTransition.cancel();
        };
        this.performOnWorkerThread(waitForTransition, onFailedTransition);
    }

    private void onWaitingToTransition(UserInteractionImpl.EnsureOnceOnly callerInstance, CardPanel cardPanel) {
        while (true) {
            boolean hasBeenInvoked = callerInstance.hasBeenInvoked();
            boolean isCardStackEmpty = ((FlipManager)this.flipManager.get()).isCardStackEmpty();
            if (hasBeenInvoked && isCardStackEmpty) {
                SwingUtil.invokeLater(() -> this.disableVetoTransitionForContributions(cardPanel));
                return;
            }
            if (hasBeenInvoked) {
                return;
            }
            if (!isCardStackEmpty) {
                return;
            }
            Waiting.pause((long)20L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    void performOnWorkerThread(Runnable onWaitingToTransition, Function<Exception, Runnable> onFailedTransition) {
        new Thread(() -> {
            try {
                onWaitingToTransition.run();
            }
            catch (Exception e) {
                SwingUtil.invokeLater((Runnable)((Runnable)onFailedTransition.apply(e)));
            }
        }).start();
    }

    private boolean canTransition(UserInteractionImpl.EnsureOnceOnly callerInstance, FlipManager fm) {
        return fm != null && this.factories.guiReadyEvaluator.isGuiReady() && this.runningRobotRequirement.checkAndNotify() && this.urCapBundleRequirement.checkAndNotify(callerInstance.getWrappedCallback());
    }

    private static void enableVetoTransitionsForContributions(CardPanel cardPanel) {
        if (cardPanel instanceof OpenCloseVeto) {
            ((OpenCloseVeto)cardPanel).vetoCloseOpenOnce();
        }
    }

    private void disableVetoTransitionForContributions(CardPanel cardPanel) {
        if (cardPanel instanceof OpenCloseVeto) {
            ((OpenCloseVeto)cardPanel).revokeVeto();
        }
    }

    static interface CancelTransition {
        public void cancel();
    }

    static interface SuccessfulTransition {
        public void transition();
    }
}

