/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi;

import com.ur.polyscope.immi.ImmiSignal;
import com.ur.polyscope.immi.ImmiSignalService;
import com.ur.polyscope.installation.IgnorePersistence;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.scriptwriter.PreambleScript;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.view.constants.immi.ImmiType;
import java.util.ArrayList;
import javax.inject.Inject;

public class Immi
implements InstallationComponent,
PreambleScript,
IgnorePersistence {
    public static final int IMMI_NUMBER_OF_INPUT_BITS = 21;
    public static final int IMMI_NUMBER_OF_OUTPUT_BITS = 16;
    private final int[] immiOutputModificationChoice;
    private final OutputPinAction[] outputPinAction;
    private ImmiType immiType = ImmiType.NOT_PRESENT;
    private ImmiSignalService immiSignalService;

    public Immi() {
        this(null);
    }

    @Inject
    public Immi(ImmiSignalService immiSignalService) {
        this.immiSignalService = immiSignalService;
        this.immiOutputModificationChoice = new int[16];
        this.outputPinAction = new OutputPinAction[16];
        this.initImmiFlags();
    }

    private void initImmiFlags() {
        int i = 0;
        while (i < 16) {
            this.immiOutputModificationChoice[i] = 1;
            this.outputPinAction[i] = OutputPinAction.NONE;
            ++i;
        }
    }

    public Class<?> getType() {
        return Immi.class;
    }

    public boolean isEnabled() {
        return this.immiType != ImmiType.NOT_PRESENT;
    }

    public ImmiType getImmiType() {
        return this.immiType;
    }

    public void setImmiType(ImmiType newImmiType) {
        this.immiType = newImmiType;
    }

    public void setImmiOutputModificationChoice(int[] integerArrayValue) {
        int i = 0;
        while (i < integerArrayValue.length) {
            this.setImmiOutputModificationChoice(i, integerArrayValue[i]);
            ++i;
        }
    }

    public void setImmiOutputPinAction(int outputNumber, OutputPinAction outputPinAction) {
        if (outputNumber >= 0 && outputNumber < 16) {
            this.outputPinAction[outputNumber] = outputPinAction;
        } else {
            Log.error((String)"RobotInstallation: The immi output number or the output action was not in the valid range");
        }
        this.fireInstallationChangedEvent();
    }

    public OutputPinAction getImmiOutputPinAction(int outputNumber) {
        return this.outputPinAction[outputNumber];
    }

    private void fireInstallationChangedEvent() {
        EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

            public void notify(InstallationStateListener listener) {
                listener.installationModified();
            }
        });
    }

    public void setImmiOutputModificationChoice(int outputNumber, int modificationChoice) {
        if (outputNumber >= 0 && outputNumber < 16 && modificationChoice >= 0 && modificationChoice < 3) {
            this.immiOutputModificationChoice[outputNumber] = modificationChoice;
            this.fireInstallationChangedEvent();
        } else {
            Log.error((String)"RobotInstallation: The immi output number or the given modification choice was not in the valid range");
        }
    }

    public int[] getImmiOutputModificationChoice() {
        return this.immiOutputModificationChoice;
    }

    public int getImmiOutputModificationChoice(int outputNumber) {
        int returnval = -1;
        if (outputNumber >= 0 && outputNumber < 16) {
            returnval = this.immiOutputModificationChoice[outputNumber];
        } else {
            Log.error((String)("RobotInstallation: The immi output number \" " + outputNumber + "\" was not in the valid range, returning -1"));
        }
        return returnval;
    }

    public boolean canGenerateScriptCode() {
        return this.isEnabled();
    }

    public void generatePreambleScript(ScriptWriter writer, ScriptGeneratorLookup scriptGeneratorLookup) {
        for (ImmiSignal sig : this.immiSignalService.getOutputs()) {
            if (this.getImmiOutputPinAction(sig.getPin()).isProgramStatePreservedAtProgramStop()) continue;
            writer.appendLine(sig.generateRunstateDependentChoice());
        }
    }

    public String[] getOutputPinActionsAsString() {
        ArrayList<String> s = new ArrayList<String>();
        OutputPinAction[] outputPinActionArray = this.outputPinAction;
        int n = this.outputPinAction.length;
        int n2 = 0;
        while (n2 < n) {
            OutputPinAction action = outputPinActionArray[n2];
            s.add(action.toString());
            ++n2;
        }
        return s.toArray(new String[0]);
    }

    public void setOutputPinActionsFromString(String[] s) {
        int i = 0;
        while (i < s.length) {
            this.setImmiOutputPinAction(i, OutputPinAction.valueOf((String)s[i]));
            ++i;
        }
    }
}

