/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi;

import com.ur.polyscope.immi.ControllerSocketSender;
import com.ur.polyscope.immi.ImmiImageResource;
import com.ur.view.constants.immi.ImmiInputSignal;
import com.ur.view.constants.immi.ImmiOutputSignal;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public abstract class ImmiIOPanel
extends Box {
    private long timeWhenButtonIsPressed = 0L;
    private static final Icon LOCKED_OUTPUT_ON = ImmiImageResource.selectedGreyIO();
    private static final Icon LOCKED_OUTPUT_OFF = ImmiImageResource.unselectedGreyIO();
    private static final Icon OUTPUT_ON = ImmiImageResource.selectedIO();
    private static final Icon OUTPUT_OFF = ImmiImageResource.unselectedIO();

    public ImmiIOPanel(int axis) {
        super(axis);
    }

    protected void initLayout(JPanel westPanel, JPanel eastPanel) {
        this.initOutputSignalButtonLook(this.getOutputSignalButtonMap());
        this.initInputSignalButtonLook(this.getInputSignalButtonMap());
        this.initializeImmiActions();
        westPanel.setAlignmentY(0.0f);
        eastPanel.setAlignmentY(0.0f);
        westPanel.setPreferredSize(new Dimension(400, 0));
        this.add(westPanel);
        this.add(Box.createHorizontalStrut(5));
        this.add(eastPanel);
    }

    protected void addImmiAction(final JToggleButton button, final ImmiOutputSignal outputSignal) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImmiIOPanel.this.sendOutputRequestToController(outputSignal, button.isSelected());
            }
        });
    }

    private void sendOutputRequestToController(ImmiOutputSignal outputSignal, boolean value) {
        this.timeWhenButtonIsPressed = System.currentTimeMillis();
        ControllerSocketSender.sendSetEuromapOutput(outputSignal, value);
    }

    public long getTimeWhenButtonIsPressed() {
        return this.timeWhenButtonIsPressed;
    }

    protected void initOutputSignalButtonLook(EnumMap<ImmiOutputSignal, JToggleButton> outputSignalButtonMap) {
        for (JToggleButton b : outputSignalButtonMap.values()) {
            this.changeButtonLook(b);
        }
    }

    protected void initInputSignalButtonLook(EnumMap<ImmiInputSignal, JToggleButton> inputSignalButtonMap) {
        for (JToggleButton b : inputSignalButtonMap.values()) {
            this.changeButtonLook(b);
            b.setEnabled(false);
        }
    }

    private void changeButtonLook(JToggleButton b) {
        b.setIcon(OUTPUT_OFF);
        b.setSelectedIcon(OUTPUT_ON);
        b.setDisabledIcon(LOCKED_OUTPUT_OFF);
        b.setDisabledSelectedIcon(LOCKED_OUTPUT_ON);
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setSize(30, 30);
    }

    abstract EnumMap<ImmiOutputSignal, JToggleButton> getOutputSignalButtonMap();

    abstract EnumMap<ImmiInputSignal, JToggleButton> getInputSignalButtonMap();

    abstract void initializeImmiActions();
}

