/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi;

import com.ur.monitor.RobotState;
import com.ur.monitor.RobotStateListener;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.immi.ImmiNorthIOPanel;
import com.ur.polyscope.immi.ImmiSouthIOPanel;
import com.ur.polyscope.immi.internal.TextResource;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumEvent;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumListener;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventNotificationService;
import com.ur.view.constants.immi.ImmiInputSignal;
import com.ur.view.constants.immi.ImmiOutputSignal;
import com.ur.view.constants.immi.ImmiType;
import java.awt.Container;
import java.util.EnumMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JToggleButton;

@Singleton
public class ImmiIOTab
extends CardPanel
implements RobotStateListener,
ActiveSafetyChecksumListener {
    public static final String SHOW_IMMI_TAB = "showImmi.immiIOTab";
    private static final String IMMI_TAB_NAME = "immiTab.ioTab";
    private final EnumMap<ImmiOutputSignal, JToggleButton> outputSignalButtonMap = new EnumMap(ImmiOutputSignal.class);
    private final EnumMap<ImmiInputSignal, JToggleButton> inputSignalButtonMap = new EnumMap(ImmiInputSignal.class);
    private final ProgramModeHolder programModeService;
    private final HelpIdAssigner helpIdAssigner;
    private boolean programActive = true;
    private InstallationComponentLookup installationComponentLookup;
    private TextResource textResource;
    private ViewContext viewContext;
    private ImmiSouthIOPanel immiSouthIOPanel;
    private ImmiNorthIOPanel immiNorthIOPanel;

    @Inject
    public ImmiIOTab(ProgramModeHolder programModeService, HelpIdAssigner helpIdAssigner, InstallationComponentLookup installationComponentLookup, TextResource textResource, ViewContext viewContext) {
        this.programModeService = programModeService;
        this.helpIdAssigner = helpIdAssigner;
        this.installationComponentLookup = installationComponentLookup;
        this.textResource = textResource;
        this.viewContext = viewContext;
        this.setName(IMMI_TAB_NAME);
        this.initComponents();
        this.initializeButtonMaps();
        this.initHelpIds();
    }

    public void enter(Object o) {
        EventNotificationService.register((Object)((Object)this), RobotStateListener.class, (Object)((Object)this));
        EventNotificationService.register((Object)((Object)this), ActiveSafetyChecksumListener.class, (Object)((Object)this));
        this.programActive = true;
        this.setOutputButtonsAccordingToMode(true);
        this.initComponents();
        this.initializeButtonMaps();
    }

    public Object exit() {
        EventNotificationService.unregister((Object)((Object)this), RobotStateListener.class);
        EventNotificationService.unregister((Object)((Object)this), ActiveSafetyChecksumListener.class);
        return null;
    }

    private void initComponents() {
        this.removeAll();
        ImmiType immiType = ((Immi)this.installationComponentLookup.getComponent(Immi.class)).getImmiType();
        this.immiNorthIOPanel = new ImmiNorthIOPanel(immiType, this.helpIdAssigner, this.textResource, this.viewContext);
        this.immiSouthIOPanel = new ImmiSouthIOPanel(immiType, this.helpIdAssigner, this.textResource, this.viewContext);
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.add(this.immiNorthIOPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(this.immiSouthIOPanel);
    }

    private void initializeButtonMaps() {
        this.initOutputSignalButtonMap();
        this.initInputSignalButtonMap();
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:immi_io");
    }

    private void initOutputSignalButtonMap() {
        this.outputSignalButtonMap.putAll(this.immiNorthIOPanel.getOutputSignalButtonMap());
        this.outputSignalButtonMap.putAll(this.immiSouthIOPanel.getOutputSignalButtonMap());
    }

    private void initInputSignalButtonMap() {
        this.inputSignalButtonMap.putAll(this.immiNorthIOPanel.getInputSignalButtonMap());
        this.inputSignalButtonMap.putAll(this.immiSouthIOPanel.getInputSignalButtonMap());
    }

    private boolean enableCriteriaForProgramEditableSignals(ImmiOutputSignal outputSignal) {
        Immi immi = (Immi)this.installationComponentLookup.getComponent(Immi.class);
        return immi.getImmiOutputModificationChoice(outputSignal.getId()) < 2 && immi.getImmiOutputPinAction(outputSignal.getId()).isProgramStatePreservedAtProgramStop();
    }

    private boolean enableCriteriaForNonProgramEditableSignals(ImmiOutputSignal outputSignal) {
        Immi immi = (Immi)this.installationComponentLookup.getComponent(Immi.class);
        return immi.getImmiOutputModificationChoice(outputSignal.getId()) < 1 && immi.getImmiOutputPinAction(outputSignal.getId()).isProgramStatePreservedAtProgramStop();
    }

    private void setOutputButtonsAccordingToMode(boolean activity) {
        if (activity) {
            for (Map.Entry<ImmiOutputSignal, JToggleButton> e : this.outputSignalButtonMap.entrySet()) {
                JToggleButton b = e.getValue();
                b.setEnabled(false);
            }
        } else if (this.programModeService.getMode() == ProgramModeHolder.ProgramMode.Editable) {
            for (Map.Entry<ImmiOutputSignal, JToggleButton> e : this.outputSignalButtonMap.entrySet()) {
                JToggleButton b = e.getValue();
                ImmiOutputSignal signal = e.getKey();
                b.setEnabled(this.enableCriteriaForProgramEditableSignals(signal));
            }
        } else {
            for (Map.Entry<ImmiOutputSignal, JToggleButton> e : this.outputSignalButtonMap.entrySet()) {
                JToggleButton b = e.getValue();
                ImmiOutputSignal signal = e.getKey();
                b.setEnabled(this.enableCriteriaForNonProgramEditableSignals(signal));
            }
        }
    }

    public void updateRobotState(RobotState robotState) {
        long t = System.currentTimeMillis();
        if (robotState != null) {
            boolean activity;
            boolean bl = activity = robotState.programRunning || robotState.programPaused;
            if (activity != this.programActive) {
                this.programActive = activity;
                this.setOutputButtonsAccordingToMode(activity);
            }
            if (t - this.immiNorthIOPanel.getTimeWhenButtonIsPressed() > 150L) {
                this.updateUI(robotState);
            }
        }
    }

    private void updateUI(RobotState robotState) {
        JToggleButton b;
        for (Map.Entry<ImmiInputSignal, JToggleButton> entry : this.inputSignalButtonMap.entrySet()) {
            ImmiInputSignal inputSignal = entry.getKey();
            b = entry.getValue();
            b.setSelected(robotState.euromapInput[inputSignal.getId()] >= 1);
        }
        for (Map.Entry<ImmiInputSignal, JToggleButton> entry : this.outputSignalButtonMap.entrySet()) {
            ImmiOutputSignal outputSignal = (ImmiOutputSignal)entry.getKey();
            b = entry.getValue();
            b.setSelected(robotState.euromapOutput[outputSignal.getId()] == 1);
        }
        this.immiNorthIOPanel.updateCurrentAndVoltage(robotState);
    }

    public void activeSafetyChecksumChanged(ActiveSafetyChecksumEvent e) {
        this.enter(null);
    }
}

