/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi;

import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.immi.ImmiSignalService;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.pin.service.IOInterface;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.util.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ImmiInterface
implements IOInterface {
    private static final EnumSet<IOService.IOInterfaceType> VALID_INTERFACE_TYPE = EnumSet.of(IOService.IOInterfaceType.ALL, IOService.IOInterfaceType.IMMI);
    private static final EnumSet<IOService.IOSignalType> VALID_SIGNAL_TYPE = EnumSet.of(IOService.IOSignalType.ALL, IOService.IOSignalType.DIGITAL);
    private final InstallationComponentLookup installationComponentLookup;
    private final ImmiSignalService signalService;

    @Inject
    public ImmiInterface(InstallationComponentLookup installationComponentLookup, ImmiSignalService signalService) {
        this.installationComponentLookup = installationComponentLookup;
        this.signalService = signalService;
    }

    public Collection<? extends Pin<?>> getInputs(IOService.IOInterfaceType type, IOService.IOSignalType ... filters) {
        if (this.immiIsEnabled() && this.validInterfaceType(type) && this.validSignalType(filters)) {
            return this.signalService.getInputs();
        }
        return Collections.emptyList();
    }

    public Collection<? extends Pin<?>> getOutputs(IOService.IOInterfaceType type, IOService.IOSignalType ... filters) {
        if (this.immiIsEnabled() && this.validInterfaceType(type) && this.validSignalType(filters)) {
            return this.signalService.getOutputs();
        }
        return Collections.emptyList();
    }

    private boolean validInterfaceType(IOService.IOInterfaceType type) {
        return VALID_INTERFACE_TYPE.contains(type);
    }

    private boolean validSignalType(IOService.IOSignalType[] filters) {
        IOService.IOSignalType[] iOSignalTypeArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IOService.IOSignalType each = iOSignalTypeArray[n2];
            if (VALID_SIGNAL_TYPE.contains(each)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean immiIsEnabled() {
        Optional optional = this.installationComponentLookup.get(Immi.class);
        if (optional.isPresent()) {
            return ((Immi)optional.get()).isEnabled();
        }
        return false;
    }
}

