/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi;

import com.ur.lang.DecimalFormatFactory;
import com.ur.monitor.RobotState;
import com.ur.polyscope.immi.ImmiIOPanel;
import com.ur.polyscope.immi.internal.TextResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.units.Units;
import com.ur.view.constants.immi.ImmiInputSignal;
import com.ur.view.constants.immi.ImmiOutputSignal;
import com.ur.view.constants.immi.ImmiType;
import java.text.DecimalFormat;
import java.util.EnumMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;

class ImmiNorthIOPanel
extends ImmiIOPanel {
    private final DecimalFormat ampf = DecimalFormatFactory.createHalfEvenDecimalFormat((String)" 0.0;-0.0");
    private final DecimalFormat volf = DecimalFormatFactory.createHalfEvenDecimalFormat((String)" 0.0;-0.0");
    private final JToggleButton outputCorePullersTwoOutButton = new JToggleButton();
    private final JToggleButton outputAutomaticModeButton = new JToggleButton();
    private final JToggleButton outputMouldClosingButton = new JToggleButton();
    private final JToggleButton output24VoltButton = new JToggleButton();
    private final JToggleButton outputMouldOpeningButton = new JToggleButton();
    private final JToggleButton outputEjectorBackwardButton = new JToggleButton();
    private final JToggleButton outputEjectorForwardButton = new JToggleButton();
    private final JToggleButton outputCorePullersOneInButton = new JToggleButton();
    private final JToggleButton outputCorePullersOneOutButton = new JToggleButton();
    private final JToggleButton outputCorePullersTwoInButton = new JToggleButton();
    private final JToggleButton inputMouldClosingButton = new JToggleButton();
    private final JToggleButton inputEjectorBackwardButton = new JToggleButton();
    private final JToggleButton inputEjectorForwardButton = new JToggleButton();
    private final JToggleButton inputCorePullersOneInButton = new JToggleButton();
    private final JToggleButton inputCorePullersOneOutButton = new JToggleButton();
    private final JToggleButton inputMouldOpeningButton = new JToggleButton();
    private final JToggleButton inputCorePullersTwoInButton = new JToggleButton();
    private final JToggleButton inputCorePullersTwoOutButton = new JToggleButton();
    private final JToggleButton inputInputZc8Button = new JToggleButton();
    private final JToggleButton inputAutomaticModeButton = new JToggleButton();
    private final JToggleButton inputRejectButton = new JToggleButton();
    private final JToggleButton inputMouldPositionButton = new JToggleButton();
    private final JToggleButton input24VoltButton = new JToggleButton();
    private final JToggleButton outputMouldAreaFreeSoftwareButton = new JToggleButton();
    private final JToggleButton outputMouldAreaFreeElecticalButton = new JToggleButton();
    private JProgressBar currentProgressBar;
    private JProgressBar voltageProgressBar;
    private ImmiType immiType;
    private HelpIdAssigner helpIdAssigner;
    private TextResource textResource;
    private ViewContext viewContext;
    private JPanel controlPanel;
    private JPanel statusPanel;

    public ImmiNorthIOPanel(ImmiType immiType, HelpIdAssigner helpIdAssigner, TextResource textResource, ViewContext viewContext) {
        super(0);
        this.immiType = immiType;
        this.helpIdAssigner = helpIdAssigner;
        this.textResource = textResource;
        this.viewContext = viewContext;
        this.initComponents();
        this.initHelpIds();
    }

    private void initComponents() {
        this.initControlPanel();
        this.initStatusPanel();
        this.initLayout(this.controlPanel, this.statusPanel);
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.controlPanel, "gui:euromap67_io_tab_control");
        this.helpIdAssigner.assignHelpId((JComponent)this.statusPanel, "gui:euromap67_io_tab_status");
    }

    private void initStatusPanel() {
        this.voltageProgressBar = new JProgressBar();
        this.voltageProgressBar.setMaximum(300);
        this.voltageProgressBar.setString("0 V");
        this.voltageProgressBar.setStringPainted(true);
        this.currentProgressBar = new JProgressBar();
        this.currentProgressBar.setMaximum(2000);
        this.currentProgressBar.setString("0 mA");
        this.currentProgressBar.setStringPainted(true);
        if (this.immiType.equals((Object)ImmiType.SPI_AN_146)) {
            this.initSPIStatusPanel();
        } else {
            this.initEuromapStatusPanel();
        }
    }

    private void initEuromapStatusPanel() {
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        this.statusPanel = formBuilder.spacer(3).columnTitle(this.textResource.Robot(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).columnTitle(this.textResource.Machine(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.automaticMode(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputAutomaticModeButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputAutomaticModeButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.Reject(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer().component((JComponent)this.inputRejectButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.IntermediateMouldPosition(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer().component((JComponent)this.inputMouldPositionButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource._24VPower(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.output24VoltButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.input24VoltButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.Voltage(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.voltageProgressBar, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().label(this.textResource.Current(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.currentProgressBar, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(2).getCardPanel(this.textResource.Status());
    }

    private void initSPIStatusPanel() {
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        this.statusPanel = formBuilder.spacer(3).columnTitle(this.textResource.Robot(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).columnTitle(this.textResource.Machine(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.automaticMode(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputAutomaticModeButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputAutomaticModeButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.Reject(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer().component((JComponent)this.inputRejectButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.noPartAvailable(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer().component((JComponent)this.inputInputZc8Button, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.IntermediateMouldPosition(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer().component((JComponent)this.inputMouldPositionButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource._24VPower(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.output24VoltButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.input24VoltButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.Voltage(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.voltageProgressBar, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().label(this.textResource.Current(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.currentProgressBar, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().getCardPanel(this.textResource.Status());
    }

    private void initControlPanel() {
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        this.controlPanel = formBuilder.spacer(3).columnTitle(this.textResource.Robot(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).columnTitle(this.textResource.Machine(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.closeMould(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputMouldClosingButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputMouldClosingButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.openMould(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputMouldOpeningButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputMouldOpeningButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.EjectorBackward(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputEjectorBackwardButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputEjectorBackwardButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.EjectorForward(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputEjectorForwardButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputEjectorForwardButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.CorePullers1in(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputCorePullersOneInButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputCorePullersOneInButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.CorePullers1out(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputCorePullersOneOutButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputCorePullersOneOutButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.CorePullers2in(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputCorePullersTwoInButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputCorePullersTwoInButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.CorePullers2out(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputCorePullersTwoOutButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputCorePullersTwoOutButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.MouldAreaFreeElectrical(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputMouldAreaFreeElecticalButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).spacer().end().label(this.textResource.MouldAreaFreeSoftware(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputMouldAreaFreeSoftwareButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).spacer().end(2).getCardPanel(this.textResource.Control());
    }

    @Override
    protected EnumMap<ImmiInputSignal, JToggleButton> getInputSignalButtonMap() {
        EnumMap<ImmiInputSignal, JToggleButton> map = new EnumMap<ImmiInputSignal, JToggleButton>(ImmiInputSignal.class);
        map.put(ImmiInputSignal.MOULD_CLOSED, this.inputMouldClosingButton);
        map.put(ImmiInputSignal.MOULD_OPEN_POSITION, this.inputMouldOpeningButton);
        map.put(ImmiInputSignal.EJECTOR_BACK_POSITION, this.inputEjectorBackwardButton);
        map.put(ImmiInputSignal.EJECTOR_FORWARD_POSITION, this.inputEjectorForwardButton);
        map.put(ImmiInputSignal.CORE_PULLERS_1_IN_POS_1, this.inputCorePullersOneInButton);
        map.put(ImmiInputSignal.CORE_PULLERS_1_IN_POS_2, this.inputCorePullersOneOutButton);
        map.put(ImmiInputSignal.CORE_PULLERS_2_IN_POS_1, this.inputCorePullersTwoInButton);
        map.put(ImmiInputSignal.CORE_PULLERS_2_IN_POS_2, this.inputCorePullersTwoOutButton);
        map.put(ImmiInputSignal.MANUFACTURER_DEPENDENT_ZC8, this.inputInputZc8Button);
        map.put(ImmiInputSignal.ENABLE_OPERATION_WITH_ROBOT, this.inputAutomaticModeButton);
        map.put(ImmiInputSignal.REJECT, this.inputRejectButton);
        map.put(ImmiInputSignal.INTERMEDIATE_MOULD_OPENING_POSITION, this.inputMouldPositionButton);
        map.put(ImmiInputSignal.SUPPLY_FROM_ROBOT, this.output24VoltButton);
        map.put(ImmiInputSignal.MOULDING_MACHINE_24V_PRESENT, this.input24VoltButton);
        map.put(ImmiInputSignal.MOULDING_AREA_FREE_SIGNAL_ACTIVATED, this.outputMouldAreaFreeElecticalButton);
        return map;
    }

    @Override
    protected EnumMap<ImmiOutputSignal, JToggleButton> getOutputSignalButtonMap() {
        EnumMap<ImmiOutputSignal, JToggleButton> map = new EnumMap<ImmiOutputSignal, JToggleButton>(ImmiOutputSignal.class);
        map.put(ImmiOutputSignal.ENABLE_MOULD_CLOSURE, this.outputMouldClosingButton);
        map.put(ImmiOutputSignal.ENABLE_FULL_MOULD_OPENING, this.outputMouldOpeningButton);
        map.put(ImmiOutputSignal.ENABLE_EJECTOR_BACK, this.outputEjectorBackwardButton);
        map.put(ImmiOutputSignal.ENABLE_EJECTOR_FORWARD, this.outputEjectorForwardButton);
        map.put(ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_1_TO_POS_1, this.outputCorePullersOneInButton);
        map.put(ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_1_TO_POS_2, this.outputCorePullersOneOutButton);
        map.put(ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_2_TO_POS_1, this.outputCorePullersTwoInButton);
        map.put(ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_2_TO_POS_2, this.outputCorePullersTwoOutButton);
        map.put(ImmiOutputSignal.ROBOT_OPERATION_MODE, this.outputAutomaticModeButton);
        map.put(ImmiOutputSignal.MOULD_AREA_FREE, this.outputMouldAreaFreeSoftwareButton);
        return map;
    }

    @Override
    protected void initializeImmiActions() {
        this.addImmiAction(this.outputMouldClosingButton, ImmiOutputSignal.ENABLE_MOULD_CLOSURE);
        this.addImmiAction(this.outputMouldOpeningButton, ImmiOutputSignal.ENABLE_FULL_MOULD_OPENING);
        this.addImmiAction(this.outputEjectorBackwardButton, ImmiOutputSignal.ENABLE_EJECTOR_BACK);
        this.addImmiAction(this.outputEjectorForwardButton, ImmiOutputSignal.ENABLE_EJECTOR_FORWARD);
        this.addImmiAction(this.outputCorePullersOneInButton, ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_1_TO_POS_1);
        this.addImmiAction(this.outputCorePullersOneOutButton, ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_1_TO_POS_2);
        this.addImmiAction(this.outputCorePullersTwoInButton, ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_2_TO_POS_1);
        this.addImmiAction(this.outputCorePullersTwoOutButton, ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_2_TO_POS_2);
        this.addImmiAction(this.outputMouldAreaFreeSoftwareButton, ImmiOutputSignal.MOULD_AREA_FREE);
        this.addImmiAction(this.outputAutomaticModeButton, ImmiOutputSignal.ROBOT_OPERATION_MODE);
    }

    public void updateCurrentAndVoltage(RobotState robotState) {
        this.voltageProgressBar.setValue((int)(robotState.euromap24V_voltage * 10.0f));
        this.voltageProgressBar.setString(String.valueOf(this.volf.format(robotState.euromap24V_voltage)) + " " + Units.getText().unitV());
        this.currentProgressBar.setValue((int)(robotState.euromap24V_current * 1000.0f));
        this.currentProgressBar.setString(String.valueOf(this.ampf.format(robotState.euromap24V_current)) + " " + Units.getText().unitA());
    }
}

