/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi;

import com.ur.monitor.RobotState;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.immi.internal.TextResource;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.logging.Log;

public class ImmiSignal
extends AbstractPin<Byte> {
    private final String euromapName;
    private final String spiName;
    private final int bitNumber;
    private final int type;
    public static final int SIGNAL_TYPE_DIGITAL_INPUT = 1;
    public static final int SIGNAL_TYPE_DIGITAL_OUTPUT = 0;
    private final InstallationComponentLookup installationComponentLookup;
    private final TextResource textResource;

    public ImmiSignal(InstallationComponentLookup installationComponentLookup, TextResource textResource, String euromapName, String spiName, int bitNumberIn, int typeIn) {
        this.installationComponentLookup = installationComponentLookup;
        this.textResource = textResource;
        this.euromapName = euromapName;
        this.spiName = spiName;
        this.bitNumber = bitNumberIn;
        this.type = typeIn;
    }

    public Byte getValue() {
        if (this.isInput()) {
            return RobotState.getLatestRobotState().euromapInput[this.bitNumber];
        }
        return RobotState.getLatestRobotState().euromapOutput[this.bitNumber];
    }

    public String getShortName() {
        switch (this.getImmi().getImmiType()) {
            case E12: {
                return "E12[" + this.bitNumber + "]";
            }
            case E67: {
                return "E67[" + this.bitNumber + "]";
            }
            case SPI_AN_116: {
                return "SPI 116[" + this.bitNumber + "]";
            }
            case SPI_AN_146: {
                return "SPI 146[" + this.bitNumber + "]";
            }
        }
        return "IMMI[" + this.bitNumber + "]";
    }

    public String getDefinedName() {
        return null;
    }

    public String getUserDefinedName() {
        return null;
    }

    public void setName(String name) {
    }

    public String getDefaultName() {
        switch (this.getImmi().getImmiType()) {
            case SPI_AN_146: 
            case SPI_AN_116: {
                return this.spiName;
            }
            case E67: 
            case E12: {
                return this.euromapName;
            }
        }
        Log.error((String)"Trying to show IMMI pin when IMMI is disabled");
        return "IMMI " + this.bitNumber;
    }

    public String getDisplayName() {
        switch (this.getImmi().getImmiType()) {
            case E67: 
            case E12: {
                return this.textResource.get(this.euromapName);
            }
            case SPI_AN_146: 
            case SPI_AN_116: {
                return this.textResource.get(this.spiName);
            }
        }
        Log.error((String)"Trying to show IMMI pin when IMMI is disabled");
        return "IMMI " + this.bitNumber;
    }

    public boolean useDisplayNameOverDefaultName() {
        return true;
    }

    public int getPin() {
        return this.bitNumber;
    }

    public boolean isInput() {
        return 1 == this.type;
    }

    public int getModificationChoice() {
        if (this.isInput()) {
            return 0;
        }
        return this.getImmi().getImmiOutputModificationChoice(this.bitNumber);
    }

    public void setModificationChoice(int choice) {
        this.getImmi().setImmiOutputModificationChoice(this.bitNumber, choice);
    }

    public String generateRunstateDependentChoice() {
        OutputPinAction action = this.getImmi().getImmiOutputPinAction(this.bitNumber);
        return "set_euromap_runstate_dependent_choice(" + this.bitNumber + "," + action.getRunstateChoice() + ")";
    }

    public boolean isProgramStateModeSupported() {
        return false;
    }

    private Immi getImmi() {
        return (Immi)this.installationComponentLookup.getComponent(Immi.class);
    }

    public String generateSetterScriptCode(String newSignalValue) {
        if (this.type == 0) {
            return "set_euromap_output(" + this.bitNumber + ", " + newSignalValue + ")";
        }
        Log.error((String)"Tried to generate set-code for signal that is not an output.");
        return "";
    }

    public String generateGetterScriptCode() {
        if (this.type == 1) {
            return "get_euromap_input(" + this.bitNumber + ")";
        }
        return "get_euromap_output(" + this.bitNumber + ")";
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmiSignal) {
            ImmiSignal e = (ImmiSignal)((Object)obj);
            return e.bitNumber == this.bitNumber && e.type == this.type;
        }
        return false;
    }

    public int hashCode() {
        int result = 23;
        result = result * 37 + this.bitNumber;
        result = result * 37 + this.type;
        return result;
    }

    public void generatePreambleScript(ScriptWriter writer) {
    }

    public void setOutputAction(OutputPinAction action) {
        this.getImmi().setImmiOutputPinAction(this.bitNumber, action);
    }

    public OutputPinAction getOutputAction() {
        return this.getImmi().getImmiOutputPinAction(this.bitNumber);
    }
}

