/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi;

import com.ur.polyscope.immi.ImmiSignal;
import com.ur.polyscope.immi.internal.TextResource;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.view.constants.immi.ImmiInputSignal;
import com.ur.view.constants.immi.ImmiOutputSignal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ImmiSignalService {
    private final InstallationComponentLookup lookup;
    private final TextResource textResource;
    private List<ImmiSignal> outputs;
    private List<ImmiSignal> inputs;

    @Inject
    public ImmiSignalService(InstallationComponentLookup lookup, TextResource textResource) {
        this.lookup = lookup;
        this.textResource = textResource;
    }

    public List<ImmiSignal> getOutputs() {
        if (this.outputs == null) {
            this.outputs = new ArrayList<ImmiSignal>();
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_MOULD_AREA_FREE", "SPI_AN-146_OUTPUT_ENABLE_CLAMP_MOTION", ImmiOutputSignal.MOULD_AREA_FREE));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_ENABLE_MOULD_CLOSURE", "SPI_AN-146_OUTPUT_PERMIT_CLAMP_CLOSE", ImmiOutputSignal.ENABLE_MOULD_CLOSURE));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_ENABLE_FULL_MOULD_OPENING", "SPI_AN-146_OUTPUT_PERMIT_MOLD_FULL_OPEN", ImmiOutputSignal.ENABLE_FULL_MOULD_OPENING));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_ROBOT_OPERATION_MODE", "SPI_AN-146_OUTPUT_ROBOT_NON-OPERATIONAL", ImmiOutputSignal.ROBOT_OPERATION_MODE));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_ENABLE_EJECTOR_BACK", "SPI_AN-146_OUTPUT_PERMIT_EJECTOR_RETRACT", ImmiOutputSignal.ENABLE_EJECTOR_BACK));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_ENABLE_EJECTOR_FORWARD", "SPI_AN-146_OUTPUT_PERMIT_EJECTOR_FORWARD", ImmiOutputSignal.ENABLE_EJECTOR_FORWARD));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_ENABLE_MOVE_CORE_PULLERS_1_TO_POS_1", "SPI_AN-146_OUTPUT_PERMIT_CORE_1_SET_IN_POSITION_1", ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_1_TO_POS_1));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_ENABLE_MOVE_CORE_PULLERS_1_TO_POS_2", "SPI_AN-146_OUTPUT_PERMIT_CORE_1_PULL_IN_POSITION_2", ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_1_TO_POS_2));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_ENABLE_MOVE_CORE_PULLERS_2_TO_POS_1", "SPI_AN-146_OUTPUT_PERMIT_CORE_2_SET_IN_POSITION_1", ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_2_TO_POS_1));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_ENABLE_MOVE_CORE_PULLERS_2_TO_POS_2", "SPI_AN-146_OUTPUT_PERMIT_CORE_2_PULL_IN_POSITION_2", ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_2_TO_POS_2));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_MANUFACTURER_DEPENDENT_A5", "SPI_AN-146_OUTPUT_NOT_ASSIGNED_A5", ImmiOutputSignal.MANUFACTURER_DEPENDENT_A5));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_MANUFACTURER_DEPENDENT_C5", "SPI_AN-146_OUTPUT_NOT_ASSIGNED_C5", ImmiOutputSignal.MANUFACTURER_DEPENDENT_C5));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_MANUFACTURER_DEPENDENT_C8", "SPI_AN-146_OUTPUT_NOT_ASSIGNED_C8", ImmiOutputSignal.MANUFACTURER_DEPENDENT_C8));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_FUTURE_USE_RESERVED_A8", "SPI_AN-146_OUTPUT_FUTURE_USE_RESERVED_A8", ImmiOutputSignal.FUTURE_USE_RESERVED_A8));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_FUTURE_USE_RESERVED_C6", "SPI_AN-146_OUTPUT_INSERT_PARTS_INSERTED", ImmiOutputSignal.FUTURE_USE_RESERVED_C6));
            this.outputs.add(this.createImmiOutputSignal("EUROMAP67_OUTPUT_FUTURE_USE_RESERVED_C7", "SPI_AN-146_OUTPUT_Molded_PARTS_REMOVED", ImmiOutputSignal.FUTURE_USE_RESERVED_C7));
        }
        return Collections.unmodifiableList(this.outputs);
    }

    public List<ImmiSignal> getInputs() {
        if (this.inputs == null) {
            this.inputs = new ArrayList<ImmiSignal>();
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_MOULDING_AREA_FREE_SIGNAL_ACTIVATED", "SPI_AN-146_INPUT_MOULDING_AREA_FREE_SIGNAL_ACTIVATED", ImmiInputSignal.MOULDING_AREA_FREE_SIGNAL_ACTIVATED));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_MOULD_CLOSED", "SPI_AN-146_INPUT_MOULD_FULLY_CLOSED", ImmiInputSignal.MOULD_CLOSED));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_MOULD_OPEN_POSITION", "SPI_AN-146_INPUT_MOULD_FULLY_OPEN_", ImmiInputSignal.MOULD_OPEN_POSITION));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_ENABLE_OPERATION_WITH_ROBOT", "SPI_AN-146_INPUT_PERMIT_ROBOT_OPERATION", ImmiInputSignal.ENABLE_OPERATION_WITH_ROBOT));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_EJECTOR_BACK_POSITION", "SPI_AN-146_INPUT_EJECTOR_FULLY_RETRACTED", ImmiInputSignal.EJECTOR_BACK_POSITION));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_EJECTOR_FORWARD_POSITION", "SPI_AN-146_INPUT_EJECTOR_FULLY_FORWARD", ImmiInputSignal.EJECTOR_FORWARD_POSITION));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_CORE_PULLERS_1_IN_POS_1", "SPI_AN-146_INPUT_CORE_1_FULLY_SET_IN_POSITION_1", ImmiInputSignal.CORE_PULLERS_1_IN_POS_1));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_CORE_PULLERS_1_IN_POS_2", "SPI_AN-146_INPUT_CORE_1_FULLY_SET_IN_POSITION_2", ImmiInputSignal.CORE_PULLERS_1_IN_POS_2));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_CORE_PULLERS_2_IN_POS_1", "SPI_AN-146_INPUT_CORE_2_FULLY_SET_IN_POSITION_1", ImmiInputSignal.CORE_PULLERS_2_IN_POS_1));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_CORE_PULLERS_2_IN_POS_2", "SPI_AN-146_INPUT_CORE_2_FULLY_SET_IN_POSITION_2", ImmiInputSignal.CORE_PULLERS_2_IN_POS_2));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_INTERMEDIATE_MOULD_OPENING_POSISTION", "SPI_AN-146_INPUT_INTERMEDIATE_MOLD_OPEN_POSITION", ImmiInputSignal.INTERMEDIATE_MOULD_OPENING_POSITION));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_REJECT", "SPI_AN-146_INPUT_REJECT_PART", ImmiInputSignal.REJECT));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_MANUFACTURER_DEPENDENT_ZC8", "SPI_AN-146_INPUT_NO_PART_AVAILABLE", ImmiInputSignal.MANUFACTURER_DEPENDENT_ZC8));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_FUTURE_USE_RESERVED_ZC5", "SPI_AN-146_INPUT_END_OF_ORDER", ImmiInputSignal.FUTURE_USE_RESERVED_ZC5));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_FUTURE_USE_RESERVED_ZC6", "SPI_AN-146_INPUT_INSERT_PARTS_AVAILABLE", ImmiInputSignal.FUTURE_USE_RESERVED_ZC6));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_FUTURE_USE_RESERVED_ZC7", "SPI_AN-146_INPUT_FUTURE_USE_RESERVED_ZC7", ImmiInputSignal.FUTURE_USE_RESERVED_ZC7));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_ROBOT_EMERGENCY_STOPPED", "SPI_AN-146_INPUT_ROBOT_EMERGENCY_STOPPED", ImmiInputSignal.ROBOT_EMERGENCY_STOPPED));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_SUPPLY_FROM_ROBOT", "SPI_AN-146_INPUT_24_VDC_ROBOT_REFERENCE_POTENTIAL", ImmiInputSignal.SUPPLY_FROM_ROBOT));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_MOULDING_MACHINE_24V_PRESENT", "SPI_AN-146_INPUT_SUPPLY_FROM_THE_IMM", ImmiInputSignal.MOULDING_MACHINE_24V_PRESENT));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_EMERGENCY_STOP_MACHINE", "SPI_AN-146_INPUT_MACHINE_EMERGENCY_STOPPED", ImmiInputSignal.EMERGENCY_STOP_MACHINE));
            this.inputs.add(this.createImmiInputSignal("EUROMAP67_INPUT_SAFETY_DEVICES_OF_MACHINE", "SPI_AN-146_INPUT_MOVABLE_GATES_AND_GUARDS_CLOSED", ImmiInputSignal.SAFETY_DEVICES_OF_MACHINE));
        }
        return Collections.unmodifiableList(this.inputs);
    }

    private ImmiSignal createImmiOutputSignal(String euromapName, String spiName, ImmiOutputSignal outputSignal) {
        return this.createImmiSignal(euromapName, spiName, outputSignal.getId(), 0);
    }

    private ImmiSignal createImmiInputSignal(String euromapName, String spiName, ImmiInputSignal inputSignal) {
        return this.createImmiSignal(euromapName, spiName, inputSignal.getId(), 1);
    }

    private ImmiSignal createImmiSignal(String euromapName, String spiName, int bitNumber, int signalType) {
        return new ImmiSignal(this.lookup, this.textResource, euromapName, spiName, bitNumber, signalType);
    }
}

