/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi;

import com.ur.polyscope.immi.ImmiIOPanel;
import com.ur.polyscope.immi.internal.TextResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.view.constants.immi.ImmiInputSignal;
import com.ur.view.constants.immi.ImmiOutputSignal;
import com.ur.view.constants.immi.ImmiType;
import java.util.EnumMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

class ImmiSouthIOPanel
extends ImmiIOPanel {
    private final JToggleButton outputOutputA5Button = new JToggleButton();
    private final JToggleButton outputOutputC5 = new JToggleButton();
    private final JToggleButton outputOutputC8 = new JToggleButton();
    private final JToggleButton outputEmergencyStopButton = new JToggleButton();
    private final JToggleButton inputInputZc8Button = new JToggleButton();
    private final JToggleButton inputEmergencyStopButton = new JToggleButton();
    private final JToggleButton inputSafeguardOpenButton = new JToggleButton();
    private ImmiType immiType;
    private HelpIdAssigner helpIdAssigner;
    private TextResource textResource;
    private ViewContext viewContext;
    private JPanel manufacturerDependentPanel;
    private JPanel safetyPanel;

    public ImmiSouthIOPanel(ImmiType immiType, HelpIdAssigner helpIdAssigner, TextResource textResource, ViewContext viewContext) {
        super(0);
        this.immiType = immiType;
        this.helpIdAssigner = helpIdAssigner;
        this.textResource = textResource;
        this.viewContext = viewContext;
        this.initComponents();
        this.initHelpIds();
    }

    private void initComponents() {
        this.initSafetyPanel();
        this.initManufacturerPanel();
        this.initLayout(this.manufacturerDependentPanel, this.safetyPanel);
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.manufacturerDependentPanel, "gui:euromap67_io_tab_manufacturer_dependent");
        this.helpIdAssigner.assignHelpId((JComponent)this.safetyPanel, "gui:euromap67_io_tab_safety");
    }

    private void initManufacturerPanel() {
        if (this.immiType.equals((Object)ImmiType.SPI_AN_146)) {
            this.initSPIManufacturerPanel();
        } else {
            this.initEuromapManufacturerPanel();
        }
    }

    private void initEuromapManufacturerPanel() {
        this.manufacturerDependentPanel = this.viewContext.createFormBuilder().spacer(3).columnTitle(this.textResource.Robot(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).columnTitle(this.textResource.Machine(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.euromap67DiZc8(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer().component((JComponent)this.inputInputZc8Button, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.euromap67DoA5(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputOutputA5Button, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).spacer().end().label(this.textResource.euromap67DoC5(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputOutputC5, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).spacer().end().label(this.textResource.euromap67DoC8(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputOutputC8, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).spacer().getCardPanel(this.textResource.manufacturerDependent());
    }

    private void initSPIManufacturerPanel() {
        this.manufacturerDependentPanel = this.viewContext.createFormBuilder().spacer(3).columnTitle(this.textResource.Robot(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).columnTitle(this.textResource.Machine(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.spiAn146DoA5(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputOutputA5Button, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).spacer().end().label(this.textResource.spiAn146DoC5(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputOutputC5, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).spacer().end().label(this.textResource.spiAn146DoC8(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputOutputC8, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).spacer().getCardPanel(this.textResource.manufacturerDependent());
    }

    private void initSafetyPanel() {
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        this.safetyPanel = formBuilder.spacer(3).columnTitle(this.textResource.Robot(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).columnTitle(this.textResource.Machine(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.emergencyStop(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.outputEmergencyStopButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).component((JComponent)this.inputEmergencyStopButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end().label(this.textResource.SafeguardOpen(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer().component((JComponent)this.inputSafeguardOpenButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).getCardPanel(this.textResource.Safety());
    }

    @Override
    protected EnumMap<ImmiInputSignal, JToggleButton> getInputSignalButtonMap() {
        EnumMap<ImmiInputSignal, JToggleButton> map = new EnumMap<ImmiInputSignal, JToggleButton>(ImmiInputSignal.class);
        map.put(ImmiInputSignal.MANUFACTURER_DEPENDENT_ZC8, this.inputInputZc8Button);
        map.put(ImmiInputSignal.ROBOT_EMERGENCY_STOPPED, this.outputEmergencyStopButton);
        map.put(ImmiInputSignal.EMERGENCY_STOP_MACHINE, this.inputEmergencyStopButton);
        map.put(ImmiInputSignal.SAFETY_DEVICES_OF_MACHINE, this.inputSafeguardOpenButton);
        return map;
    }

    @Override
    protected EnumMap<ImmiOutputSignal, JToggleButton> getOutputSignalButtonMap() {
        EnumMap<ImmiOutputSignal, JToggleButton> map = new EnumMap<ImmiOutputSignal, JToggleButton>(ImmiOutputSignal.class);
        map.put(ImmiOutputSignal.MANUFACTURER_DEPENDENT_A5, this.outputOutputA5Button);
        map.put(ImmiOutputSignal.MANUFACTURER_DEPENDENT_C5, this.outputOutputC5);
        map.put(ImmiOutputSignal.MANUFACTURER_DEPENDENT_C8, this.outputOutputC8);
        return map;
    }

    @Override
    protected void initializeImmiActions() {
        this.addImmiAction(this.outputOutputA5Button, ImmiOutputSignal.MANUFACTURER_DEPENDENT_A5);
        this.addImmiAction(this.outputOutputC5, ImmiOutputSignal.MANUFACTURER_DEPENDENT_C5);
        this.addImmiAction(this.outputOutputC8, ImmiOutputSignal.MANUFACTURER_DEPENDENT_C8);
    }
}

