/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi;

import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PersistIOPart;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.pin.service.IOService;

public class PersistImmiPart
implements PersistIOPart {
    static final String OUTPUT_MODIFICATION_CHOICE = "euromapOutputModificationChoice";
    static final String PRESERVE_STATE_AT_PROGRAM_STOP = "euromapPreserveStateAtProgramStop";
    static final String IF_NOT_PRESERVE_STATE_THEN_SET_TO_LOW_AT_PROGRAM_STOP = "euromapIfNotPreserveStateThenSetToLowAtProgramStop";
    static final String IMMI_OUTPUT_ACTIONS = "euromapOutputActions";
    private boolean[] immiPreserveStateAtProgramStop;
    private boolean[] immiIfNotPreserveStateThenSetToLowAtProgramStop;

    public void marshal(IOService toMarshal, Installation installation, PersistWriter writer) {
        Immi immi = this.getImmi(installation);
        writer.createNodeWithValueAttribute(OUTPUT_MODIFICATION_CHOICE, immi.getImmiOutputModificationChoice());
        writer.createNodeWithValueAttribute(IMMI_OUTPUT_ACTIONS, immi.getOutputPinActionsAsString());
    }

    private Immi getImmi(Installation installation) {
        return (Immi)installation.getComponent(Immi.class);
    }

    private void handleLegacyFormat(Installation installation) {
        if (this.immiPreserveStateAtProgramStop != null && this.immiIfNotPreserveStateThenSetToLowAtProgramStop != null) {
            int i = 0;
            while (i < this.immiPreserveStateAtProgramStop.length) {
                OutputPinAction outputPinAction = this.immiPreserveStateAtProgramStop[i] ? OutputPinAction.NONE : (this.immiIfNotPreserveStateThenSetToLowAtProgramStop[i] ? OutputPinAction.LOW_WHEN_PROGRAM_STOPPED : OutputPinAction.HIGH_WHEN_PROGRAM_STOPPED);
                this.getImmi(installation).setImmiOutputPinAction(i, outputPinAction);
                ++i;
            }
            this.immiPreserveStateAtProgramStop = null;
            this.immiIfNotPreserveStateThenSetToLowAtProgramStop = null;
        }
    }

    public void unmarshal(Installation installation, PersistReader reader) {
        if (reader.isNode(OUTPUT_MODIFICATION_CHOICE)) {
            this.getImmi(installation).setImmiOutputModificationChoice(reader.getIntegerArrayValueAttribute());
        } else if (reader.isNode(PRESERVE_STATE_AT_PROGRAM_STOP)) {
            if (this.immiPreserveStateAtProgramStop == null) {
                this.immiPreserveStateAtProgramStop = reader.getBooleanArrayValueAttribute();
                this.handleLegacyFormat(installation);
            }
        } else if (reader.isNode(IF_NOT_PRESERVE_STATE_THEN_SET_TO_LOW_AT_PROGRAM_STOP)) {
            if (this.immiIfNotPreserveStateThenSetToLowAtProgramStop == null) {
                this.immiIfNotPreserveStateThenSetToLowAtProgramStop = reader.getBooleanArrayValueAttribute();
                this.handleLegacyFormat(installation);
            }
        } else if (reader.isNode(IMMI_OUTPUT_ACTIONS)) {
            this.getImmi(installation).setOutputPinActionsFromString(reader.getStringValueArray());
        }
    }

    public boolean canUnmarshal(PersistReader reader) {
        return reader.isNode(OUTPUT_MODIFICATION_CHOICE) || reader.isNode(PRESERVE_STATE_AT_PROGRAM_STOP) || reader.isNode(IF_NOT_PRESERVE_STATE_THEN_SET_TO_LOW_AT_PROGRAM_STOP) || reader.isNode(IMMI_OUTPUT_ACTIONS);
    }
}

