/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi.card;

import com.ur.lang.Defense;
import com.ur.polyscope.immi.node.ImmiNode;
import com.ur.polyscope.program.commandview.UpdateCard;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JCheckBox;

public abstract class ImmiCard<X extends ImmiNode>
extends CardPanel
implements UpdateCard {
    protected final ViewContext viewContext;
    protected Map<JCheckBox, Integer> stepMap = new LinkedHashMap<JCheckBox, Integer>();
    private final Class<X> nodeType;
    protected X node;

    @Inject
    ImmiCard(Class<X> nodeType, ViewContext viewContext) {
        this.nodeType = nodeType;
        this.viewContext = viewContext;
    }

    public void enter(Object o) {
        Defense.notNull((Object)o, (String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + " entered with: null"));
        Defense.isInstanceOf((Object)o, this.nodeType, (String)("Invalid type, expected " + this.nodeType + ", but was " + o.getClass()));
        this.node = (ImmiNode)((Object)o);
        super.enter(o);
        this.updateCard();
    }

    public X getNode() {
        return this.node;
    }

    public void updateCard(Object o) {
        this.updateCard();
    }

    protected void updateCard() {
        if (this.node != null) {
            for (Map.Entry<JCheckBox, Integer> entry : this.stepMap.entrySet()) {
                entry.getKey().setSelected(((ImmiNode)((Object)this.node)).getStepEnabled(entry.getValue()));
            }
        }
    }

    protected ItemListener createStepEnabledItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                ((ImmiNode)((Object)ImmiCard.this.node)).setStepEnabled(ImmiCard.this.stepMap.get(source), source.isSelected());
            }
        };
    }

    JCheckBox getStepCheckBox(int step) {
        for (Map.Entry<JCheckBox, Integer> entry : this.stepMap.entrySet()) {
            if (entry.getValue() != step) continue;
            return entry.getKey();
        }
        return null;
    }
}

