/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi.node;

import com.ur.polyscope.immi.internal.TextResource;
import com.ur.polyscope.immi.node.ImmiNode;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.view.constants.immi.ImmiInputSignal;
import com.ur.view.constants.immi.ImmiOutputSignal;
import javax.inject.Inject;

public class EjectorBackNode
extends ImmiNode {
    @Inject
    public EjectorBackNode(TextResource textResource) {
        super(11, textResource);
        this.setNodeTypeName(textResource.e67EjectorBack());
    }

    @Override
    protected void initializeSteps() {
        super.initializeSteps();
        this.stepsEnabled[2] = false;
    }

    public String toString() {
        return this.textResource.e67EjectorBack();
    }

    @Override
    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.backwardsCompatibilityCheck();
        writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
        if (this.stepsEnabled[0]) {
            this.generateHaltTestWithPopup(writer, EjectorBackNode.generateGetEuromapOutput(ImmiOutputSignal.ENABLE_MOULD_CLOSURE, true), this.toString(), 1, this.textResource.MouldClosureEnabled());
        }
        if (this.stepsEnabled[1]) {
            this.generateHaltTestWithPopup(writer, EjectorBackNode.generateGetEuromapOutput(ImmiOutputSignal.ROBOT_OPERATION_MODE, true), this.toString(), 2, this.textResource.RobotDisabled());
        }
        if (this.stepsEnabled[2]) {
            this.generateHaltTestWithPopup(writer, EjectorBackNode.generateGetEuromapInput(ImmiInputSignal.ENABLE_OPERATION_WITH_ROBOT, false), this.toString(), 3, this.textResource.AutomaticModeDisabled());
        }
        if (this.stepsEnabled[3]) {
            this.generateHaltTestWithPopup(writer, EjectorBackNode.generateGetEuromapInput(ImmiInputSignal.MOULD_OPEN_POSITION, false), this.toString(), 4, this.textResource.MouldNotOpen());
        }
        if (this.stepsEnabled[4]) {
            this.generateHaltTestWithPopup(writer, EjectorBackNode.generateGetEuromapOutput(ImmiOutputSignal.ENABLE_EJECTOR_BACK, true), this.toString(), 5, this.textResource.EjectorIsAlreadySentBackwards());
        }
        if (this.stepsEnabled[5]) {
            this.generateHaltTestWithPopup(writer, EjectorBackNode.generateGetEuromapInput(ImmiInputSignal.EJECTOR_BACK_POSITION, true), this.toString(), 6, this.textResource.EjectorIsAlreadyAtBack());
        }
        if (this.stepsEnabled[6]) {
            this.generateHaltTestWithPopup(writer, EjectorBackNode.generateGetEuromapInput(ImmiInputSignal.EJECTOR_FORWARD_POSITION, false), this.toString(), 7, this.textResource.EjectorIsNotAtFront());
        }
        if (this.stepsEnabled[7]) {
            writer.appendLine(String.valueOf(EjectorBackNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_EJECTOR_FORWARD, false)) + "\n");
        }
        if (this.stepsEnabled[8]) {
            writer.appendLine(String.valueOf(EjectorBackNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_EJECTOR_BACK, true)) + "\n");
        }
        if (this.stepsEnabled[9]) {
            writer.sleep(0.04);
        }
        if (this.stepsEnabled[10]) {
            writer.whileCondition(EjectorBackNode.generateGetEuromapInput(ImmiInputSignal.EJECTOR_BACK_POSITION, false));
            writer.sync();
            writer.end();
        }
        return writer;
    }
}

