/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi.node;

import com.ur.polyscope.immi.internal.TextResource;
import com.ur.polyscope.immi.node.ImmiNode$AjcClosure1;
import com.ur.polyscope.immi.node.ImmiNode$AjcClosure3;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.logging.Log;
import com.ur.view.constants.immi.ImmiInputSignal;
import com.ur.view.constants.immi.ImmiOutputSignal;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public abstract class ImmiNode
extends AbstractProgramNode {
    protected final int numberOfSteps;
    protected final TextResource textResource;
    protected boolean[] stepsEnabled;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    ImmiNode(int numberOfSteps, TextResource textResource) {
        this.numberOfSteps = numberOfSteps;
        this.textResource = textResource;
        this.initializeSteps();
    }

    protected static String generateGetEuromapOutput(ImmiOutputSignal outputSignal, boolean condition) {
        return "get_euromap_output(" + outputSignal.getId() + ")==" + (condition ? "True" : "False");
    }

    protected static String generateGetEuromapInput(ImmiInputSignal inputSignal, boolean condition) {
        return "get_euromap_input(" + inputSignal.getId() + ")==" + (condition ? "True" : "False");
    }

    protected static String generateSetEuromapOutput(ImmiOutputSignal outputSignal, boolean condition) {
        return "set_euromap_output(" + outputSignal.getId() + "," + (condition ? "True" : "False") + ")";
    }

    protected void generateHaltTestWithPopup(ScriptWriter writer, String condition, String structureName, int structureStep, String description) {
        String popupMessage = String.valueOf(structureName) + ", " + this.textResource.step() + " " + structureStep + ": " + description;
        writer.ifCondition(condition);
        writer.popup(popupMessage, "IMMI " + this.textResource.Warning(), ScriptWriter.PopupLevel.ERROR, true);
        writer.halt();
        writer.end();
    }

    public void generateHaltTestWithPopup(ScriptWriter writer, String condition, String description) {
        writer.ifCondition(condition);
        writer.popup(description, "IMMI " + this.textResource.Warning(), ScriptWriter.PopupLevel.ERROR, true);
        writer.halt();
        writer.end();
    }

    protected void initializeSteps() {
        if (this.stepsEnabled == null) {
            this.stepsEnabled = new boolean[this.numberOfSteps];
            int i = 0;
            while (i < this.numberOfSteps) {
                this.stepsEnabled[i] = true;
                ++i;
            }
        }
    }

    public ImmiNode clone() {
        this.backwardsCompatibilityCheck();
        ImmiNode clone = (ImmiNode)super.clone();
        clone.stepsEnabled = new boolean[this.numberOfSteps];
        System.arraycopy(this.stepsEnabled, 0, clone.stepsEnabled, 0, this.numberOfSteps);
        return clone;
    }

    public boolean isUndefined() {
        return false;
    }

    public boolean getStepEnabled(int step) {
        this.backwardsCompatibilityCheck();
        if (step >= 0 && step < this.stepsEnabled.length) {
            return this.stepsEnabled[step];
        }
        Log.error((String)("Supplied step " + step + " is invalid."), (Throwable)new IndexOutOfBoundsException());
        return false;
    }

    public boolean[] getStepsEnabled() {
        return Arrays.copyOf(this.stepsEnabled, this.stepsEnabled.length);
    }

    @ProgramNodeChange
    public void setStepsEnabled(boolean[] stepsEnabled) {
        boolean[] blArray = stepsEnabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)blArray);
        Object[] objectArray = new Object[]{this, blArray, joinPoint};
        ImmiNode$AjcClosure1 immiNode$AjcClosure1 = new ImmiNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(immiNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ProgramNodeChange
    public void setStepEnabled(int step, boolean enabled) {
        int n = step;
        boolean bl = enabled;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n), (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), Conversions.booleanObject((boolean)bl), joinPoint};
        ImmiNode$AjcClosure3 immiNode$AjcClosure3 = new ImmiNode$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(immiNode$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.backwardsCompatibilityCheck();
        super.generateScriptCode(writer);
        return writer;
    }

    protected void backwardsCompatibilityCheck() {
        if (this.stepsEnabled == null) {
            this.initializeSteps();
        }
    }

    static {
        ImmiNode.ajc$preClinit();
    }

    static final /* synthetic */ void setStepsEnabled_aroundBody0(ImmiNode ajc$this, boolean[] stepsEnabled, JoinPoint joinPoint) {
        if (stepsEnabled == null || stepsEnabled.length != ajc$this.numberOfSteps) {
            throw new IllegalArgumentException(stepsEnabled == null ? "Supplied array is null" : "Supplied array has " + stepsEnabled.length + " elements instead of the expected " + ajc$this.numberOfSteps);
        }
        int i = 0;
        while (i < ajc$this.numberOfSteps) {
            ajc$this.stepsEnabled[i] = stepsEnabled[i];
            ++i;
        }
    }

    static final /* synthetic */ void setStepEnabled_aroundBody2(ImmiNode ajc$this, int step, boolean enabled, JoinPoint joinPoint) {
        ajc$this.backwardsCompatibilityCheck();
        if (step >= 0 && step < ajc$this.stepsEnabled.length && ajc$this.stepsEnabled[step] != enabled) {
            ajc$this.stepsEnabled[step] = enabled;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ImmiNode.java", ImmiNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setStepsEnabled", "com.ur.polyscope.immi.node.ImmiNode", "[Z", "stepsEnabled", "", "void"), 94);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setStepEnabled", "com.ur.polyscope.immi.node.ImmiNode", "int:boolean", "step:enabled", "", "void"), 105);
    }
}

