/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.immi.node;

import com.ur.polyscope.immi.internal.TextResource;
import com.ur.polyscope.immi.node.ImmiNode;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.view.constants.immi.ImmiInputSignal;
import com.ur.view.constants.immi.ImmiOutputSignal;
import javax.inject.Inject;

public class StartupCheckNode
extends ImmiNode {
    @Inject
    public StartupCheckNode(TextResource textResource) {
        super(18, textResource);
        this.setNodeTypeName(textResource.e67StartupCheck());
    }

    public String toString() {
        return this.textResource.e67StartupCheck();
    }

    @Override
    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        this.backwardsCompatibilityCheck();
        writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
        if (this.stepsEnabled[0]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ROBOT_OPERATION_MODE, true));
        }
        if (this.stepsEnabled[1]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.MOULD_AREA_FREE, true));
        }
        if (this.stepsEnabled[2]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_MOULD_CLOSURE, true));
        }
        if (this.stepsEnabled[3]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_FULL_MOULD_OPENING, true));
        }
        if (this.stepsEnabled[4]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_EJECTOR_BACK, true));
        }
        if (this.stepsEnabled[5]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_EJECTOR_FORWARD, true));
        }
        if (this.stepsEnabled[6]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_1_TO_POS_1, true));
        }
        if (this.stepsEnabled[7]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_1_TO_POS_2, true));
        }
        if (this.stepsEnabled[8]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_2_TO_POS_1, true));
        }
        if (this.stepsEnabled[9]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_MOVE_CORE_PULLERS_2_TO_POS_2, true));
        }
        if (this.stepsEnabled[10]) {
            writer.appendLine("popup(\"Press CONTINUE to activate robot operation\", \"IMMI Message\", False, False, True)");
        }
        if (this.stepsEnabled[11]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ROBOT_OPERATION_MODE, false));
        }
        if (this.stepsEnabled[12]) {
            writer.whileCondition(StartupCheckNode.generateGetEuromapInput(ImmiInputSignal.MOULD_CLOSED, false));
            writer.sync();
            writer.end();
        }
        if (this.stepsEnabled[13]) {
            this.generateHaltTestWithPopup(writer, StartupCheckNode.generateGetEuromapInput(ImmiInputSignal.EJECTOR_FORWARD_POSITION, true), this.toString(), 14, this.textResource.EjectorIsInFront());
        }
        if (this.stepsEnabled[14]) {
            this.generateHaltTestWithPopup(writer, StartupCheckNode.generateGetEuromapInput(ImmiInputSignal.EJECTOR_BACK_POSITION, false), this.toString(), 15, this.textResource.EjectorIsNotAtBack());
        }
        if (this.stepsEnabled[15]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_EJECTOR_BACK, false));
        }
        if (this.stepsEnabled[16]) {
            writer.appendLine(StartupCheckNode.generateSetEuromapOutput(ImmiOutputSignal.ENABLE_EJECTOR_FORWARD, false));
        }
        if (this.stepsEnabled[17]) {
            writer.sleep(0.04);
        }
        return writer;
    }
}

