/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio;

import com.ur.polyscope.pin.iotab.PinName;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.polyscope.viewfacade.resources.ViewfacadeImageResource;
import com.ur.swing.URFontFactory;
import com.ur.util.swing.HTML;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class DigitalNamedIO
extends JPanel {
    private static final String TRUNCATE_SUFFIX = "...";
    private static final Icon LOCKED_OUTPUT_ON = ViewfacadeImageResource.selectedGreyIO();
    private static final Icon LOCKED_OUTPUT_OFF = ViewfacadeImageResource.unselectedGreyIO();
    private static final Icon OUTPUT_ON = ViewfacadeImageResource.selectedIO();
    private static final Icon OUTPUT_OFF = ViewfacadeImageResource.unselectedIO();
    private final URFontFactory fontFactory;
    private final PinName name = new PinName();
    private JLabel label;
    private Pin<?> pin;
    private boolean ioPanelEnabled = true;
    private boolean selected = false;
    private final List<ActionListener> actionListeners = new ArrayList<ActionListener>();

    public DigitalNamedIO(URFontFactory fontFactory) {
        this.fontFactory = fontFactory;
        this.initComponents();
    }

    public void initialize(Pin<?> pin) {
        this.pin = pin;
        this.setSelected(false);
    }

    public Pin<?> getPin() {
        return this.pin;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.updateView();
    }

    public void setNameForLabel(String name) {
        this.label.setName(name);
    }

    public void setBulletAtTheEnd(boolean doOrDoNot) {
        this.label.setHorizontalAlignment(doOrDoNot ? 4 : 2);
        this.label.setHorizontalTextPosition(doOrDoNot ? 2 : 4);
    }

    public void updateView() {
        if (this.pin == null) {
            return;
        }
        if (this.selected) {
            this.label.setIcon(this.ioPanelEnabled ? OUTPUT_ON : LOCKED_OUTPUT_ON);
        } else {
            this.label.setIcon(this.ioPanelEnabled ? OUTPUT_OFF : LOCKED_OUTPUT_OFF);
        }
        this.adjustLabelFontSize();
        this.label.setText("<html>" + this.createRenderedLabelText() + "</html>");
    }

    private String truncate(String s, JLabel label, String truncateSuffix, int maxWidthOfLabel) {
        if (label.getWidth() > 0) {
            FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
            while (fontMetrics.stringWidth(s) > maxWidthOfLabel) {
                int symbolsToCut;
                int n = symbolsToCut = s.endsWith(truncateSuffix) ? truncateSuffix.length() + 1 : truncateSuffix.length();
                if (s.length() - symbolsToCut > 0) {
                    s = s.substring(0, s.length() - symbolsToCut) + truncateSuffix;
                    continue;
                }
                return truncateSuffix;
            }
        }
        return s;
    }

    private String createTruncatedLabelText() {
        return this.truncate(this.createLabelText(), this.label, TRUNCATE_SUFFIX, this.getMaxTextWidth());
    }

    private int getMaxTextWidth() {
        int maxWidth = this.label.getWidth() - this.label.getIcon().getIconWidth() - 10;
        return maxWidth > 0 ? maxWidth : 0;
    }

    private void adjustLabelFontSize() {
        int maxTextWidth = this.getMaxTextWidth();
        String userDefinedName = this.createLabelText();
        Font font = this.fontFactory.getBestFitFont((JComponent)this.label, maxTextWidth, userDefinedName, new URFontFactory.Size[]{URFontFactory.Size.DEFAULT, URFontFactory.Size.SMALL, URFontFactory.Size.VERY_SMALL, URFontFactory.Size.TINY});
        this.label.setFont(font);
    }

    public void toggle() {
        this.setSelected(!this.isSelected());
    }

    private String createRenderedLabelText() {
        if (this.pin.isInput() || this.ioPanelEnabled) {
            return HTML.fontColor((String)"black", (String)this.createTruncatedLabelText());
        }
        return HTML.italic((String)HTML.fontColor((String)"gray", (String)this.createTruncatedLabelText()));
    }

    private String createLabelText() {
        return this.name.toLabel(this.pin);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.ioPanelEnabled = enabled;
        this.updateView();
    }

    @Override
    public boolean isEnabled() {
        return this.ioPanelEnabled;
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.actionListeners.contains(actionListener)) {
            this.actionListeners.add(actionListener);
        }
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.label = new JLabel();
        this.setOpaque(false);
        this.label.setFont(this.fontFactory.getRelativeFont(URFontFactory.Style.DEFAULT, URFontFactory.Size.DEFAULT));
        this.label.setHorizontalAlignment(2);
        this.label.setText("IO Name");
        this.label.setPreferredSize(UIManager.getDimension("DigitalNamedIO.dimensions"));
        this.label.setMinimumSize(UIManager.getDimension("DigitalNamedIO.dimensions"));
        this.label.setMaximumSize(UIManager.getDimension("DigitalNamedIO.dimensions"));
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DigitalNamedIO.this.labelMousePressed();
            }
        });
        this.add(this.label);
    }

    protected void labelMousePressed() {
        if (this.ioPanelEnabled) {
            this.toggle();
            for (ActionListener each : this.actionListeners) {
                each.actionPerformed(null);
            }
        }
    }

    public String getLabelText() {
        return this.label.getText();
    }
}

