/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio;

import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamingService;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.immi.ImmiSignal;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.polyscope.oldio.IONamesTabHelperFunctions;
import com.ur.polyscope.oldio.IONamesTableCellRenderer;
import com.ur.polyscope.oldio.IONamesTableModel;
import com.ur.polyscope.oldio.OutputPinActionListCellRenderer;
import com.ur.polyscope.oldio.internal.TextResource;
import com.ur.polyscope.oldio.pulse.ContinuousPulseInstallationComponent;
import com.ur.polyscope.pin.AbstractRegister;
import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.pin.ConfigurableIOPin;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.GeneralPurposeBooleanRegister;
import com.ur.polyscope.pin.GeneralPurposeFloatRegister;
import com.ur.polyscope.pin.GeneralPurposeIntRegister;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.ModifiablePin;
import com.ur.polyscope.pin.OutputActionPin;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.ToolIOPin;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.actions.InputPinActionLookupService;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.pin.iotab.ControllerSocketSender;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumEvent;
import com.ur.polyscope.safety.checksum.ActiveSafetyChecksumListener;
import com.ur.polyscope.viewfacade.pin.IOServiceType;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.CardPanel;
import com.ur.swing.CompletedListener;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.TextProvider;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.card.CardLayoutUtil;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.CollectionUtils;
import com.ur.util.Disjunction;
import com.ur.util.Predicate;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.util.logging.Log;
import com.ur.view.constants.modbus.ModbusType;
import com.ur.view.modbus.ModbusSignal;
import gui.program.services.ProgramReferenceService;
import gui.tools.dialogs.input.NameValidationFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class IONamesTab
extends CardPanel {
    public static final String IO_FILTER = "ioFilter.IONamesTab";
    public static final String RENAME_IO = "renameIo.IONamesTab";
    public static final String INPUT_IOS = "inputIos.IONamesTab";
    public static final String OUTPUT_IOS = "outputIos.IONamesTab";
    public static final String RESET_NAME = "resetIoName.IONamesTab";
    public static final String SHOW_IO_NAMES_ACTION = "showIONamesAction." + IONamesTab.class.getSimpleName();
    public static final String INPUT_ACTION_LIST = "inputActionList.IONamesTab";
    public static final String OUTPUT_ACTION_LIST = "choiceAtProgramStop.IONamesTab";
    public static final String IO_TAB_CONTROL_OPTIONS = "ioTabControlOptions.IONamesTab";
    private static final int DISABLED_CONTROL = 2;
    private static final int ENABLED_CONTROL = 0;
    private final Map<IOService.IOSignalType, Predicate> predicates = new EnumMap<IOService.IOSignalType, Predicate>(new HashMap<IOService.IOSignalType, Predicate>(){
        {
            this.put(IOService.IOSignalType.ANALOG, new Predicate.ByType(AnalogIOPin.class));
            this.put(IOService.IOSignalType.Boolean, new ByServiceType(IOServiceType.BOOLEAN));
            this.put(IOService.IOSignalType.Configurable, new Predicate.ByType(ConfigurableIOPin.class));
            this.put(IOService.IOSignalType.Float, new ByServiceType(IOServiceType.FLOAT));
            this.put(IOService.IOSignalType.Integer, new ByServiceType(IOServiceType.INTEGER));
            this.put(IOService.IOSignalType.DIGITAL, new ByServiceType(IOServiceType.DIGITAL));
            this.put(IOService.IOSignalType.TOOL, new Disjunction(){
                {
                    this.addFilter((Predicate)new Predicate.ByType(ToolIOPin.class));
                    this.addFilter(new Predicate(){

                        public boolean test(Object o) {
                            return o instanceof AnalogIOPin && (((AnalogIOPin)o).getPin() == 2 || ((AnalogIOPin)o).getPin() == 3) && !IONamesTab.this.toolCommEnabled;
                        }
                    });
                }
            });
            this.put(IOService.IOSignalType.MODBUS, new Predicate.ByType(ModbusSignal.class));
            this.put(IOService.IOSignalType.IMMI, new Predicate.ByType(ImmiSignal.class));
            this.put(IOService.IOSignalType.ALL, new Predicate.AllowAll());
        }
    });
    protected JComboBox ioFilter;
    protected JPanel renamePanel;
    private Selection selectingPinsFrom = Selection.NONE;
    private final IOService ioService;
    private final ProgramReferenceService programReferenceService;
    private final NamingService nameServer;
    protected final ViewComponent continuousPulseView;
    protected final ViewContext viewContext;
    private boolean initializingPin;
    private boolean toolCommEnabled = false;
    protected boolean ioFilterActive = true;
    protected final TextResource textResource;
    protected final com.ur.i18n.TextResource i18nTextResource;
    protected final com.ur.polyscope.pin.internal.TextResource pinTextResource;
    protected final InstallationComponentLookup installationComponentLookup;
    protected JPanel bottomPanel;
    protected final JComboBox choiceAtProgramStopComboBox = new JComboBox();
    protected final JLabel choiceAtProgramStopLabel = new JLabel("<PinAction>");
    protected final JComboBox digitalInActionComboBox = new JComboBox();
    protected final JLabel digitalInActionLabel = new JLabel("<PinAction>");
    protected final JTable inputNamesTable = new JTable();
    protected final IONamesTableModel inputNamesTableModel = new IONamesTableModel();
    protected final JTable outputNamesTable = new JTable();
    protected final IONamesTableModel outputNamesTableModel = new IONamesTableModel();
    protected JPanel ioActionCardPanel;
    protected JPanel highLowCardPanel;
    protected final JTextField ioCustomNameTextField = new JTextField();
    protected JPanel ioTabControlCardPanel;
    protected final JLabel renameLabel = new JLabel();
    protected final JButton resetName = new JButton();
    protected final JComboBox signalOptionsComboBox = new JComboBox();
    protected JLabel signalOptionsLabel;
    protected JLabel selectedPinLabel = new JLabel();
    protected URFontFactory fontFactory;
    protected final InputPinActionLookupService inputPinActionLookupService;
    private final HelpIdAssigner helpIdAssigner;

    @Inject
    IONamesTab(InstallationComponentLookup installationComponentLookup, ProgramReferenceService programReferenceService, NamingService nameServer, ViewComponent continuousPulseView, @Source(value=ToolCommInfo.class) Recipe<ToolCommInfo> toolCommInfoRecipe, ViewContext viewContext, InputPinActionLookupService inputPinActionLookupService, HelpIdAssigner helpIdAssigner) {
        this.installationComponentLookup = installationComponentLookup;
        this.programReferenceService = programReferenceService;
        this.nameServer = nameServer;
        this.continuousPulseView = continuousPulseView;
        this.viewContext = viewContext;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.i18nTextResource = (com.ur.i18n.TextResource)viewContext.getTextResource(com.ur.i18n.TextResource.class);
        this.pinTextResource = (com.ur.polyscope.pin.internal.TextResource)viewContext.getTextResource(com.ur.polyscope.pin.internal.TextResource.class);
        this.inputPinActionLookupService = inputPinActionLookupService;
        this.helpIdAssigner = helpIdAssigner;
        this.fontFactory = viewContext.getFontFactory();
        this.ioService = (IOService)installationComponentLookup.getComponent(IOService.class);
        this.signalOptionsLabel = new JLabel(this.textResource.signalOptions());
        continuousPulseView.setModifyListener((ViewComponent.ModifyListener)new UpdateContinuousPulse());
        this.configureIOTables(this.inputNamesTable, this.inputNamesTableModel);
        this.configureIOTables(this.outputNamesTable, this.outputNamesTableModel);
        this.addAndLayoutComponents();
        this.configureComponents();
        this.setComponentNames();
        this.assignHelpIds();
        toolCommInfoRecipe.distinctUntilChanged().executeOnUIThread().subscribe((Consumer)new Consumer<ToolCommInfo>(){

            public void accept(ToolCommInfo toolCommInfo) {
                IONamesTab.this.toolCommEnabled = toolCommInfo.isEnabled();
                IONamesTab.this.populateIOLists();
            }
        });
        EventNotificationService.register((Object)((Object)this), ActiveSafetyChecksumListener.class, (Object)new UpdateImmiChecksumListener(installationComponentLookup));
    }

    private void configureIOTables(JTable table, IONamesTableModel tableModel) {
        table.setModel(tableModel);
        table.setDefaultRenderer(Object.class, new IONamesTableCellRenderer(this.fontFactory));
        table.getColumnModel().setColumnMargin(0);
        table.setShowGrid(false);
        table.setTableHeader(null);
        this.setTableWidths(table);
        table.setBorder(BorderFactory.createMatteBorder(0, 4, 0, 4, Color.WHITE));
    }

    protected abstract void setTableWidths(JTable var1);

    private void populateTableModel(IONamesTableModel tableModel, JTable table, List<Pin<?>> pins) {
        tableModel.setPins(CollectionUtils.filter(pins, (Predicate)this.predicates.get(this.ioFilter.getSelectedItem())));
        table.getSelectionModel().setSelectionMode(0);
        for (int row = 0; row < tableModel.getRowCount(); ++row) {
            if (tableModel.hasSeparatorOnRow(row)) {
                if (table.getRowHeight(row) == 12) continue;
                table.setRowHeight(row, 12);
                continue;
            }
            if (table.getRowHeight(row) == 24) continue;
            table.setRowHeight(row, 24);
        }
    }

    protected abstract void addAndLayoutComponents();

    public void enter(Object o) {
        super.enter(o);
        this.populateIOLists();
    }

    protected void populateIOLists() {
        if (this.ioFilterActive) {
            this.populateTableModel(this.inputNamesTableModel, this.inputNamesTable, this.getIONameService().getAllInputs());
            this.populateTableModel(this.outputNamesTableModel, this.outputNamesTable, this.getIONameService().getAllOutputs());
        }
    }

    private void configureComponents() {
        this.ioCustomNameTextField.setFocusable(false);
        this.ioCustomNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IONamesTab.this.updateRename();
            }
        });
        TextHolder textHolder = new TextHolder(){

            public String getText() {
                return IONamesTab.this.ioCustomNameTextField.getText();
            }

            public void setText(String text) {
                IONamesTab.this.ioCustomNameTextField.setText(text);
            }
        };
        ValidationStrategy validationStrategy = NameValidationFactory.getVariableNameAllowingEmptyValidator((TextProvider)new TextProvider(){

            public String getText() {
                return IONamesTab.this.getUserDefinedName(IONamesTab.this.getSelectedPin());
            }
        }, (NamingService)this.nameServer, Pin.class, (com.ur.i18n.TextResource)this.i18nTextResource);
        TextFieldUtils.bindTextPicker((JComponent)this.ioCustomNameTextField, (TextHolder)textHolder, (CompletedListener)new CompletedListener.Template(){

            public void requestApply() {
                IONamesTab.this.updateRename();
            }
        }, (ValidationStrategy)validationStrategy);
        new URFingerDragScrollMouseListener((Component)this.inputNamesTable);
        new URFingerDragScrollMouseListener((Component)this.outputNamesTable);
        this.inputNamesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (IONamesTab.this.selectingPinsFrom != Selection.OUTPUT) {
                    IONamesTab.this.selectingPinsFrom = Selection.INPUT;
                    IONamesTab.this.outputNamesTable.clearSelection();
                    IONamesTab.this.initializingPin = true;
                    IONamesTab.this.updateScreen();
                    IONamesTab.this.initializingPin = false;
                    IONamesTab.this.selectingPinsFrom = Selection.NONE;
                }
            }
        });
        this.outputNamesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (IONamesTab.this.selectingPinsFrom != Selection.INPUT) {
                    IONamesTab.this.selectingPinsFrom = Selection.OUTPUT;
                    IONamesTab.this.inputNamesTable.clearSelection();
                    IONamesTab.this.initializingPin = true;
                    IONamesTab.this.updateScreen();
                    IONamesTab.this.initializingPin = false;
                    IONamesTab.this.selectingPinsFrom = Selection.NONE;
                }
            }
        });
        this.ioFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IONamesTab.this.populateIOLists();
            }
        });
        this.digitalInActionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IONamesTab.this.digitalInActionComboBoxActionPerformed();
            }
        });
        this.choiceAtProgramStopComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IONamesTab.this.choiceAtProgramStopComboBoxItemStateChanged();
            }
        });
        this.signalOptionsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                IONamesTab.this.signalOptionsComboBoxItemStateChanged();
            }
        });
        this.resetName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IONamesTab.this.resetNameToDefault();
            }
        });
        this.updateScreen();
    }

    private void updateRename() {
        Pin selectedPin = this.getSelectedPin();
        String newName = this.ioCustomNameTextField.getText();
        if (this.ioCustomNameTextField.getText().isEmpty()) {
            selectedPin.setName("");
        } else if (DisplayMessageFactory.hasError((Component)this.ioCustomNameTextField)) {
            String oldName = StringUtils.ensureEmptyString((String)selectedPin.getDefinedName());
            this.ioCustomNameTextField.setText(oldName);
        } else {
            selectedPin.setName(newName);
            this.ioCustomNameTextField.setText(selectedPin.getName());
        }
        this.inputNamesTable.repaint();
        this.outputNamesTable.repaint();
    }

    private void setComponentNames() {
        this.ioFilter.setName(IO_FILTER);
        this.ioCustomNameTextField.setName(RENAME_IO);
        this.inputNamesTable.setName(INPUT_IOS);
        this.outputNamesTable.setName(OUTPUT_IOS);
        this.resetName.setName(RESET_NAME);
        this.digitalInActionComboBox.setName(INPUT_ACTION_LIST);
        this.choiceAtProgramStopComboBox.setName(OUTPUT_ACTION_LIST);
        this.signalOptionsComboBox.setName(IO_TAB_CONTROL_OPTIONS);
    }

    private void flipToCard(String name) {
        CardLayoutUtil.flipToCard((JPanel)this.ioActionCardPanel, (String)name);
        CardLayoutUtil.flipToCard((JPanel)this.ioTabControlCardPanel, (String)name);
    }

    private void updateRenameField(Pin selectedPin) {
        this.ioCustomNameTextField.setEnabled(this.isNameEditable(selectedPin));
        this.resetName.setEnabled(this.isNameEditable(selectedPin));
        this.renameLabel.setEnabled(this.isNameEditable(selectedPin));
        this.ioCustomNameTextField.setText(this.getUserDefinedName(selectedPin));
        String renameText = this.textResource.rename();
        if (selectedPin instanceof AbstractRegister) {
            renameText = renameText + " (" + this.textResource.toUseInPrograms() + ")";
        }
        this.renameLabel.setText(renameText);
    }

    private void inputActionSetup(Pin selectedPin) {
        boolean enabled;
        CardLayoutUtil.flipToCard((JPanel)this.highLowCardPanel, (String)"emptyCard");
        boolean bl = enabled = IONamesTabHelperFunctions.isInputActionPin(selectedPin) && ((InputActionPin)selectedPin).getIOPinAction() instanceof DefaultInputPinAction;
        if (selectedPin instanceof ConfigurableIOPin) {
            boolean bl2 = enabled = enabled && selectedPin.isUnassigned();
        }
        if (selectedPin instanceof ToolIOPin) {
            boolean bl3 = enabled = enabled && selectedPin.isUnassigned();
        }
        if (selectedPin instanceof ModbusSignal) {
            enabled = ((ModbusSignal)selectedPin).getModbusType() == ModbusType.DIGITAL_INPUT;
        }
        PinAction inputPinAction = DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
        if (enabled) {
            InputActionPin pin = (InputActionPin)selectedPin;
            inputPinAction = pin.getIOPinAction();
        }
        this.digitalInActionComboBox.setSelectedItem(((DefaultInputPinAction)inputPinAction).getInputPinAction());
        this.digitalInActionComboBox.setEnabled(enabled);
        this.digitalInActionLabel.setEnabled(enabled);
        this.updateWidthOfActionComboBox(this.digitalInActionComboBox);
    }

    protected void outputActionSetup(Pin selectedElement) {
        this.choiceAtProgramStopComboBox.removeAllItems();
        this.choiceAtProgramStopComboBox.addItem(OutputPinAction.NONE);
        OutputPinAction action = OutputPinAction.NONE;
        boolean enabled = IONamesTabHelperFunctions.hasExtendedOptions(selectedElement);
        int modificationChoice = 2;
        if (enabled) {
            ModifiablePin pin = (ModifiablePin)selectedElement;
            modificationChoice = pin.getModificationChoice();
            this.populateChocieAtProgramStopComboBox(selectedElement);
            this.choiceAtProgramStopComboBox.setRenderer(new OutputPinActionListCellRenderer(this.pinTextResource, selectedElement.getValueType()));
            action = pin.getOutputAction();
        }
        if (this.selectionOutsideOfBounds(action)) {
            action = OutputPinAction.NONE;
            enabled = false;
        }
        if (action == OutputPinAction.CONTINUOUS_PULSE) {
            PinReference pinReference = this.programReferenceService.getPinReference(this.outputNamesTableModel.getPinAt(this.outputNamesTable.getSelectedRow()));
            ContinuousPulseInstallationComponent installationComponent = (ContinuousPulseInstallationComponent)this.installationComponentLookup.getComponent(ContinuousPulseInstallationComponent.class);
            if (installationComponent.containsPinReference(pinReference)) {
                DomainComponent pulse = installationComponent.getContinuousPulse(pinReference);
                this.continuousPulseView.setDomain(pulse);
            } else {
                DomainComponent pulse = installationComponent.getContinuousPulse(pinReference);
                this.continuousPulseView.setDomain(pulse);
                Log.warning((String)"Continuous Pulse definition missing");
            }
            CardLayoutUtil.flipToCard((JPanel)this.highLowCardPanel, (String)"continuousPulseCard");
        } else {
            CardLayoutUtil.flipToCard((JPanel)this.highLowCardPanel, (String)"emptyCard");
        }
        this.updateSignalOptionsComboBox(modificationChoice, selectedElement);
        this.choiceAtProgramStopComboBox.setSelectedItem(action);
        this.choiceAtProgramStopComboBox.setEnabled(enabled);
        this.choiceAtProgramStopLabel.setEnabled(enabled);
        this.updateWidthOfActionComboBox(this.choiceAtProgramStopComboBox);
    }

    protected boolean doesPinSupportPulseAction(Pin<?> pin) {
        return pin.getValueType() == IOServiceType.DIGITAL || pin.getValueType() == IOServiceType.BOOLEAN;
    }

    protected abstract void populateChocieAtProgramStopComboBox(Pin<?> var1);

    private void updateSignalOptionsComboBox(int modificationChoice, Pin selectedElement) {
        OutputPinAction action = OutputPinAction.NONE;
        if (selectedElement instanceof OutputActionPin) {
            action = ((OutputActionPin)selectedElement).getOutputAction();
        }
        if (action == OutputPinAction.NONE && IONamesTab.isAvailableOnIoTab(selectedElement)) {
            this.signalOptionsLabel.setEnabled(true);
            this.signalOptionsComboBox.setEnabled(true);
            this.signalOptionsComboBox.setSelectedIndex(modificationChoice);
        } else {
            this.signalOptionsLabel.setEnabled(false);
            this.signalOptionsComboBox.setEnabled(false);
            this.signalOptionsComboBox.setSelectedIndex(2);
        }
    }

    private boolean selectionOutsideOfBounds(OutputPinAction action) {
        return ((DefaultComboBoxModel)this.choiceAtProgramStopComboBox.getModel()).getIndexOf(action) == -1;
    }

    private static boolean isAvailableOnIoTab(Pin element) {
        boolean result = !(element instanceof ConfigurableIOPin) || !((ConfigurableIOPin)element).isSafetyOutputPin();
        return result &= !(element instanceof GeneralPurposeBooleanRegister) && !(element instanceof GeneralPurposeFloatRegister) && !(element instanceof GeneralPurposeIntRegister);
    }

    protected abstract void updateWidthOfActionComboBox(JComboBox var1);

    private void updateScreen() {
        Pin selectedPin = this.getSelectedPin();
        this.updateRenameField(selectedPin);
        String bottomCardType = "selectIOCard";
        if (selectedPin != null) {
            String actionCardType;
            this.selectedPinLabel.setText(this.getPinName(selectedPin));
            bottomCardType = "actionsCard";
            if (selectedPin.isInput()) {
                actionCardType = "digitalInCard";
                this.inputActionSetup(selectedPin);
            } else {
                actionCardType = "outputLevelCard";
                this.outputActionSetup(selectedPin);
            }
            this.flipToCard(actionCardType);
        }
        CardLayoutUtil.flipToCard((JPanel)this.bottomPanel, (String)bottomCardType);
        this.repaint();
    }

    protected String getPinName(Pin<?> pin) {
        return pin.useDisplayNameOverDefaultName() ? pin.getDisplayName() : pin.getDefaultName();
    }

    private String getUserDefinedName(Pin selectedPin) {
        if (this.isNameEditable(selectedPin)) {
            return StringUtils.ensureEmptyString((String)selectedPin.getDefinedName());
        }
        return "";
    }

    private void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:installation_iosetup");
        this.helpIdAssigner.assignHelpId((JComponent)this.ioFilter, "gui:installation_io_signal_type_filtering");
        this.helpIdAssigner.assignHelpId((JComponent)this.renamePanel, "gui:installation_assign_user_defined_names");
        this.helpIdAssigner.assignHelpId((JComponent)this.ioTabControlCardPanel, "gui:installation_io_actions_and_io_tab_control");
        this.helpIdAssigner.assignHelpId((JComponent)this.ioActionCardPanel, "gui:installation_io_actions_and_io_tab_control");
    }

    private IOService getIONameService() {
        return this.ioService;
    }

    public DefaultComboBoxModel generateSignalOptionsComboBoxModel() {
        DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>();
        cbModel.addElement(this.textResource.enabled());
        cbModel.addElement(this.textResource.operationalModeManualOnly());
        cbModel.addElement(this.textResource.disabled());
        return cbModel;
    }

    private Pin getSelectedPin() {
        return this.inputNamesTable.getSelectedRow() > -1 ? this.inputNamesTableModel.getPinAt(this.inputNamesTable.getSelectedRow()) : this.outputNamesTableModel.getPinAt(this.outputNamesTable.getSelectedRow());
    }

    private void resetNameToDefault() {
        Pin selectedElement = this.getSelectedPin();
        selectedElement.setName("");
        this.initializingPin = true;
        this.updateScreen();
        this.initializingPin = false;
    }

    private void digitalInActionComboBoxActionPerformed() {
        if (this.initializingPin) {
            return;
        }
        Pin element = this.getSelectedPin();
        if (IONamesTabHelperFunctions.isInputActionPin(element)) {
            InputActionPin inputActionPin = (InputActionPin)element;
            InputPinAction choice = (InputPinAction)this.digitalInActionComboBox.getSelectedItem();
            inputActionPin.setIOPinAction(this.inputPinActionLookupService.getPinAction(choice));
            String script = inputActionPin.generateInputActionScriptCode();
            ControllerSocketSender.sendAsSecondaryProgram((String)script);
        }
        this.updateScreen();
    }

    private void signalOptionsComboBoxItemStateChanged() {
        if (this.initializingPin) {
            return;
        }
        Pin selected = this.getSelectedPin();
        if (selected instanceof ModifiablePin) {
            ((ModifiablePin)selected).setModificationChoice(this.signalOptionsComboBox.getSelectedIndex());
        }
        this.inputNamesTable.repaint();
        this.outputNamesTable.repaint();
    }

    private void choiceAtProgramStopComboBoxItemStateChanged() {
        if (this.initializingPin) {
            return;
        }
        Pin selected = this.getSelectedPin();
        if (selected instanceof OutputActionPin) {
            OutputPinAction action = (OutputPinAction)this.choiceAtProgramStopComboBox.getSelectedItem();
            OutputActionPin pin = (OutputActionPin)selected;
            pin.setOutputAction(action);
            String choice = pin.generateRunstateDependentChoice();
            ControllerSocketSender.sendAsSecondaryProgram((String)choice);
            PinReference pinReference = this.programReferenceService.getPinReference(selected);
            if (action == OutputPinAction.CONTINUOUS_PULSE) {
                CardLayoutUtil.flipToCard((JPanel)this.highLowCardPanel, (String)"continuousPulseCard");
                ContinuousPulseInstallationComponent installationComponent = (ContinuousPulseInstallationComponent)this.installationComponentLookup.getComponent(ContinuousPulseInstallationComponent.class);
                DomainComponent pulse = installationComponent.getContinuousPulse(pinReference);
                this.continuousPulseView.setDomain(pulse);
            } else {
                CardLayoutUtil.flipToCard((JPanel)this.highLowCardPanel, (String)"emptyCard");
                ContinuousPulseInstallationComponent installationComponent = (ContinuousPulseInstallationComponent)this.installationComponentLookup.getComponent(ContinuousPulseInstallationComponent.class);
                installationComponent.removeContinuousPulse(pinReference);
            }
        }
        this.updateSignalOptionsComboBox(0, selected);
        this.ioCustomNameTextField.setEnabled(this.isNameEditable(this.getSelectedPin()));
        this.resetName.setEnabled(this.isNameEditable(this.getSelectedPin()));
        this.renameLabel.setEnabled(this.isNameEditable(this.getSelectedPin()));
        this.ioCustomNameTextField.setText(this.getUserDefinedName(this.getSelectedPin()));
        this.inputNamesTable.repaint();
        this.outputNamesTable.repaint();
    }

    protected boolean isNameEditable(Pin selectedElement) {
        if (selectedElement instanceof ModbusSignal || selectedElement instanceof ImmiSignal) {
            return false;
        }
        if (selectedElement instanceof ConfigurableIOPin) {
            return selectedElement.isUnassigned();
        }
        if (selectedElement instanceof ToolIOPin) {
            return selectedElement.isUnassigned() && !((ToolIOPin)selectedElement).isPoweredPin();
        }
        return selectedElement != null;
    }

    protected void updateFilter(boolean immiEnabled) {
        this.ioFilterActive = false;
        this.ioFilter.removeAllItems();
        List filteredValues = CollectionUtils.filter((Object[])IOService.IOSignalType.values(), (Predicate)new ImmiPredicate(immiEnabled));
        for (IOService.IOSignalType value : filteredValues) {
            this.ioFilter.addItem(value);
        }
        this.ioFilterActive = true;
    }

    static class ImmiPredicate
    implements Predicate<IOService.IOSignalType> {
        private boolean immiEnabled;

        public ImmiPredicate(boolean immiEnabled) {
            this.immiEnabled = immiEnabled;
        }

        public boolean test(IOService.IOSignalType ioSignalType) {
            return ioSignalType != IOService.IOSignalType.IMMI || this.immiEnabled;
        }
    }

    private static class ByServiceType
    implements Predicate {
        private final IOServiceType serviceType;

        public ByServiceType(IOServiceType serviceType) {
            this.serviceType = serviceType;
        }

        public boolean test(Object o) {
            if (o instanceof Pin) {
                Pin pin = (Pin)o;
                return this.serviceType == pin.getValueType();
            }
            return false;
        }
    }

    protected class UpdateContinuousPulse
    implements ViewComponent.ModifyListener {
        protected UpdateContinuousPulse() {
        }

        public void onModified(DomainComponent pulse) {
            if (IONamesTab.this.choiceAtProgramStopComboBox.getSelectedItem() == OutputPinAction.CONTINUOUS_PULSE) {
                ((ContinuousPulseInstallationComponent)IONamesTab.this.installationComponentLookup.getComponent(ContinuousPulseInstallationComponent.class)).setContinuousPulsePin(pulse);
                Log.info((String)("Continuous Pulse added: " + pulse));
            } else {
                ((ContinuousPulseInstallationComponent)IONamesTab.this.installationComponentLookup.getComponent(ContinuousPulseInstallationComponent.class)).removeContinuousPulse(pulse);
                Log.info((String)("Continuous Pulse removed: " + pulse));
            }
            EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

                public void notify(InstallationStateListener installationStateListener) {
                    installationStateListener.installationModified();
                }
            });
        }
    }

    protected static class InputPinActionCellRenderer
    extends DefaultComboBoxRenderer {
        private final com.ur.polyscope.pin.internal.TextResource textResource;

        public InputPinActionCellRenderer(com.ur.polyscope.pin.internal.TextResource textResource) {
            this.textResource = textResource;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = ((InputPinAction)value).getLocalizedName(this.textResource);
            return super.getListCellRendererComponent(list, (Object)s, index, isSelected, cellHasFocus);
        }
    }

    private class UpdateImmiChecksumListener
    implements ActiveSafetyChecksumListener {
        private final InstallationComponentLookup installationLookupService;
        private boolean immiPresentAndEnabled;

        public UpdateImmiChecksumListener(InstallationComponentLookup installationLookupService) {
            this.installationLookupService = installationLookupService;
        }

        public void activeSafetyChecksumChanged(ActiveSafetyChecksumEvent e) {
            Immi immi = (Immi)this.installationLookupService.getComponent(Immi.class);
            boolean oldImmiPresentAndEnabled = this.immiPresentAndEnabled;
            boolean bl = this.immiPresentAndEnabled = immi != null && immi.isEnabled();
            if (oldImmiPresentAndEnabled != this.immiPresentAndEnabled) {
                IONamesTab.this.updateFilter(this.immiPresentAndEnabled);
            }
        }
    }

    private static enum Selection {
        NONE,
        INPUT,
        OUTPUT;

    }
}

