/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio;

import com.ur.polyscope.pin.ConfigurableIOPin;
import com.ur.polyscope.pin.DefaultInputPinAction;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.OutputActionPin;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.ToolIOPin;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.viewfacade.pin.Pin;

final class IONamesTabHelperFunctions {
    private IONamesTabHelperFunctions() {
    }

    static boolean isInputActionPin(Pin<?> value) {
        return value.isInput() && value instanceof InputActionPin;
    }

    static boolean isAssignedConfigurableIOPin(Pin<?> value) {
        if (value instanceof ConfigurableIOPin) {
            return ((ConfigurableIOPin)value).isSafetyOutputPin();
        }
        if (value instanceof ToolIOPin) {
            return ((ToolIOPin)value).isSafetyInputPin();
        }
        return false;
    }

    static boolean isInputActionPinWithAction(Pin<?> value) {
        boolean result = IONamesTabHelperFunctions.isInputActionPin(value);
        if (result) {
            PinAction action = ((InputActionPin)value).getIOPinAction();
            result = action != null && action != DefaultInputPinAction.INPUT_PIN_ACTION_NONE;
        }
        return result;
    }

    static boolean isOutputActionPinWithAction(Pin<?> element) {
        boolean result = IONamesTabHelperFunctions.isOutputPin(element);
        if (result) {
            OutputActionPin actionPin = (OutputActionPin)element;
            OutputPinAction action = actionPin.getOutputAction();
            result = action != null && action != OutputPinAction.NONE;
        }
        return result;
    }

    private static boolean isOutputPin(Pin<?> element) {
        return element instanceof OutputActionPin && !element.isInput();
    }

    static boolean hasExtendedOptions(Pin<?> element) {
        if (element instanceof ConfigurableIOPin && ((ConfigurableIOPin)element).isSafetyOutputPin()) {
            return false;
        }
        return IONamesTabHelperFunctions.isOutputPin(element);
    }
}

