/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio;

import com.ur.lang.naming.NamingService;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.polyscope.oldio.IONamesTab;
import com.ur.polyscope.oldio.internal.TextResource;
import com.ur.polyscope.pin.ModifiablePin;
import com.ur.polyscope.pin.ToolIOPin;
import com.ur.polyscope.pin.actions.InputPinAction;
import com.ur.polyscope.pin.actions.InputPinActionLookupService;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventNotificationService;
import gui.program.services.ProgramReferenceService;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;

public class IONamesTabImpl
extends IONamesTab {
    private static final int INPUT_BOX_HEIGHT = 31;
    private static final int INPUT_BOX_WIDTH = 327;
    private static final int MARGIN = 7;
    private static final int FRAME_MARGIN = 14;

    @Inject
    public IONamesTabImpl(InstallationComponentLookup installationComponentLookup, ProgramReferenceService programReferenceService, NamingService nameServer, @Named(value="continuous-pulse") ViewComponent continuousPulseView, @Source(value=ToolCommInfo.class) Recipe<ToolCommInfo> toolCommInfoRecipe, ViewContext context, InputPinActionLookupService inputPinActionLookupService, HelpIdAssigner helpIdAssigner) {
        super(installationComponentLookup, programReferenceService, nameServer, continuousPulseView, toolCommInfoRecipe, context, inputPinActionLookupService, helpIdAssigner);
    }

    @Override
    public void enter(Object o) {
        super.enter(o);
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                IONamesTabImpl.this.populateIOLists();
            }
        });
    }

    public Object exit() {
        EventNotificationService.unregister((Object)((Object)this), InstallationStateListener.class);
        return super.exit();
    }

    @Override
    protected void setTableWidths(JTable table) {
        table.getColumnModel().getColumn(0).setMaxWidth(30);
        table.getColumnModel().getColumn(0).setMinWidth(30);
        table.getColumnModel().getColumn(1).setMaxWidth(75);
        table.getColumnModel().getColumn(1).setMinWidth(75);
        table.getColumnModel().getColumn(2).setPreferredWidth(175);
        table.getColumnModel().getColumn(3).setPreferredWidth(150);
    }

    @Override
    protected void addAndLayoutComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.buildHeaderPanel(), "North");
        this.add(this.buildIOListPanel(), "Center");
        this.bottomPanel = this.buildBottomPanel();
        this.add(this.bottomPanel, "South");
    }

    @Override
    protected void updateWidthOfActionComboBox(JComboBox comboBox) {
        int width = 327;
        int maxWidth = Math.max(width, comboBox.getPreferredSize().width + 7);
        comboBox.setPreferredSize(new Dimension(comboBox.getPreferredSize().width, 31));
        comboBox.setMaximumSize(new Dimension(maxWidth, 31));
        comboBox.setMinimumSize(new Dimension(width, 31));
    }

    @Override
    protected void populateChocieAtProgramStopComboBox(Pin<?> selectedPin) {
        ModifiablePin pin = (ModifiablePin)selectedPin;
        this.choiceAtProgramStopComboBox.addItem(OutputPinAction.LOW_WHEN_PROGRAM_STOPPED);
        this.choiceAtProgramStopComboBox.addItem(OutputPinAction.HIGH_WHEN_PROGRAM_STOPPED);
        if (pin.isProgramStateModeSupported()) {
            this.choiceAtProgramStopComboBox.addItem(OutputPinAction.PROGRAM_RUNNING);
            this.choiceAtProgramStopComboBox.addItem(OutputPinAction.LOW_WHEN_PROGRAM_ABORTED);
            this.choiceAtProgramStopComboBox.addItem(OutputPinAction.LOW_WHEN_PROGRAM_ABORTED_HIGH_WHEN_NOT);
        }
        if (this.doesPinSupportPulseAction(selectedPin)) {
            this.choiceAtProgramStopComboBox.addItem(OutputPinAction.CONTINUOUS_PULSE);
        }
        if (!(pin instanceof ToolIOPin)) {
            this.choiceAtProgramStopComboBox.addItem(OutputPinAction.DRIVE_POWER_INDICATOR);
            this.choiceAtProgramStopComboBox.addItem(OutputPinAction.DRIVE_POWER_INDICATOR_HIGH_WHEN_NOT);
        }
    }

    private JPanel buildInputIOAction() {
        this.digitalInActionLabel.setText(this.textResource.action());
        this.digitalInActionComboBox.setModel(new DefaultComboBoxModel<InputPinAction>(InputPinAction.values()));
        this.digitalInActionComboBox.setRenderer(new IONamesTab.InputPinActionCellRenderer(this.pinTextResource));
        return this.viewContext.createFormBuilder().label(this.digitalInActionLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.digitalInActionComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().getPanel();
    }

    private JPanel buildOutputIOAction() {
        this.choiceAtProgramStopLabel.setText(this.textResource.actionInProgram());
        return this.viewContext.createFormBuilder().label(this.choiceAtProgramStopLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.choiceAtProgramStopComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().getPanel();
    }

    private JPanel buildIOTabControl() {
        this.signalOptionsComboBox.setModel(this.generateSignalOptionsComboBoxModel());
        return this.viewContext.createFormBuilder().label(this.signalOptionsLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.signalOptionsComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().getPanel();
    }

    private JPanel buildSelectIO() {
        return this.viewContext.createFormBuilder().label(new JLabel(this.textResource.selectIo()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().getPanel();
    }

    private JPanel buildRenamePanel() {
        this.ioCustomNameTextField.setText(this.textResource.newName());
        this.resetName.setText(this.textResource.clearName());
        return this.viewContext.createFormBuilder().label(this.renameLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.ioCustomNameTextField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.resetName, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT}).end().getPanel();
    }

    private JPanel buildIOActionCardPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new CardLayout());
        jPanel.add((Component)this.buildOutputIOAction(), "outputLevelCard");
        jPanel.add((Component)new JPanel(), "emptyCard");
        jPanel.add((Component)this.buildInputIOAction(), "digitalInCard");
        return jPanel;
    }

    private JPanel buildContinuousPulseCardPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new CardLayout());
        jPanel.add((Component)this.buildHighLowPanel(), "continuousPulseCard");
        jPanel.add((Component)new JPanel(), "emptyCard");
        return jPanel;
    }

    private JPanel buildIOTabControlCardPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new CardLayout());
        jPanel.add((Component)this.buildIOTabControl(), "outputLevelCard");
        jPanel.add((Component)new JPanel(), "emptyCard");
        jPanel.add((Component)new JPanel(), "digitalInCard");
        return jPanel;
    }

    private JPanel buildSelectedIOPanel() {
        JPanel selectedIOPanel = new JPanel();
        selectedIOPanel.setLayout(new BoxLayout(selectedIOPanel, 0));
        selectedIOPanel.add(new JLabel(this.textResource.selectedIO()));
        selectedIOPanel.add(Box.createHorizontalStrut(30));
        selectedIOPanel.add(this.selectedPinLabel);
        selectedIOPanel.setBorder(new EmptyBorder(0, 16, 0, 10));
        return selectedIOPanel;
    }

    private JPanel buildBottomActionsPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        JPanel selectedIOPanel = this.buildSelectedIOPanel();
        JPanel rowTop = new JPanel();
        rowTop.setLayout(new GridLayout(1, 2));
        this.renamePanel = this.buildRenamePanel();
        rowTop.add(this.renamePanel);
        this.ioTabControlCardPanel = this.buildIOTabControlCardPanel();
        rowTop.add(this.ioTabControlCardPanel);
        JPanel rowBottom = new JPanel();
        rowBottom.setLayout(new GridLayout(1, 2));
        this.ioActionCardPanel = this.buildIOActionCardPanel();
        rowBottom.add(this.ioActionCardPanel);
        this.highLowCardPanel = this.buildContinuousPulseCardPanel();
        rowBottom.add(this.highLowCardPanel);
        result.add((Component)selectedIOPanel, "North");
        result.add((Component)rowTop, "Center");
        result.add((Component)rowBottom, "South");
        return result;
    }

    private JComponent buildHighLowPanel() {
        return this.continuousPulseView.asComponent();
    }

    private JPanel buildBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new CardLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(14, 14, 17, 14));
        jPanel.add((Component)this.buildBottomActionsPanel(), "actionsCard");
        jPanel.add((Component)this.buildSelectIO(), "selectIOCard");
        return jPanel;
    }

    private JScrollPane buildJScrollPanel(String title, JTable table) {
        table.setFont(new Font("DejaVu", 0, 12));
        JScrollPane jScrollPane1 = new JScrollPane(table);
        AbstractBorder b = BorderFactory.createTitledBorder(title);
        b = BorderFactory.createCompoundBorder(b, BorderFactory.createEmptyBorder(7, 0, 0, 0));
        b = BorderFactory.createCompoundBorder(b, BorderFactory.createLineBorder(Color.BLACK));
        jScrollPane1.setBorder(b);
        jScrollPane1.setOpaque(false);
        jScrollPane1.getViewport().setBackground(Color.WHITE);
        return jScrollPane1;
    }

    private JPanel buildIOListPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 14, 0, 14));
        jPanel.add(this.buildJScrollPanel(this.textResource.inputNames(), this.inputNamesTable));
        jPanel.add(Box.createHorizontalStrut(7));
        jPanel.add(this.buildJScrollPanel(this.textResource.outputNames(), this.outputNamesTable));
        return jPanel;
    }

    private JPanel buildHeaderPanel() {
        this.ioFilter = new JComboBox();
        this.ioFilter.setRenderer(new IOFilterCellRenderer(this.viewContext));
        this.updateFilter(false);
        return this.viewContext.createFormBuilder().label(new JLabel(this.textResource.IOFilter()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.ioFilter, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_1_COLUMN}).end().getPanel();
    }

    protected static class IOFilterCellRenderer
    extends DefaultComboBoxRenderer {
        private final Map<IOService.IOSignalType, String> map = new HashMap<IOService.IOSignalType, String>();

        public IOFilterCellRenderer(ViewContext viewContext) {
            TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
            this.map.put(IOService.IOSignalType.ALL, textResource.iofilterAll());
            this.map.put(IOService.IOSignalType.DIGITAL, textResource.iofilterDigital());
            this.map.put(IOService.IOSignalType.ANALOG, textResource.iofilterAnalog());
            this.map.put(IOService.IOSignalType.TOOL, textResource.iofilterTool());
            this.map.put(IOService.IOSignalType.Configurable, textResource.iofilterConfigurable());
            this.map.put(IOService.IOSignalType.Boolean, textResource.iofilterBoolean());
            this.map.put(IOService.IOSignalType.Integer, textResource.iofilterInteger());
            this.map.put(IOService.IOSignalType.Float, textResource.iofilterFloat());
            this.map.put(IOService.IOSignalType.MODBUS, textResource.modbus());
            this.map.put(IOService.IOSignalType.IMMI, ((com.ur.polyscope.immi.internal.TextResource)viewContext.getTextResource(com.ur.polyscope.immi.internal.TextResource.class)).IMMI());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText(this.map.get(value));
            return this;
        }
    }
}

