/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio;

import com.ur.polyscope.oldio.IONamesTabHelperFunctions;
import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.pin.ConfigurableIOPin;
import com.ur.polyscope.pin.GeneralPurposeBooleanRegister;
import com.ur.polyscope.pin.GeneralPurposeFloatRegister;
import com.ur.polyscope.pin.GeneralPurposeIntRegister;
import com.ur.polyscope.pin.InputActionPin;
import com.ur.polyscope.pin.ModifiablePin;
import com.ur.polyscope.pin.OutputActionPin;
import com.ur.polyscope.pin.PinAction;
import com.ur.polyscope.pin.StandardIOPin;
import com.ur.polyscope.pin.ToolIOPin;
import com.ur.polyscope.pin.actions.OutputPinAction;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.view.constants.modbus.ModbusType;
import com.ur.view.modbus.ModbusSignal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class IONamesTableModel
extends AbstractTableModel {
    private Set<Integer> separators = new HashSet<Integer>();
    private Map<Integer, Pin<?>> pinsMap = new HashMap();

    public void setPins(Collection<Pin<?>> pins) {
        this.pinsMap.clear();
        this.separators.clear();
        this.addPinsToMap(pins);
        this.fireTableDataChanged();
    }

    private void addPinsToMap(Collection<Pin<?>> pins) {
        TreeMap pinGroups = new TreeMap(new PinTypeComparator());
        Map<ModbusType, List<Pin<?>>> modbusGroups = IONamesTableModel.hackyGetModbusTypeListMap();
        for (Pin<?> pin : pins) {
            Class<?> pinClass = pin.getClass();
            if (!pinGroups.containsKey(pinClass)) {
                pinGroups.put(pinClass, new ArrayList());
            }
            if (pin instanceof ModbusSignal) {
                modbusGroups.get(((ModbusSignal)pin).getModbusType()).add(pin);
                continue;
            }
            ((List)pinGroups.get(pinClass)).add(pin);
        }
        for (List list : pinGroups.values()) {
            this.addGroupToMap(list);
        }
        for (List list : modbusGroups.values()) {
            this.addGroupToMap(list);
        }
    }

    private static Map<ModbusType, List<Pin<?>>> hackyGetModbusTypeListMap() {
        EnumMap modbusGroups = new EnumMap(ModbusType.class);
        modbusGroups.put(ModbusType.UNDEFINED, new ArrayList());
        modbusGroups.put(ModbusType.DIGITAL_INPUT, new ArrayList());
        modbusGroups.put(ModbusType.DIGITAL_OUTPUT, new ArrayList());
        modbusGroups.put(ModbusType.REGISTER_INPUT, new ArrayList());
        modbusGroups.put(ModbusType.REGISTER_OUTPUT, new ArrayList());
        return modbusGroups;
    }

    private void addGroupToMap(List<Pin<?>> pins) {
        if (pins.isEmpty()) {
            return;
        }
        Collections.sort(pins, new Comparator<Pin<?>>(){

            @Override
            public int compare(Pin<?> o1, Pin<?> o2) {
                return Integer.valueOf(o1.getPin()).compareTo(o2.getPin());
            }
        });
        int row = this.getRowCount();
        if (row > 0) {
            this.separators.add(row);
            ++row;
        }
        for (Pin<?> pin : pins) {
            this.pinsMap.put(row, pin);
            ++row;
        }
    }

    public boolean hasSeparatorOnRow(int row) {
        return this.separators.contains(row);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.separators.size() + this.pinsMap.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String value = null;
        if (this.pinsMap.containsKey(rowIndex)) {
            Pin<?> pin = this.pinsMap.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    value = pin instanceof ModifiablePin ? this.getEnablement((ModifiablePin)pin) : "";
                    break;
                }
                case 1: {
                    value = pin.getShortName();
                    break;
                }
                case 2: {
                    value = this.getPinName(pin);
                    break;
                }
                case 3: {
                    value = this.getActionName(pin);
                    break;
                }
            }
            return value;
        }
        return value;
    }

    protected String getPinName(Pin<?> pin) {
        return pin.useDisplayNameOverDefaultName() ? pin.getDisplayName() : pin.getName();
    }

    private String getEnablement(ModifiablePin pin) {
        int modificationChoice = pin.getModificationChoice();
        switch (modificationChoice) {
            case 1: {
                return "-";
            }
            case 2: {
                return "%";
            }
        }
        return "";
    }

    public Pin getPinAt(int rowIndex) {
        Pin<?> result = null;
        if (this.pinsMap.containsKey(rowIndex)) {
            result = this.pinsMap.get(rowIndex);
        }
        return result;
    }

    private String getActionName(Pin<?> pin) {
        String result = "";
        if (IONamesTabHelperFunctions.isAssignedConfigurableIOPin(pin)) {
            result = this.getAssignedConfIOFunctionName(pin);
        } else if (IONamesTabHelperFunctions.isInputActionPinWithAction(pin)) {
            PinAction action = ((InputActionPin)pin).getIOPinAction();
            result = action.getShortFunctionName();
        } else if (IONamesTabHelperFunctions.isOutputActionPinWithAction(pin)) {
            OutputPinAction action = ((OutputActionPin)pin).getOutputAction();
            result = action.getShortFunctionName();
        }
        return result;
    }

    private String getAssignedConfIOFunctionName(Pin<?> pin) {
        if (pin instanceof ConfigurableIOPin) {
            return ((ConfigurableIOPin)pin).getFunctionName();
        }
        if (pin instanceof ToolIOPin) {
            return ((ToolIOPin)pin).getFunctionName();
        }
        throw new IllegalArgumentException("Pin is not a ConfigurableIOPin or ToolIOPin");
    }

    private static class PinTypeComparator
    implements Comparator<Class>,
    Serializable {
        private Map<Class, Integer> pinClassSortOrder = new HashMap<Class, Integer>();

        PinTypeComparator() {
            this.pinClassSortOrder.put(StandardIOPin.class, 0);
            this.pinClassSortOrder.put(ToolIOPin.class, 1);
            this.pinClassSortOrder.put(ConfigurableIOPin.class, 2);
            this.pinClassSortOrder.put(AnalogIOPin.class, 3);
            this.pinClassSortOrder.put(GeneralPurposeBooleanRegister.class, 4);
            this.pinClassSortOrder.put(GeneralPurposeIntRegister.class, 5);
            this.pinClassSortOrder.put(GeneralPurposeFloatRegister.class, 6);
        }

        @Override
        public int compare(Class o1, Class o2) {
            int v1 = this.pinClassSortOrder.containsKey(o1) ? this.pinClassSortOrder.get(o1) : Integer.MAX_VALUE;
            int v2 = this.pinClassSortOrder.containsKey(o2) ? this.pinClassSortOrder.get(o2) : Integer.MAX_VALUE;
            return v1 - v2;
        }
    }
}

