/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio;

import com.ur.injection.Builder;
import com.ur.polyscope.oldio.IOActionFactory;
import com.ur.polyscope.oldio.RobotIOTab;
import com.ur.polyscope.oldio.internal.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.ViewContext;
import com.ur.swing.baseview.BaseAccordionView;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.logging.Log;
import com.ur.view.Settings;
import com.ur.view.modbus.ModbusIOTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;

@Singleton
@ExtensionPoint(value="IOMenu")
public class IOTab
extends CardPanel
implements Menu {
    public static final String ROBOT_TAB_NAME = "robotTab.ioTab";
    public static final String MODBUS_TAB_NAME = "modbusTab.ioTab";
    private final FlippablePanel flippablePanel;
    private AbstractButton internalSection;
    private AbstractButton externalSection;
    private BaseAccordionView navigation;
    private Builder builder;
    private Map<Action, AbstractButton> shownActions = new HashMap<Action, AbstractButton>();

    @Inject
    public IOTab(Builder builder, IOActionFactory actionFactory, ViewContext view) {
        this.builder = builder;
        this.flippablePanel = new FlippablePanel();
        this.flippablePanel.setCardParent((CardPanel)this);
        actionFactory.setFlipManager((FlipManager)this.flippablePanel);
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, G5LookAndFeel.BETWEEN_CARD_COLOR));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.navigation = (BaseAccordionView)builder.get(BaseAccordionView.class);
        this.navigation.setLanguage(Settings.getLanguage());
        this.internalSection = this.navigation.addSection(actionFactory.createShowRobotIOAction(), new Action[]{actionFactory.createShowRobotIOAction()});
        this.externalSection = this.navigation.addSection(actionFactory.createShowModbusAction(), new Action[]{actionFactory.createShowModbusAction()});
        this.internalSection.getAction().putValue("Name", ((TextResource)view.getTextResource(TextResource.class)).internal());
        this.externalSection.getAction().putValue("Name", ((TextResource)view.getTextResource(TextResource.class)).external());
        this.add((Component)this.navigation, "West");
        this.add((Component)this.flippablePanel, "Center");
        CardPanel robotCardPanel = (CardPanel)builder.get(RobotIOTab.class);
        this.flippablePanel.addCardPanel(this.setName(robotCardPanel, ROBOT_TAB_NAME));
        ModbusIOTab modbusIOTab = (ModbusIOTab)builder.get(ModbusIOTab.class);
        modbusIOTab.initComponents();
        this.flippablePanel.addCardPanel(this.setName((CardPanel)modbusIOTab, MODBUS_TAB_NAME));
        this.flippablePanel.getSwitchSupport().setCurrentCard((CardPanel)this.flippablePanel.getComponent(0));
        this.setName(ROBOT_TAB_NAME);
    }

    private CardPanel setName(CardPanel component, String name) {
        component.setName(name);
        return component;
    }

    public void enter(Object o) {
        super.enter(o);
        this.flippablePanel.enterActiveChild(o);
    }

    public Object exit() {
        this.flippablePanel.exitActiveChild();
        return super.exit();
    }

    public void addMenuItem(MenuExtension.MenuContribution menuContribution) {
        if (!(menuContribution.contribution instanceof ShowScreenActionImpl)) {
            Log.error((String)"IOTab MenuContributions must implement ShowScreenActionImpl");
            return;
        }
        final ShowScreenActionImpl showScreenAction = (ShowScreenActionImpl)menuContribution.contribution;
        final AbstractButton buttonSection = "external".equalsIgnoreCase(menuContribution.getCategory()) ? this.externalSection : this.internalSection;
        this.flippablePanel.addCardPanel((CardPanel)this.builder.get(showScreenAction.getDestinationPanelType()));
        showScreenAction.setFlipManager((FlipManager)this.flippablePanel);
        if (showScreenAction.isEnabled()) {
            AbstractButton button = this.navigation.addElementToSection(buttonSection, (Action)showScreenAction);
            this.shownActions.put((Action)showScreenAction, button);
        }
        menuContribution.contribution.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("enabled")) {
                    boolean val = (Boolean)evt.getNewValue();
                    if (val) {
                        AbstractButton button = IOTab.this.navigation.addElementToSection(buttonSection, (Action)showScreenAction);
                        IOTab.this.shownActions.put(showScreenAction, button);
                    } else {
                        IOTab.this.navigation.removeElementFromSection(buttonSection, (AbstractButton)IOTab.this.shownActions.get(showScreenAction));
                        IOTab.this.shownActions.remove(showScreenAction);
                        IOTab.this.internalSection.doClick();
                    }
                }
            }
        });
    }
}

