/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotState;
import com.ur.monitor.Source;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.io.AnalogDomain;
import com.ur.polyscope.io.tool.ToolIOStateView;
import com.ur.polyscope.io.tool.ToolIOStateViewModel;
import com.ur.polyscope.io.tool.ToolPresenter;
import com.ur.polyscope.oldio.DigitalNamedIO;
import com.ur.polyscope.oldio.internal.TextResource;
import com.ur.polyscope.pin.AbstractPin;
import com.ur.polyscope.pin.ConfigurableIOPin;
import com.ur.polyscope.pin.ModifiablePin;
import com.ur.polyscope.pin.StandardIOPin;
import com.ur.polyscope.pin.ToolIOPin;
import com.ur.polyscope.pin.iotab.ControllerSocketSender;
import com.ur.polyscope.pin.iotab.DisablePinStrategy;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.CardPanel;
import com.ur.swing.GuiUtilities;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.Subscription;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.RobotMode;
import gui.commandpanels.ScriptCard;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

@Singleton
public class RobotIOTab
extends CardPanel
implements ToolIOStateView {
    public static final Object SHOW_ROBOT_IO_TAB = "showRobotIOTab.RobotIOTab";
    public static final String CONFIGURABLE_INPUTS = "configurableInputs." + RobotIOTab.class.getSimpleName();
    public static final String CONFIGURABLE_OUTPUTS = "configurableOutputs." + RobotIOTab.class.getSimpleName();
    public static final String TOOL_OUTPUT_NAME = "tool_output";
    public static final String DIGITAL_OUTPUT_NAME = "dig_output";
    public static final String CONFIGURABLE_OUTPUT_NAME = "conf_output";
    public static final String TOOL_INPUT_NAME = "tool_input";
    public static final String DIGITAL_INPUT_NAME = "dig_input";
    public static final String CONFIGURABLE_INPUT_NAME = "conf_input";
    public static final String IO_PANEL_SUFFIX = "panel";
    public static final String ANALOG_OUTPUT = "analog_output";
    static final int _0_TO_10_VOLT = 1;
    static final int _4_TO_20_mA = 0;
    private static final String TOOL_INPUT_IO_CARD = "IO";
    private static final String TOOL_INPUT_COMM_CARD = "COMM";
    private static final Color GREEN_PANEL_COLOR = new Color(204, 225, 215);
    private static final Color YELLOW_PANEL_COLOR = new Color(254, 254, 111);
    private static final Color GRAY_PANEL_COLOR = new Color(242, 242, 242);
    private static final int OPERATOR_DISABLED = 1;
    private static final int DISABLED = 2;
    private static final int DEFAULT_MAXIMUM_CURRENT = 600;
    final JComboBox[] analogInCombo = new JComboBox[2];
    private final DecimalFormat kf = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#000");
    private final Map<Pin, Long> buttonWaitTimer = new HashMap<Pin, Long>();
    private final long[] setAnalogOutTime = new long[2];
    private final long[] setAnalogOutputDomainTime = new long[2];
    private final DigitalNamedIO[] configurableInputs = new DigitalNamedIO[8];
    private final DigitalNamedIO[] standardInputs = new DigitalNamedIO[8];
    private final DigitalNamedIO[] toolInputs = new DigitalNamedIO[2];
    private final DigitalNamedIO[] configurableOutputs = new DigitalNamedIO[8];
    private final DigitalNamedIO[] standardOutputs = new DigitalNamedIO[8];
    private final DigitalNamedIO[] toolOutputs = new DigitalNamedIO[2];
    private final IOService ioNameService;
    private final URFontFactory fontFactory;
    private final ViewContext viewContext;
    private final ProgramModeHolder programModeService;
    private final TextResource textResource;
    private final TextResource oldioTextResource;
    private final HelpIdAssigner helpIdAssigner;
    final JProgressBar[] analogProgress = new JProgressBar[4];
    JLabel analogHighRangeLabel0;
    JLabel analogLowRangeLabel0;
    JLabel toolHighRangeLabel0;
    JLabel toolLowRangeLabel0;
    JLabel toolHighRangeLabel1;
    JLabel toolLowRangeLabel1;
    JProgressBar currentProgressBar;
    private boolean robotStateUpdate = false;
    private DisablePinStrategy disablePinStrategy;
    private ToolPresenter toolPresenter;
    private String[] analogComboChoices;
    private JLabel[] toolAnalogInputDomain;
    private JLabel analogHighRangeLabel1;
    private JLabel[] analogInputLabel = new JLabel[4];
    final JLabel[] analogInputOutOfRange = new JLabel[4];
    private JLabel currentLabel;
    private JLabel analogLowRangeLabel1;
    private JComboBox[] analogOutCombo = new JComboBox[2];
    private JLabel[] analogOutputValue = new JLabel[2];
    private JSlider[] analogOutSlider = new JSlider[2];
    private JLabel[] analogOutputLabel = new JLabel[2];
    private JPanel analogOutput1Panel;
    private JPanel analogOutput2Panel;
    private JPanel analogOutputPanel;
    private JPanel analogInputPanel;
    private JPanel configurableInputPanel;
    private JPanel configurableOutputPanel;
    private JPanel standardInputPanel;
    private JPanel standardOutputPanel;
    private JPanel toolOutputPanel;
    private JPanel toolDigitalInputPanel;
    private JPanel toolAnalogInputPanel;
    private JLabel baudRateValueLabel;
    private JLabel parityValueLabel;
    private JLabel stopBitValueLabel;
    private JLabel rxIdleCharsValueLabel;
    private JLabel txIdleCharsValueLabel;
    private Recipe<RobotState> robotStateRecipe;
    private Subscription robotStateSubscription = Subscription.NULL;
    private final Consumer<RobotState> robotStateConsumer = new RobotStateConsumer();

    @Inject
    RobotIOTab(DisablePinStrategy disablePinStrategy, IOService ioNameService, ViewContext viewContext, ProgramModeHolder programModeService, ToolPresenter toolPresenter, @Source(value=RobotState.class) Recipe<RobotState> robotStateRecipe) {
        this.disablePinStrategy = disablePinStrategy;
        this.ioNameService = ioNameService;
        this.fontFactory = viewContext.getFontFactory();
        this.viewContext = viewContext;
        this.robotStateRecipe = robotStateRecipe;
        this.programModeService = programModeService;
        this.toolPresenter = toolPresenter;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.oldioTextResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.analogComboChoices = new String[]{this.textResource.current(), this.textResource.voltage()};
        this.initComponents();
        this.initIOs();
        this.initHelpIds();
        toolPresenter.setView((ToolIOStateView)this);
    }

    public void updateView(ToolIOStateViewModel viewModel) {
        CardLayout cardLayout = (CardLayout)this.toolAnalogInputPanel.getLayout();
        cardLayout.show(this.toolAnalogInputPanel, viewModel.analogCommEnabled ? TOOL_INPUT_COMM_CARD : TOOL_INPUT_IO_CARD);
        this.baudRateValueLabel.setText(viewModel.analogCommModel.baudRate);
        this.parityValueLabel.setText(viewModel.analogCommModel.parity);
        this.stopBitValueLabel.setText(viewModel.analogCommModel.stopBits);
        this.rxIdleCharsValueLabel.setText(viewModel.analogCommModel.rxIdleChars);
        this.txIdleCharsValueLabel.setText(viewModel.analogCommModel.txIdleChars);
        this.toolOutputs[0].setEnabled(viewModel.digitalOutputModel.pin0Enabled);
        this.toolOutputs[1].setEnabled(viewModel.digitalOutputModel.pin1Enabled);
        this.toolAnalogInputDomain[0].setText(this.domainAsString(viewModel.analogInputModel.domainPin0));
        this.toolAnalogInputDomain[1].setText(this.domainAsString(viewModel.analogInputModel.domainPin1));
        this.initLowAndHighRanges(viewModel.analogInputModel.domainPin0, this.toolLowRangeLabel0, this.toolHighRangeLabel0);
        this.initLowAndHighRanges(viewModel.analogInputModel.domainPin1, this.toolLowRangeLabel1, this.toolHighRangeLabel1);
        if (this.currentProgressBar.getMaximum() != viewModel.digitalOutputModel.maximumCurrent) {
            this.currentProgressBar.setMaximum(viewModel.digitalOutputModel.maximumCurrent);
            Log.info((String)("Changing maximum current: " + viewModel.digitalOutputModel.maximumCurrent));
        }
    }

    private String domainAsString(AnalogDomain analogDomainValue) {
        return ((TextResource)this.viewContext.getTextResource(TextResource.class)).domain((Enum<AnalogDomain>)analogDomainValue);
    }

    private void initIOs() {
        this.initializeDisplayedPins(this.configurableInputs, this.ioNameService.getConfigurableDigitalInputPins(), CONFIGURABLE_INPUT_NAME);
        this.initializeDisplayedPins(this.configurableOutputs, this.ioNameService.getConfigurableDigitalOutputPins(), CONFIGURABLE_OUTPUT_NAME);
        this.updateEnablementOfConfigurableOutputs();
        this.initializeDisplayedPins(this.standardInputs, this.ioNameService.getStandardDigitalInputPins(), DIGITAL_INPUT_NAME);
        this.initializeDisplayedPins(this.standardOutputs, this.ioNameService.getStandardDigitalOutputPins(), DIGITAL_OUTPUT_NAME);
        this.updateEnablementOfConfigurableOutputs();
        this.initializeDisplayedPins(this.toolInputs, this.ioNameService.getToolDigitalInputPins(), TOOL_INPUT_NAME);
        this.initializeDisplayedPins(this.toolOutputs, this.ioNameService.getToolDigitalOutputPins(), TOOL_OUTPUT_NAME);
    }

    private void updateEnablementOfConfigurableOutputs() {
        for (int i = 0; i < this.configurableOutputs.length; ++i) {
            boolean used = !this.configurableOutputs[i].getPin().isUnassigned();
            this.configurableOutputs[i].setEnabled(!used && this.isIoWritableInProgramModeReadOnly(i, 12));
        }
    }

    private void updateEnablementOfStandardOutputs() {
        for (DigitalNamedIO each : this.standardOutputs) {
            each.setEnabled(this.disablePinStrategy.isEnabled((ModifiablePin)each.getPin()));
            each.updateView();
        }
    }

    private boolean isIoWritableInProgramModeReadOnly(int ioIndex, int offset) {
        int options = AbstractPin.getOutputSignalOption((int)(ioIndex + offset));
        if (this.programModeService.getMode() == ProgramModeHolder.ProgramMode.ReadOnly && options == 1) {
            return false;
        }
        return options != 2;
    }

    private void initializeDisplayedPins(DigitalNamedIO[] digitalNamedPins, Pin[] ioPins, String name) {
        for (int i = 0; i < digitalNamedPins.length; ++i) {
            digitalNamedPins[i].initialize(ioPins[i]);
            digitalNamedPins[i].addActionListener(new ActionListenerImplementation(digitalNamedPins[i], ioPins[i]));
            digitalNamedPins[i].setName(name + "_" + IO_PANEL_SUFFIX + "_" + i);
            digitalNamedPins[i].setNameForLabel(name + "_" + i);
        }
    }

    private void initHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)this.standardInputPanel, "gui:io_digital_inputs");
        this.helpIdAssigner.assignHelpId((JComponent)this.standardOutputPanel, "gui:io_digital_outputs");
        this.helpIdAssigner.assignHelpId((JComponent)this.configurableInputPanel, "gui:io_digital_inputs");
        this.helpIdAssigner.assignHelpId((JComponent)this.configurableOutputPanel, "gui:io_digital_outputs");
        this.helpIdAssigner.assignHelpId((JComponent)this.toolOutputPanel, "gui:io_tool_digital_output");
        this.helpIdAssigner.assignHelpId((JComponent)this.toolDigitalInputPanel, "gui:io_tool_digital_inputs");
        this.helpIdAssigner.assignHelpId((JComponent)this.analogInputPanel, "gui:io_analog_input");
        this.helpIdAssigner.assignHelpId((JComponent)this.analogOutputPanel, "gui:io_analog_output");
        this.helpIdAssigner.assignHelpId((JComponent)this.analogInCombo[0], "gui:iotab_analog_domain_settings");
        this.helpIdAssigner.assignHelpId((JComponent)this.analogInCombo[1], "gui:iotab_analog_domain_settings");
        this.helpIdAssigner.assignHelpId((JComponent)this.analogOutCombo[0], "gui:iotab_analog_domain_settings");
        this.helpIdAssigner.assignHelpId((JComponent)this.analogOutCombo[1], "gui:iotab_analog_domain_settings");
    }

    public String toString() {
        return "I/O";
    }

    public void enter(Object o) {
        int i;
        super.enter(o);
        this.initIOs();
        for (DigitalNamedIO each : this.configurableOutputs) {
            ModifiablePin pin = (ModifiablePin)each.getPin();
            each.setEnabled(this.disablePinStrategy.isEnabled(pin));
            each.updateView();
        }
        boolean analog0CanBeModified = AbstractPin.getOutputSignalOption((int)10) < 1 || AbstractPin.getOutputSignalOption((int)10) < 2 && this.programModeService.getMode() == ProgramModeHolder.ProgramMode.Editable;
        GuiUtilities.setContainerEnabledRecursive((Container)this.analogOutput1Panel, (boolean)analog0CanBeModified);
        boolean analog1CanBeModified = AbstractPin.getOutputSignalOption((int)11) < 1 || AbstractPin.getOutputSignalOption((int)11) < 2 && this.programModeService.getMode() == ProgramModeHolder.ProgramMode.Editable;
        GuiUtilities.setContainerEnabledRecursive((Container)this.analogOutput2Panel, (boolean)analog1CanBeModified);
        for (i = 0; i < this.analogInputLabel.length; ++i) {
            this.analogInputLabel[i].setText(this.ioNameService.getAllAnalogInputPins()[i].getDisplayName());
        }
        for (i = 0; i < this.analogOutputLabel.length; ++i) {
            this.analogOutputLabel[i].setText(this.ioNameService.getStandardAnalogOutputPins()[i].getDisplayName());
        }
        this.robotStateSubscription.dispose();
        this.robotStateSubscription = this.robotStateRecipe.executeOnUIThread().subscribe(this.robotStateConsumer);
        EventNotificationService.register((Object)((Object)this), InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                RobotIOTab.this.initIOs();
            }
        });
        this.toolPresenter.startBackgroundMonitor();
    }

    public Object exit() {
        this.robotStateSubscription.dispose();
        this.robotStateSubscription = Subscription.NULL;
        EventNotificationService.unregister((Object)((Object)this), InstallationStateListener.class);
        this.toolPresenter.stopBackgroundMonitor();
        return super.exit();
    }

    private void updateAnalogValueOutput(long t, double value, byte analogOutputRange, Pin pin, JSlider analogOutSlider, JLabel analogOutputLabel) {
        if (this.updateOnClick(pin, t)) {
            AnalogDomain domain = AnalogDomain.byId((int)analogOutputRange);
            analogOutputLabel.setText(domain.toString(value));
            analogOutSlider.setValue((int)(domain.toValue(value) * (double)analogOutSlider.getMaximum()));
        }
    }

    private void updateAnalogDomainSelection(long t, byte analogInputRange, Pin pin, JComboBox analogInCombo) {
        if (this.updateOnClick(pin, t) && analogInCombo.getSelectedIndex() != analogInputRange && analogInputRange >= -1 && analogInputRange < analogInCombo.getModel().getSize()) {
            analogInCombo.setSelectedIndex(analogInputRange);
        }
    }

    private boolean isAnalogInputWithinLimits(AnalogDomain analogDomain, double inputValue) {
        if (analogDomain == AnalogDomain.CURRENT) {
            return inputValue >= 0.004 && inputValue <= 0.02;
        }
        if (analogDomain == AnalogDomain.VOLTAGE) {
            return inputValue >= 0.0 && inputValue <= 10.0;
        }
        return false;
    }

    private void updateAnalogValueInput(byte inputRange, double inputValue, JProgressBar analogProgress, JLabel outOfRangeLabel) {
        AnalogDomain domain = AnalogDomain.byId((int)inputRange);
        String inputText = domain.toString(inputValue);
        if (domain == AnalogDomain.CURRENT) {
            if (inputValue < 0.004) {
                inputText = "< 4.00 mA";
            } else if (inputValue > 0.02) {
                inputText = "> 20.00 mA";
            }
        } else if (domain == AnalogDomain.VOLTAGE && inputValue > 10.0) {
            inputText = "> 10.00 V";
        }
        analogProgress.setString(inputText);
        analogProgress.setValue((int)(domain.toValue(inputValue) * (double)analogProgress.getMaximum()));
        outOfRangeLabel.setVisible(!this.isAnalogInputWithinLimits(domain, inputValue));
    }

    private void updateSelection(DigitalNamedIO[] ios, byte[] values) {
        for (DigitalNamedIO io : ios) {
            io.setSelected(values[io.getPin().getPin()] > 0);
        }
    }

    private void updateEnablement(DigitalNamedIO[] ios, boolean enabled) {
        for (DigitalNamedIO each : ios) {
            each.setEnabled(enabled);
        }
    }

    private void updateDigitalOut(DigitalNamedIO[] ios, byte[] values, long t) {
        for (int i = 0; i < ios.length; ++i) {
            if (!this.updateOnClick(ios[i].getPin(), t)) continue;
            ios[i].setSelected(values[i] == 1);
        }
    }

    private boolean updateOnClick(Pin pin, long t) {
        Long lastClick = this.buttonWaitTimer.get(pin);
        if (lastClick != null) {
            return t - lastClick > 150L;
        }
        return true;
    }

    public void analogSliderActionPerformed(JSlider jSlider, MouseEvent evt) {
        int w = jSlider.getWidth();
        int x = evt.getX();
        int min = jSlider.getMinimum();
        int max = jSlider.getMaximum();
        double val = (double)(x - 8) / (double)(w - 16);
        if (val < 0.0) {
            val = 0.0;
        } else if (val > 1.0) {
            val = 1.0;
        }
        int intVal = (int)(val * (double)jSlider.getMaximum());
        if (intVal < min) {
            intVal = min;
        }
        if (intVal > max) {
            intVal = max;
        }
        jSlider.setValue(intVal);
    }

    public DefaultComboBoxModel createCurrentVoltageComboBoxModel() {
        DefaultComboBoxModel<String> cvcbm = new DefaultComboBoxModel<String>();
        cvcbm.addElement(this.textResource.current());
        cvcbm.addElement(this.textResource.voltage());
        return cvcbm;
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        this.toolOutputs[0] = this.createDigitalNamedIO();
        this.toolOutputs[1] = this.createDigitalNamedIO();
        this.currentProgressBar = new JProgressBar();
        this.currentLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.initConfigurableInputPanel();
        this.initConfigurableOutputPanel();
        this.initStandardInputPanel();
        this.initStandardOutputPanel();
        this.createCardTop(this.textResource.configurableInput(), this.configurableInputPanel);
        this.createCardTop(this.textResource.configurableOutput(), this.configurableOutputPanel);
        this.createCardTop(this.textResource.digitalInput(), this.standardInputPanel);
        this.createCardRightSideTop(this.textResource.digitalOutput(), this.standardOutputPanel);
        this.initAnalogInputPanel();
        this.initToolInputPanels();
        this.initToolOutputPanel();
        this.createCard(this.textResource.analogInput(), this.analogInputPanel);
        this.createCard(this.textResource.toolDigitalInput(), this.toolDigitalInputPanel);
        this.createCardRightSide(this.textResource.toolDigitalOutput(), this.toolOutputPanel);
        this.initAnalogOutputPanel();
        this.createCard(this.textResource.analogOutput(), this.analogOutputPanel);
        this.createCardRightSide(this.textResource.toolAnalogInput(), this.toolAnalogInputPanel);
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.add((Component)this.configurableInputPanel, new GridBagConstraints(){
            {
                this.gridx = 0;
                this.gridy = 0;
                this.weightx = 1.0;
                this.weighty = 1.0;
                this.fill = 1;
            }
        });
        mainPanel.add((Component)this.configurableOutputPanel, new GridBagConstraints(){
            {
                this.gridx = 1;
                this.gridy = 0;
                this.weightx = 1.0;
                this.weighty = 1.0;
                this.fill = 1;
            }
        });
        mainPanel.add((Component)this.standardInputPanel, new GridBagConstraints(){
            {
                this.gridx = 2;
                this.gridy = 0;
                this.weightx = 1.0;
                this.weighty = 1.0;
                this.fill = 1;
            }
        });
        mainPanel.add((Component)this.standardOutputPanel, new GridBagConstraints(){
            {
                this.gridx = 3;
                this.gridy = 0;
                this.weightx = 1.0;
                this.weighty = 1.0;
                this.fill = 1;
            }
        });
        mainPanel.add((Component)this.analogInputPanel, new GridBagConstraints(){
            {
                this.gridx = 0;
                this.gridy = 1;
                this.gridwidth = 2;
                this.weighty = 1.0;
                this.weightx = 2.0;
                this.fill = 1;
            }
        });
        mainPanel.add((Component)this.toolDigitalInputPanel, new GridBagConstraints(){
            {
                this.gridx = 2;
                this.gridy = 1;
                this.gridwidth = 1;
                this.weightx = 1.0;
                this.weighty = 1.0;
                this.fill = 1;
            }
        });
        mainPanel.add((Component)this.toolOutputPanel, new GridBagConstraints(){
            {
                this.gridx = 3;
                this.gridy = 1;
                this.gridwidth = 1;
                this.weighty = 1.0;
                this.weightx = 1.0;
                this.fill = 1;
            }
        });
        mainPanel.add((Component)this.analogOutputPanel, new GridBagConstraints(){
            {
                this.gridx = 0;
                this.gridy = 2;
                this.gridwidth = 2;
                this.weighty = 2.0;
                this.weightx = 2.0;
                this.fill = 1;
            }
        });
        mainPanel.add((Component)this.toolAnalogInputPanel, new GridBagConstraints(){
            {
                this.gridx = 2;
                this.gridy = 2;
                this.gridwidth = 2;
                this.weighty = 2.0;
                this.weightx = 2.0;
                this.fill = 1;
            }
        });
        mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        mainPanel.setBackground(UIManager.getColor("CardPanel.background"));
        this.setBackground(UIManager.getColor("CardPanel.background"));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add(mainPanel, "Center");
        this.setBackground(UIManager.getColor("CardPanel.background"));
    }

    private void initConfigurableInputPanel() {
        this.configurableInputPanel = new JPanel();
        this.initDigitalPinPanel(this.configurableInputPanel, this.configurableInputs, YELLOW_PANEL_COLOR, CONFIGURABLE_INPUTS);
    }

    private void initConfigurableOutputPanel() {
        this.configurableOutputPanel = new JPanel();
        this.initDigitalPinPanel(this.configurableOutputPanel, this.configurableOutputs, YELLOW_PANEL_COLOR, CONFIGURABLE_OUTPUTS);
    }

    private void initStandardInputPanel() {
        this.standardInputPanel = new JPanel();
        this.initDigitalPinPanel(this.standardInputPanel, this.standardInputs, GRAY_PANEL_COLOR, this.textResource.digitalInput());
    }

    private void initStandardOutputPanel() {
        this.standardOutputPanel = new JPanel();
        this.initDigitalPinPanel(this.standardOutputPanel, this.standardOutputs, GRAY_PANEL_COLOR, this.textResource.digitalOutput());
    }

    private void initDigitalPinPanel(JPanel panel, DigitalNamedIO[] pinPanelArray, Color background, String title) {
        int i;
        for (int i2 = 0; i2 < 8; ++i2) {
            pinPanelArray[i2] = this.createDigitalNamedIO();
        }
        panel.setBackground(background);
        panel.setName(title);
        panel.setLayout(new GridBagLayout());
        for (i = 0; i < 4; ++i) {
            pinPanelArray[i].setBulletAtTheEnd(true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i + 1;
            gridBagConstraints.ipadx = 5;
            gridBagConstraints.ipady = 1;
            gridBagConstraints.anchor = 22;
            panel.add((Component)pinPanelArray[i], gridBagConstraints);
        }
        for (i = 4; i < 8; ++i) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = i - 3;
            gridBagConstraints.ipady = 1;
            gridBagConstraints.anchor = 21;
            panel.add((Component)pinPanelArray[i], gridBagConstraints);
        }
    }

    private void initAnalogInputPanel() {
        int i;
        this.analogInputPanel = new JPanel();
        this.analogLowRangeLabel0 = new JLabel();
        this.analogHighRangeLabel0 = new JLabel();
        this.analogLowRangeLabel1 = new JLabel();
        this.analogHighRangeLabel1 = new JLabel();
        for (i = 0; i < 2; ++i) {
            this.analogProgress[i] = new JProgressBar();
            this.analogInCombo[i] = new JComboBox();
            this.analogInputLabel[i] = new JLabel();
        }
        for (i = 0; i < 4; ++i) {
            this.analogInputOutOfRange[i] = new JLabel();
            this.analogInputOutOfRange[i].setText(this.oldioTextResource.analogInputOutOfRange());
            this.analogInputOutOfRange[i].setHorizontalAlignment(0);
            this.analogInputOutOfRange[i].setVisible(false);
        }
        this.analogInputPanel.setLayout(new GridBagLayout());
        this.analogInputPanel.setBackground(GREEN_PANEL_COLOR);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 0, 20);
        gridBagConstraints.anchor = 17;
        this.analogInputPanel.add((Component)this.analogInputLabel[0], gridBagConstraints);
        this.setProgressBarLayout(this.analogProgress[0]);
        this.analogProgress[0].setStringPainted(true);
        this.analogProgress[0].setBackground(GREEN_PANEL_COLOR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.analogInputPanel.add((Component)this.analogProgress[0], gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.analogInputPanel.add((Component)this.analogLowRangeLabel0, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 13;
        this.analogInputPanel.add((Component)this.analogHighRangeLabel0, gridBagConstraints);
        this.initLowAndHighRanges(AnalogDomain.CURRENT, this.analogLowRangeLabel0, this.analogHighRangeLabel0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.analogInputPanel.add((Component)this.analogInputOutOfRange[0], gridBagConstraints);
        this.analogInCombo[0].setModel(this.createCurrentVoltageComboBoxModel());
        this.analogInCombo[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotIOTab.this.analogInCombo0ActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(15, 10, 0, 10);
        this.analogInputPanel.add((Component)this.analogInCombo[0], gridBagConstraints);
        this.analogInputLabel[1].setText(this.textResource.analog());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        this.analogInputPanel.add((Component)this.analogInputLabel[1], gridBagConstraints);
        this.setProgressBarLayout(this.analogProgress[1]);
        this.analogProgress[1].setStringPainted(true);
        this.analogProgress[1].setBackground(GREEN_PANEL_COLOR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.analogInputPanel.add((Component)this.analogProgress[1], gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 17;
        this.analogInputPanel.add((Component)this.analogLowRangeLabel1, gridBagConstraints);
        this.analogHighRangeLabel1.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.analogInputPanel.add((Component)this.analogHighRangeLabel1, gridBagConstraints);
        this.initLowAndHighRanges(AnalogDomain.CURRENT, this.analogLowRangeLabel1, this.analogHighRangeLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.analogInputPanel.add((Component)this.analogInputOutOfRange[1], gridBagConstraints);
        this.analogInCombo[1].setModel(this.createCurrentVoltageComboBoxModel());
        this.analogInCombo[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotIOTab.this.analogInCombo1ActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.anchor = 17;
        this.analogInputPanel.add((Component)this.analogInCombo[1], gridBagConstraints);
        ScriptCard.setComboBoxWidth((JComboBox)this.analogInCombo[0], (String[])this.analogComboChoices);
        ScriptCard.setComboBoxWidth((JComboBox)this.analogInCombo[1], (String[])this.analogComboChoices);
    }

    private void initToolOutputPanel() {
        TextResource text = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.toolOutputPanel = new JPanel();
        this.toolOutputPanel.setLayout(new BorderLayout());
        JPanel toolDigitalOutputTopPanel = new JPanel();
        JPanel toolDigitalOutputBottomPanel = new JPanel();
        toolDigitalOutputTopPanel.setLayout(new GridLayout(1, 2, 8, 8));
        this.toolOutputs[0].setBulletAtTheEnd(true);
        toolDigitalOutputTopPanel.add(this.toolOutputs[0]);
        toolDigitalOutputTopPanel.add(this.toolOutputs[1]);
        toolDigitalOutputBottomPanel.setLayout(new GridBagLayout());
        this.currentLabel.setText(text.current());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        toolDigitalOutputBottomPanel.add((Component)this.currentLabel, gridBagConstraints);
        this.currentProgressBar.setMaximum(600);
        this.setProgressBarLayout(this.currentProgressBar);
        this.currentProgressBar.setString("0 mA");
        this.currentProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 40, 10);
        toolDigitalOutputBottomPanel.add((Component)this.currentProgressBar, gridBagConstraints);
        toolDigitalOutputTopPanel.setBorder(new EmptyBorder(20, 0, 0, 0));
        this.toolOutputPanel.add((Component)toolDigitalOutputTopPanel, "First");
        this.toolOutputPanel.add((Component)toolDigitalOutputBottomPanel, "Last");
    }

    private void initToolInputPanels() {
        this.analogProgress[2] = new JProgressBar();
        this.analogProgress[3] = new JProgressBar();
        this.toolAnalogInputDomain = new JLabel[2];
        this.toolAnalogInputDomain[0] = new JLabel();
        this.toolAnalogInputDomain[1] = new JLabel();
        this.toolHighRangeLabel0 = new JLabel();
        this.toolLowRangeLabel0 = new JLabel();
        this.toolHighRangeLabel1 = new JLabel();
        this.toolLowRangeLabel1 = new JLabel();
        this.toolInputs[0] = this.createDigitalNamedIO();
        this.toolInputs[0].setBulletAtTheEnd(true);
        this.toolInputs[1] = this.createDigitalNamedIO();
        this.toolInputs[0].setBorder(new EmptyBorder(20, 0, 0, 0));
        this.toolInputs[1].setBorder(new EmptyBorder(20, 0, 0, 0));
        this.analogInputLabel[2] = new JLabel();
        this.analogInputLabel[3] = new JLabel();
        this.toolDigitalInputPanel = new JPanel(new GridLayout(1, 2, 8, 8));
        this.toolDigitalInputPanel.add(this.toolInputs[0]);
        this.toolDigitalInputPanel.add(this.toolInputs[1]);
        this.toolAnalogInputPanel = new JPanel(new CardLayout());
        JLabel baudRateLabel = new JLabel(this.textResource.baudRate());
        this.smallerFont(baudRateLabel);
        JLabel parityLabel = new JLabel(this.textResource.parity());
        this.smallerFont(parityLabel);
        JLabel stopBitsLabel = new JLabel(this.textResource.stopBits());
        this.smallerFont(stopBitsLabel);
        JLabel rxIdleCharsLabel = new JLabel(this.textResource.rxIdleChars());
        this.smallerFont(rxIdleCharsLabel);
        JLabel txIdleChars = new JLabel(this.textResource.txIdleChars());
        this.smallerFont(txIdleChars);
        this.baudRateValueLabel = new JLabel();
        this.largerBoldFont(this.baudRateValueLabel);
        this.parityValueLabel = new JLabel();
        this.largerBoldFont(this.parityValueLabel);
        this.stopBitValueLabel = new JLabel();
        this.largerBoldFont(this.stopBitValueLabel);
        this.rxIdleCharsValueLabel = new JLabel();
        this.largerBoldFont(this.rxIdleCharsValueLabel);
        this.txIdleCharsValueLabel = new JLabel();
        this.largerBoldFont(this.txIdleCharsValueLabel);
        JLabel descriptionLabel = this.viewContext.createWidgetFactory().createLabel(this.textResource.toolCommIOInfo());
        descriptionLabel.setFont(this.viewContext.getFontFactory().getRelativeFont(URFontFactory.Size.VERY_SMALL));
        JPanel toolInputCommPanel = new JPanel(new GridLayout(5, 2));
        toolInputCommPanel.add(baudRateLabel);
        toolInputCommPanel.add(this.baudRateValueLabel);
        toolInputCommPanel.add(parityLabel);
        toolInputCommPanel.add(this.parityValueLabel);
        toolInputCommPanel.add(stopBitsLabel);
        toolInputCommPanel.add(this.stopBitValueLabel);
        toolInputCommPanel.add(rxIdleCharsLabel);
        toolInputCommPanel.add(this.rxIdleCharsValueLabel);
        toolInputCommPanel.add(txIdleChars);
        toolInputCommPanel.add(this.txIdleCharsValueLabel);
        JPanel toolInputIOPanel = new JPanel(new GridBagLayout());
        this.analogInputLabel[2].setText(this.textResource.analog());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        toolInputIOPanel.add((Component)this.analogInputLabel[2], gridBagConstraints);
        this.setProgressBarLayout(this.analogProgress[2]);
        this.analogProgress[2].setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        toolInputIOPanel.add((Component)this.analogProgress[2], gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        toolInputIOPanel.add((Component)this.toolAnalogInputDomain[0], gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        toolInputIOPanel.add((Component)this.toolLowRangeLabel0, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 13;
        toolInputIOPanel.add((Component)this.toolHighRangeLabel0, gridBagConstraints);
        this.initLowAndHighRanges(AnalogDomain.CURRENT, this.toolLowRangeLabel0, this.toolHighRangeLabel0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        toolInputIOPanel.add((Component)this.analogInputOutOfRange[2], gridBagConstraints);
        this.analogInputLabel[3].setText(this.textResource.analog());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 10, 10, 5);
        toolInputIOPanel.add((Component)this.analogInputLabel[3], gridBagConstraints);
        this.setProgressBarLayout(this.analogProgress[3]);
        this.analogProgress[3].setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 0, 10, 5);
        toolInputIOPanel.add((Component)this.analogProgress[3], gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(20, 0, 10, 10);
        toolInputIOPanel.add((Component)this.toolAnalogInputDomain[1], gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        toolInputIOPanel.add((Component)this.toolLowRangeLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 13;
        toolInputIOPanel.add((Component)this.toolHighRangeLabel1, gridBagConstraints);
        this.initLowAndHighRanges(AnalogDomain.CURRENT, this.toolLowRangeLabel1, this.toolHighRangeLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        toolInputIOPanel.add((Component)this.analogInputOutOfRange[3], gridBagConstraints);
        this.toolAnalogInputPanel.add((Component)toolInputIOPanel, TOOL_INPUT_IO_CARD);
        this.toolAnalogInputPanel.add((Component)toolInputCommPanel, TOOL_INPUT_COMM_CARD);
    }

    private void largerBoldFont(JComponent component) {
        Font f = component.getFont();
        component.setFont(f.deriveFont(f.getStyle() | 1));
        component.setFont(f.deriveFont((float)f.getSize() + 2.0f));
    }

    private void smallerFont(JComponent component) {
        Font f = component.getFont();
        component.setFont(f.deriveFont((float)f.getSize() - 1.0f));
    }

    private void initAnalogOutputPanel() {
        this.analogOutputPanel = new JPanel();
        this.analogOutput1Panel = new JPanel();
        this.analogOutSlider[0] = new JSlider();
        this.analogOutCombo[0] = new JComboBox();
        this.analogOutputLabel[0] = new JLabel();
        this.analogOutput2Panel = new JPanel();
        this.analogOutSlider[1] = new JSlider();
        this.analogOutCombo[1] = new JComboBox();
        this.analogOutputLabel[1] = new JLabel();
        TextResource text = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.analogOutputPanel.setLayout(new GridBagLayout());
        this.analogOutputPanel.setBackground(GREEN_PANEL_COLOR);
        this.analogOutput1Panel.setLayout(new GridBagLayout());
        this.analogOutput1Panel.setBackground(GREEN_PANEL_COLOR);
        this.analogOutput2Panel.setLayout(new GridBagLayout());
        this.analogOutput2Panel.setBackground(GREEN_PANEL_COLOR);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(13, 10, 0, 10);
        gridBagConstraints.anchor = 17;
        this.analogOutput1Panel.add((Component)this.analogOutputLabel[0], gridBagConstraints);
        this.analogOutSlider[0].setMaximum(1000);
        this.analogOutSlider[0].setName("analog_output_slider_0");
        this.analogOutSlider[0].setBackground(GREEN_PANEL_COLOR);
        this.analogOutSlider[0].addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RobotIOTab.this.analogOutSlider0MousePressed(evt);
            }
        });
        this.analogOutSlider[0].addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                RobotIOTab.this.analogOutSlider0MouseDragged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        gridBagConstraints.fill = 2;
        this.analogOutput1Panel.add((Component)this.analogOutSlider[0], gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        this.analogOutputValue[0] = new JLabel("analog_output_value_0");
        this.analogOutputValue[0].setHorizontalAlignment(0);
        this.analogOutput1Panel.add((Component)this.analogOutputValue[0], gridBagConstraints);
        this.analogOutCombo[0].setModel(this.createCurrentVoltageComboBoxModel());
        this.analogOutCombo[0].setName("analog_output_combo_0");
        this.analogOutCombo[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotIOTab.this.analogOutCombo0ActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(13, 5, 0, 10);
        this.analogOutput1Panel.add((Component)this.analogOutCombo[0], gridBagConstraints);
        this.analogOutputLabel[1].setText(text.analog());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(13, 10, 0, 10);
        gridBagConstraints.anchor = 17;
        this.analogOutput2Panel.add((Component)this.analogOutputLabel[1], gridBagConstraints);
        this.analogOutSlider[1].setMaximum(1000);
        this.analogOutSlider[1].setName("analog_output_slider_1");
        this.analogOutSlider[1].setBackground(GREEN_PANEL_COLOR);
        this.analogOutSlider[1].setPaintTicks(true);
        this.analogOutSlider[1].addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RobotIOTab.this.analogOutSlider1MousePressed(evt);
            }
        });
        this.analogOutSlider[1].addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                RobotIOTab.this.analogOutSlider1MouseDragged(evt);
            }
        });
        this.analogOutSlider[1].setBackground(GREEN_PANEL_COLOR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        gridBagConstraints.fill = 2;
        this.analogOutput2Panel.add((Component)this.analogOutSlider[1], gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        this.analogOutputValue[1] = new JLabel();
        this.analogOutputValue[1].setHorizontalAlignment(0);
        this.analogOutput2Panel.add((Component)this.analogOutputValue[1], gridBagConstraints);
        this.analogOutCombo[1].setModel(this.createCurrentVoltageComboBoxModel());
        this.analogOutCombo[1].setName("analog_output_combo_1");
        this.analogOutCombo[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RobotIOTab.this.analogOutCombo1ActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(13, 5, 0, 10);
        this.analogOutput2Panel.add((Component)this.analogOutCombo[1], gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.analogOutputPanel.add((Component)this.analogOutput1Panel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.analogOutputPanel.add((Component)this.analogOutput2Panel, gridBagConstraints);
        ScriptCard.setComboBoxWidth((JComboBox)this.analogOutCombo[0], (String[])this.analogComboChoices);
        ScriptCard.setComboBoxWidth((JComboBox)this.analogOutCombo[1], (String[])this.analogComboChoices);
    }

    private DigitalNamedIO createDigitalNamedIO() {
        return new DigitalNamedIO(this.fontFactory);
    }

    private void createCard(String title, JPanel mainSettings) {
        mainSettings.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 0, 5, UIManager.getColor("CardPanel.background")), (Border)new CardBorder(title)));
    }

    private void createCardTop(String title, JPanel mainSettings) {
        mainSettings.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 5, UIManager.getColor("CardPanel.background")), (Border)new CardBorder(title)));
    }

    private void createCardRightSide(String title, JPanel mainSettings) {
        mainSettings.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 0, 0, UIManager.getColor("CardPanel.background")), (Border)new CardBorder(title)));
    }

    private void createCardRightSideTop(String title, JPanel mainSettings) {
        mainSettings.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, UIManager.getColor("CardPanel.background")), (Border)new CardBorder(title)));
    }

    private void setProgressBarLayout(JProgressBar bar) {
        bar.setFont(this.fontFactory.getRelativeFont(URFontFactory.Size.TINY));
        bar.setMinimumSize(new Dimension(0, 16));
        bar.setPreferredSize(new Dimension(0, 16));
        bar.setMaximumSize(new Dimension(0, 16));
    }

    private void analogOutComboActionPerformed(int i) {
        IOService ioService = this.ioNameService;
        int idx = this.analogOutCombo[i].getSelectedIndex();
        switch (idx) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                idx = ioService.getAnalogOutputDomain(i);
            }
        }
        if (!this.robotStateUpdate) {
            ioService.setAnalogOutputDomain(i, idx);
            ControllerSocketSender.sendSetAnalogOutputDomain((int)i, (int)idx);
        }
        this.setAnalogOutputDomainTime[i] = System.currentTimeMillis();
    }

    private void analogOutCombo1ActionPerformed() {
        this.analogOutComboActionPerformed(1);
    }

    private void analogOutCombo0ActionPerformed() {
        this.analogOutComboActionPerformed(0);
    }

    private void analogInCombo1ActionPerformed() {
        this.analogInChanged(1, this.analogInCombo[1].getSelectedIndex(), this.analogLowRangeLabel1, this.analogHighRangeLabel1);
    }

    private void analogInChanged(int index, int selectedIndex, JLabel lowRange, JLabel highRange) {
        this.initLowAndHighRanges(AnalogDomain.byId((int)selectedIndex), lowRange, highRange);
        if (!this.robotStateUpdate) {
            this.ioNameService.setAnalogInputRange(index, selectedIndex);
            if (selectedIndex != ((RobotState)this.robotStateRecipe.lastProvider().get()).analogInputRange[index]) {
                Log.info((String)("To Controller: set_standard_analog_input_domain(" + index + ", " + selectedIndex + ")"));
                ControllerSocketSender.sendSetAnalogInputDomain((int)index, (int)selectedIndex);
            }
        }
        Pin pin = this.ioNameService.getAllAnalogInputPins()[index];
        this.buttonWaitTimer.put(pin, System.currentTimeMillis());
    }

    private void initLowAndHighRanges(AnalogDomain domain, JLabel lowRange, JLabel highRange) {
        switch (domain) {
            case CURRENT: {
                lowRange.setText("4mA");
                highRange.setText("20mA");
                break;
            }
            case VOLTAGE: {
                lowRange.setText("0V");
                highRange.setText("10V");
            }
        }
    }

    private void analogSliderMouseEvent(MouseEvent evt, int i) {
        if (this.analogOutSlider[i].isEnabled()) {
            this.analogSliderActionPerformed(this.analogOutSlider[i], evt);
            try {
                ControllerSocketSender.sendSetAnalogOut((int)i, (double)((double)this.analogOutSlider[i].getValue() / (double)this.analogOutSlider[i].getMaximum()));
            }
            catch (Exception e) {
                Log.error((String)"Parsing error?", (Throwable)e);
            }
            this.setAnalogOutTime[i] = System.currentTimeMillis();
        }
    }

    private void analogOutSlider0MouseDragged(MouseEvent evt) {
        this.analogOutSlider0MousePressed(evt);
    }

    private void analogOutSlider0MousePressed(MouseEvent evt) {
        this.analogSliderMouseEvent(evt, 0);
    }

    private void analogOutSlider1MouseDragged(MouseEvent evt) {
        this.analogOutSlider1MousePressed(evt);
    }

    private void analogOutSlider1MousePressed(MouseEvent evt) {
        this.analogSliderMouseEvent(evt, 1);
    }

    private void analogInCombo0ActionPerformed() {
        this.analogInChanged(0, this.analogInCombo[0].getSelectedIndex(), this.analogLowRangeLabel0, this.analogHighRangeLabel0);
    }

    void consumeRobotState(RobotState rs) {
        this.robotStateConsumer.accept((Object)rs);
    }

    protected DigitalNamedIO[] getToolOutputs() {
        return this.toolOutputs;
    }

    private final class ActionListenerImplementation
    implements ActionListener {
        private final DigitalNamedIO digitalNamedIO;
        private final Pin pin;

        public ActionListenerImplementation(DigitalNamedIO digitalNamedIO, Pin pin) {
            this.digitalNamedIO = digitalNamedIO;
            this.pin = pin;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.pin instanceof ConfigurableIOPin) {
                if (this.pin.isInput()) {
                    ControllerSocketSender.sendSetConfigurableIn((int)this.pin.getPin(), (boolean)this.digitalNamedIO.isSelected());
                } else {
                    ControllerSocketSender.sendSetConfigurableOut((int)this.pin.getPin(), (boolean)this.digitalNamedIO.isSelected());
                }
            } else if (this.pin instanceof StandardIOPin) {
                if (this.pin.isInput()) {
                    ControllerSocketSender.sendSetDigitalIn((int)this.pin.getPin(), (boolean)this.digitalNamedIO.isSelected());
                } else {
                    ControllerSocketSender.sendSetDigitalOut((int)this.pin.getPin(), (boolean)this.digitalNamedIO.isSelected());
                }
            } else if (this.pin instanceof ToolIOPin) {
                if (this.pin.isInput()) {
                    ControllerSocketSender.sendSetToolIn((int)this.pin.getPin(), (boolean)this.digitalNamedIO.isSelected());
                } else if (((RobotState)((RobotIOTab)RobotIOTab.this).robotStateRecipe.lastProvider().get()).robotMode.equals((Object)RobotMode.RUNNING)) {
                    ControllerSocketSender.sendSetToolOut((int)this.pin.getPin(), (boolean)this.digitalNamedIO.isSelected());
                }
            }
            RobotIOTab.this.buttonWaitTimer.put(this.pin, System.currentTimeMillis());
        }
    }

    private class RobotStateConsumer
    implements Consumer<RobotState> {
        private RobotStateConsumer() {
        }

        public void accept(RobotState rs) {
            RobotIOTab.this.robotStateUpdate = true;
            long t = System.currentTimeMillis();
            Pin[] analogInputPins = RobotIOTab.this.ioNameService.getAllAnalogInputPins();
            for (int i = 0; i < analogInputPins.length; ++i) {
                byte analogInputRange = rs.analogInputRange[i];
                RobotIOTab.this.updateAnalogValueInput(analogInputRange, rs.analogIn[i], RobotIOTab.this.analogProgress[i], RobotIOTab.this.analogInputOutOfRange[i]);
                if (i >= 2) continue;
                RobotIOTab.this.updateAnalogDomainSelection(t, analogInputRange, analogInputPins[i], RobotIOTab.this.analogInCombo[i]);
            }
            RobotIOTab.this.updateDigitalOut(RobotIOTab.this.standardOutputs, rs.digitalOut, t);
            RobotIOTab.this.updateDigitalOut(RobotIOTab.this.configurableOutputs, rs.configurableOut, t);
            RobotIOTab.this.updateDigitalOut(RobotIOTab.this.toolOutputs, rs.toolOut, t);
            Pin[] analogOutputPins = RobotIOTab.this.ioNameService.getStandardAnalogOutputPins();
            for (int i = 0; i < analogOutputPins.length; ++i) {
                RobotIOTab.this.updateAnalogValueOutput(t, rs.analogOut[i], rs.analogOutputDomain[i], analogOutputPins[i], RobotIOTab.this.analogOutSlider[i], RobotIOTab.this.analogOutputValue[i]);
                RobotIOTab.this.updateAnalogDomainSelection(t, rs.analogOutputDomain[i], analogOutputPins[i], RobotIOTab.this.analogOutCombo[i]);
            }
            RobotIOTab.this.updateEnablement(RobotIOTab.this.standardInputs, !rs.real);
            RobotIOTab.this.updateEnablement(RobotIOTab.this.toolInputs, !rs.real);
            RobotIOTab.this.updateEnablement(RobotIOTab.this.configurableInputs, !rs.real);
            RobotIOTab.this.currentProgressBar.setValue((int)(1000.0f * rs.toolCurrent));
            RobotIOTab.this.currentProgressBar.setString("" + RobotIOTab.this.kf.format(1000.0f * rs.toolCurrent) + " mA");
            RobotIOTab.this.updateSelection(RobotIOTab.this.standardInputs, rs.digitalIn);
            RobotIOTab.this.updateSelection(RobotIOTab.this.standardOutputs, rs.digitalOut);
            RobotIOTab.this.updateSelection(RobotIOTab.this.configurableInputs, rs.configurableIn);
            RobotIOTab.this.updateSelection(RobotIOTab.this.configurableOutputs, rs.configurableOut);
            RobotIOTab.this.updateSelection(RobotIOTab.this.toolInputs, rs.toolIn);
            RobotIOTab.this.updateSelection(RobotIOTab.this.toolOutputs, rs.toolOut);
            RobotIOTab.this.updateEnablementOfConfigurableOutputs();
            RobotIOTab.this.updateEnablementOfStandardOutputs();
            RobotIOTab.this.robotStateUpdate = false;
        }
    }
}

