/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio.installation;

import com.ur.i18n.TextResource;
import com.ur.log.logentry.robotmessage.RobotMessageProducer;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.VersionMetaData;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.version.urversion.URVersion;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogPriority;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.util.event.EventManager;
import com.ur.util.swing.HTML;
import com.ur.view.program.PlayProgramListener;
import gui.installation.RobotInstallationLookupService;
import gui.program.ProgramRootNode;
import gui.tools.DialogCreator;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public class AnalogRangesToDomainsConversionPlayProgramListener
implements PlayProgramListener {
    private static final int POST_3_0__0_TO_10V = 1;
    private static final int POST_3_0__4_TO_20mA = 0;
    private static final int PRE_3_0__0_TO_5V = 0;
    private static final int PRE_3_0__NEG_5_TO_5V = 1;
    private static final int PRE_3_0__0_TO_10V = 2;
    private static final int PRE_3_0__NEG_10_TO_10V = 3;
    private static final int PRE_3_0__TOOL_0_TO_5V = 0;
    private static final int PRE_3_0__TOOL_0_TO_10V = 1;
    private static final int PRE_3_0__TOOL__0_TO_20mA = 2;
    private final com.ur.polyscope.oldio.internal.TextResource ioTextResource;
    private final TextResource viewTextResource;
    private final DialogCreator dialogCreator;
    private final RobotInstallationLookupService installationLookupService;
    private boolean isUserWarnedAboutAnalogRangeChanges = false;

    @Inject
    public AnalogRangesToDomainsConversionPlayProgramListener(EventManager eventManager, RobotInstallationLookupService installationLookupService, ViewContext viewContext, DialogCreator dialogCreator) {
        this.installationLookupService = installationLookupService;
        this.ioTextResource = (com.ur.polyscope.oldio.internal.TextResource)viewContext.getTextResource(com.ur.polyscope.oldio.internal.TextResource.class);
        this.viewTextResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.dialogCreator = dialogCreator;
        this.resetWarningOnInstallationLoaded(eventManager);
        this.resetWarningOnNewProgram(eventManager);
        eventManager.addStrongListener(PlayProgramListener.class, (Object)this);
    }

    public void preparingPlay(ProgramRootNode program) {
        if (this.requiresConversion()) {
            this.convert_1_8_AnalogsToGeneration_3();
        }
    }

    public void playing(ProgramRootNode program, ScriptWriter scriptWriter) {
    }

    private void convert_1_8_AnalogsToGeneration_3() {
        ArrayList<String> messages = new ArrayList<String>();
        messages.addAll(this.handleScbVoltages());
        messages.addAll(this.handleToolVoltages());
        if (!messages.isEmpty()) {
            this.showDialog(this.formatMessages(messages));
        }
    }

    private String formatMessages(List<String> messages) {
        StringBuilder htmlMessage = new StringBuilder();
        for (String msg : messages) {
            htmlMessage.append(HTML.li((String)msg));
            new RobotMessageProducer().generateAndNotify(this.ioTextResource.analogInputRangeRemovedTitle());
        }
        return HTML.html((String)HTML.maxWidth((int)400, (String)(this.ioTextResource.analogInputRangeRemovedTitle() + HTML.br() + HTML.unorderedList((String)htmlMessage.toString()))));
    }

    private void showDialog(String htmlMessage) {
        DialogMessage dialogMessage = new DialogMessage(this.viewTextResource.Message(), htmlMessage);
        dialogMessage.setPriority(DialogPriority.LOW);
        this.dialogCreator.showMessageDialog(dialogMessage, MessageDialogType.MESSAGE, null);
        this.isUserWarnedAboutAnalogRangeChanges = true;
    }

    private List<String> handleToolVoltages() {
        IOService ioService = (IOService)this.installationLookupService.getComponent(IOService.class);
        int[] analogInputRange = ioService.getAnalogInputRange();
        ArrayList<String> messages = new ArrayList<String>();
        block5: for (int i = 2; i < 4; ++i) {
            switch (analogInputRange[i]) {
                case 0: {
                    messages.add(this.ioTextResource.analogInputRangeNowMapsToOther("tool", i));
                    analogInputRange[i] = 1;
                    continue block5;
                }
                case 1: {
                    analogInputRange[i] = 1;
                    continue block5;
                }
                case 2: {
                    analogInputRange[i] = 0;
                }
            }
        }
        return messages;
    }

    private List<String> handleScbVoltages() {
        IOService ioService = (IOService)this.installationLookupService.getComponent(IOService.class);
        int[] analogInputRange = ioService.getAnalogInputRange();
        ArrayList<String> messages = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            switch (analogInputRange[i]) {
                case 0: {
                    new RobotMessageProducer().generateAndNotify(this.ioTextResource.analogInputRangeNowMapsToOther("controller box", i)).notifyAllSubscribers();
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    messages.add(this.ioTextResource.analogInputRangeRemoved("[-5:5]V", i));
                    break;
                }
                case 3: {
                    messages.add(this.ioTextResource.analogInputRangeRemoved("[-10:10]V", i));
                }
            }
            analogInputRange[i] = 1;
        }
        return messages;
    }

    private boolean requiresConversion() {
        return !this.installationLookupService.isInstallationWithInternalVersion() && this.isInstallationCreatedAndLastSavedBeforeVersion3_0() && !this.hasUserBeenInformed();
    }

    private boolean isInstallationCreatedAndLastSavedBeforeVersion3_0() {
        Installation installation = this.installationLookupService.getInstallation();
        return URVersion.isLessThan((URVersion)((VersionMetaData)installation.getMetaData(VersionMetaData.class)).getCreatedInVersion(), (URVersion)URVersion.POLYSCOPE_VERSION_3_0) && URVersion.isLessThan((URVersion)((VersionMetaData)installation.getMetaData(VersionMetaData.class)).getLastSavedInVersion(), (URVersion)URVersion.POLYSCOPE_VERSION_3_0);
    }

    private boolean hasUserBeenInformed() {
        return this.isUserWarnedAboutAnalogRangeChanges;
    }

    private void resetWarningOnNewProgram(EventManager eventManager) {
        eventManager.addStrongListener(ProgramEventListener.class, (Object)new ProgramEventListener.Template(){

            public void onPreNewProgram() {
                AnalogRangesToDomainsConversionPlayProgramListener.this.isUserWarnedAboutAnalogRangeChanges = false;
            }
        });
    }

    private void resetWarningOnInstallationLoaded(EventManager eventManager) {
        eventManager.addStrongListener(InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                AnalogRangesToDomainsConversionPlayProgramListener.this.isUserWarnedAboutAnalogRangeChanges = false;
            }
        });
    }
}

