/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio.pulse;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.viewfacade.pin.Pin;

class ContinuousPulse
implements DomainComponent {
    private final PinReference pinReference;
    private final Time high;
    private final Time low;

    public ContinuousPulse(PinReference pin) {
        this(pin, Time.from((double)500.0, (Time.Unit)Time.Unit.MILLI_SECONDS), Time.from((double)500.0, (Time.Unit)Time.Unit.MILLI_SECONDS));
    }

    public ContinuousPulse(PinReference pin, Time high, Time low) {
        this.pinReference = pin;
        this.high = high;
        this.low = low;
    }

    public PinReference getPinReference() {
        return this.pinReference;
    }

    public Time getHigh() {
        return this.high;
    }

    public Time getLow() {
        return this.low;
    }

    public String toString() {
        return "{ContinuousPulse: pin: " + this.pinReference.toString() + ", highTime: " + this.high.getIn(Time.Unit.SECONDS) + "s , lowTime: " + this.low.getIn(Time.Unit.SECONDS) + "s}";
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isDefined() {
        return true;
    }

    public void writeScript(ScriptWriter writer) {
        writer.whileTrue();
        Pin pin = this.pinReference.dereference();
        writer.appendLine(pin.generateSetterScriptCode("True"));
        writer.sleep(this.getHigh().getIn(Time.Unit.SECONDS));
        writer.appendLine(pin.generateSetterScriptCode("False"));
        writer.sleep(this.getLow().getIn(Time.Unit.SECONDS));
        writer.end();
    }

    public String asValue() {
        return "";
    }
}

