/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio.pulse;

import com.ur.polyscope.installation.InstallationComponentConversionStrategy;
import com.ur.polyscope.oldio.pulse.ContinuousPulse;
import com.ur.polyscope.oldio.pulse.ContinuousPulseInstallationComponent;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.valueobjects.Time;
import gui.program.services.ProgramReferenceService;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;

public class ContinuousPulseConversionStrategy
extends ConversionStrategyTemplate<ContinuousPulseInstallationComponent>
implements InstallationComponentConversionStrategy<ContinuousPulseInstallationComponent> {
    private static final String CONTINUOUS_PULSE_CHILD = "continuousPulse";
    private static final String REFERENCED_NAME = "referencedName";
    private static final String HIGH_MS = "highMS";
    private static final String LOW_MS = "lowMS";
    private static final String CONTINUOUS_PULSE = "ContinuousPulse";
    private final ProgramReferenceService programReferenceService;

    @Inject
    public ContinuousPulseConversionStrategy(ProgramReferenceService programReferenceService) {
        super(ContinuousPulseInstallationComponent.class);
        this.programReferenceService = programReferenceService;
    }

    public void marshal(ContinuousPulseInstallationComponent continuousPulseInstallationComponent, PersistWriter persistWriter) {
        for (ContinuousPulse each : continuousPulseInstallationComponent) {
            persistWriter.startNode(CONTINUOUS_PULSE_CHILD);
            persistWriter.addAttribute(REFERENCED_NAME, each.getPinReference().getKey());
            persistWriter.addAttribute(HIGH_MS, each.getHigh().getIn(Time.Unit.MILLI_SECONDS));
            persistWriter.addAttribute(LOW_MS, each.getLow().getIn(Time.Unit.MILLI_SECONDS));
            persistWriter.endNode();
        }
    }

    public ContinuousPulseInstallationComponent unmarshal(PersistReader persistReader) {
        ContinuousPulseInstallationComponent result = new ContinuousPulseInstallationComponent();
        while (persistReader.hasMoreNodes()) {
            persistReader.moveToChildNode();
            String pinReference = persistReader.getStringAttribute(REFERENCED_NAME);
            double high = persistReader.getDoubleAttribute(HIGH_MS);
            double low = persistReader.getDoubleAttribute(LOW_MS);
            ContinuousPulse newPulse = new ContinuousPulse(this.programReferenceService.getPinReference(pinReference), Time.from((double)high, (Time.Unit)Time.Unit.MILLI_SECONDS), Time.from((double)low, (Time.Unit)Time.Unit.MILLI_SECONDS));
            result.setContinuousPulsePin(newPulse);
            persistReader.moveToParentNode();
        }
        return result;
    }

    public Map<String, Class<? extends ContinuousPulseInstallationComponent>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap(CONTINUOUS_PULSE, ContinuousPulseInstallationComponent.class);
    }

    public Map<String, Class<? extends ContinuousPulseInstallationComponent>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap(CONTINUOUS_PULSE, ContinuousPulseInstallationComponent.class);
    }
}

