/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio.pulse;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.oldio.pulse.ContinuousPulse;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ContinuousPulseInstallationComponent
implements InstallationComponent,
Iterable<ContinuousPulse> {
    private final Map<PinReference, ContinuousPulse> pinToContinuousPulseMap = new HashMap<PinReference, ContinuousPulse>();

    public Class<?> getType() {
        return ContinuousPulseInstallationComponent.class;
    }

    public void setContinuousPulsePin(DomainComponent domainComponent) {
        ContinuousPulse continuousPulse = (ContinuousPulse)domainComponent;
        this.pinToContinuousPulseMap.put(continuousPulse.getPinReference(), continuousPulse);
    }

    public boolean containsPinReference(PinReference pin) {
        return this.pinToContinuousPulseMap.containsKey(pin);
    }

    public DomainComponent getContinuousPulse(PinReference pin) {
        if (!this.pinToContinuousPulseMap.containsKey(pin)) {
            ContinuousPulse pulse = new ContinuousPulse(pin);
            this.pinToContinuousPulseMap.put(pin, pulse);
        }
        return this.pinToContinuousPulseMap.get(pin);
    }

    public void removeContinuousPulse(DomainComponent domainComponent) {
        ContinuousPulse continuousPulse = (ContinuousPulse)domainComponent;
        this.removeContinuousPulse(continuousPulse.getPinReference());
    }

    public void removeContinuousPulse(PinReference pinReference) {
        this.pinToContinuousPulseMap.remove(pinReference);
    }

    public void generateScript(ScriptWriter writer) {
        int uniqueId = 0;
        for (ContinuousPulse each : this.pinToContinuousPulseMap.values()) {
            writer.defineThread("ContinuousPulseInstallationComponent" + uniqueId);
            each.writeScript(writer);
            writer.end();
            writer.runThread("continuousPulse" + uniqueId, "ContinuousPulseInstallationComponent" + uniqueId);
            ++uniqueId;
        }
    }

    @Override
    public Iterator<ContinuousPulse> iterator() {
        return this.pinToContinuousPulseMap.values().iterator();
    }
}

