/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.oldio.pulse;

import com.ur.injection.HasKey;
import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.oldio.internal.TextResource;
import com.ur.polyscope.oldio.pulse.ContinuousPulse;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.io.externalapi.MinimumPulseTimeValidator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JPanel;

@HasKey(value="continuous-pulse")
public class ContinuousPulseView
implements ViewComponent {
    public static final String CONTINUOUS_PULSE_HIGH = "continuousHigh.IONamesTab";
    public static final String CONTINUOUS_PULSE_LOW = "continuousLow.IONamesTab";
    private JPanel content;
    private ViewComponent.ModifyListener modifyListener;
    private ContinuousPulse pulse;
    protected NumberField highValuePulse;
    protected NumberField lowValuePulse;

    @Inject
    public ContinuousPulseView(TextResource textResource, ViewContext context, MinimumPulseTimeValidator minimumPulseTimeValidator) {
        this.highValuePulse = this.createPulseLimitField(minimumPulseTimeValidator);
        this.highValuePulse.setName(CONTINUOUS_PULSE_HIGH);
        this.lowValuePulse = this.createPulseLimitField(minimumPulseTimeValidator);
        this.lowValuePulse.setName(CONTINUOUS_PULSE_LOW);
        this.content = context.createFormBuilder().label(textResource.highContinuousPulse(), new FormBuilder.PanelConstraints[0]).label(textResource.lowContinuousPulse(), new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.highValuePulse, new FormBuilder.PanelConstraints[0]).component((JComponent)this.lowValuePulse, new FormBuilder.PanelConstraints[0]).end().getPanel();
    }

    private NumberField createPulseLimitField(MinimumPulseTimeValidator minimumPulseTimeValidator) {
        NumberField result = new NumberField(UnitsValueConverterFactory.getTimeConverter((boolean)true));
        result.addActionListener((ActionListener)new UpdateContinuousPulse());
        result.setMode(Mode.PositiveNumbers);
        result.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.0##"));
        result.setErrorValidationStrategy(new ValidationStrategy[]{minimumPulseTimeValidator});
        result.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)3)});
        return result;
    }

    public JComponent asComponent() {
        return this.content;
    }

    public void setModifyListener(ViewComponent.ModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public void setDomain(DomainComponent domainComponent) {
        this.pulse = (ContinuousPulse)domainComponent;
        this.highValuePulse.setValue((Object)this.pulse.getHigh());
        this.lowValuePulse.setValue((Object)this.pulse.getLow());
    }

    protected class UpdateContinuousPulse
    implements ActionListener {
        protected UpdateContinuousPulse() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PinReference pinReference = ContinuousPulseView.this.pulse.getPinReference();
            ContinuousPulse continuousPulse = new ContinuousPulse(pinReference, (Time)ContinuousPulseView.this.highValuePulse.getValue(), (Time)ContinuousPulseView.this.lowValuePulse.getValue());
            ContinuousPulseView.this.modifyListener.onModified((DomainComponent)continuousPulse);
        }
    }
}

