/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageResource {
    private static boolean isG5 = true;

    private ImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/icons/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="G5_led_red.png")
    public static Icon G5LedRed() {
        return ImageResource.tryGetImage("G5_led_red.png");
    }

    @Key(value="switchOn.png")
    public static Icon switchOn() {
        return ImageResource.tryGetImage("switchOn.png");
    }

    @Key(value="freedriveIcon.png")
    public static Icon freedriveIcon() {
        return ImageResource.tryGetImage("freedriveIcon.png");
    }

    @Key(value="mocca-white.png")
    public static Icon moccaWhite() {
        return ImageResource.tryGetImage("mocca-white.png");
    }

    @Key(value="rotate.png")
    public static Icon rotate() {
        return ImageResource.tryGetImage("rotate.png");
    }

    @Key(value="translate.png")
    public static Icon translate() {
        return ImageResource.tryGetImage("translate.png");
    }

    @Key(value="move-teach.png")
    public static Icon moveTeach() {
        return ImageResource.tryGetImage("move-teach.png");
    }

    @Key(value="locked.png")
    public static Icon locked() {
        return ImageResource.tryGetImage("locked.png");
    }

    @Key(value="dummy.png")
    public static Icon dummy() {
        return ImageResource.tryGetImage("dummy.png");
    }

    @Key(value="G5_led_yellow.png")
    public static Icon G5LedYellow() {
        return ImageResource.tryGetImage("G5_led_yellow.png");
    }

    @Key(value="plane.png")
    public static Icon plane() {
        return ImageResource.tryGetImage("plane.png");
    }

    @Key(value="mocca.png")
    public static Icon mocca() {
        return ImageResource.tryGetImage("mocca.png");
    }

    @Key(value="switchOff.png")
    public static Icon switchOff() {
        return ImageResource.tryGetImage("switchOff.png");
    }

    @Key(value="G5_led_inactive.png")
    public static Icon G5LedInactive() {
        return ImageResource.tryGetImage("G5_led_inactive.png");
    }

    @Key(value="seperator_header.png")
    public static Icon seperatorHeader() {
        return ImageResource.tryGetImage("seperator_header.png");
    }

    @Key(value="moccasplash.png")
    public static Icon moccasplash() {
        return ImageResource.tryGetImage("moccasplash.png");
    }

    @Key(value="free.png")
    public static Icon free() {
        return ImageResource.tryGetImage("free.png");
    }

    @Key(value="G5_led_green.png")
    public static Icon G5LedGreen() {
        return ImageResource.tryGetImage("G5_led_green.png");
    }

    @Key(value="freedriveArrow.png")
    public static Icon freedriveArrow() {
        return ImageResource.tryGetImage("freedriveArrow.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            ImageResource.tryGetImage("G5_led_red.png");
            ImageResource.tryGetImage("switchOn.png");
            ImageResource.tryGetImage("freedriveIcon.png");
            ImageResource.tryGetImage("mocca-white.png");
            ImageResource.tryGetImage("rotate.png");
            ImageResource.tryGetImage("translate.png");
            ImageResource.tryGetImage("move-teach.png");
            ImageResource.tryGetImage("locked.png");
            ImageResource.tryGetImage("dummy.png");
            ImageResource.tryGetImage("G5_led_yellow.png");
            ImageResource.tryGetImage("plane.png");
            ImageResource.tryGetImage("mocca.png");
            ImageResource.tryGetImage("switchOff.png");
            ImageResource.tryGetImage("G5_led_inactive.png");
            ImageResource.tryGetImage("seperator_header.png");
            ImageResource.tryGetImage("moccasplash.png");
            ImageResource.tryGetImage("free.png");
            ImageResource.tryGetImage("G5_led_green.png");
            ImageResource.tryGetImage("freedriveArrow.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

