/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.controllerinterface;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.controllerinterface.AdditionalInfo;
import com.ur.polyscope.freedrive.internal.controllerinterface.RobotModeListener;
import com.ur.polyscope.freedrive.panel.FreedrivePanel;
import com.ur.util.event.Subscription;
import javax.inject.Inject;

public class FreedriveListener {
    private final FreedrivePanel freedrivePanel;
    private final Recipe<AdditionalInfo> additionalInfoRecipe;
    private final RobotModeListener robotModeListener;

    @Inject
    public FreedriveListener(FreedrivePanel freedrivePanel, @Source(value=AdditionalInfo.class) Recipe<AdditionalInfo> additionalInfoRecipe, RobotModeListener robotModeListener) {
        this.freedrivePanel = freedrivePanel;
        this.additionalInfoRecipe = additionalInfoRecipe;
        this.robotModeListener = robotModeListener;
    }

    public Subscription subscribe() {
        return this.additionalInfoRecipe.subscribe((Consumer)new AdditionalInfoConsumer());
    }

    private class AdditionalInfoConsumer
    implements Consumer<AdditionalInfo> {
        private boolean lastShow = false;

        private AdditionalInfoConsumer() {
        }

        public void accept(AdditionalInfo additionalInfo) {
            boolean show = FreedriveListener.this.robotModeListener.isRobotInFreedriveMode();
            if (this.lastShow != show) {
                if (show) {
                    FreedriveListener.this.freedrivePanel.show();
                    FreedriveListener.this.freedrivePanel.setSWFreedriveButtonActive();
                } else {
                    FreedriveListener.this.freedrivePanel.hide(false);
                    FreedriveListener.this.freedrivePanel.setSWFreedriveButtonNotActive();
                }
                this.lastShow = show;
            }
        }
    }
}

