/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.controllerinterface;

import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.freedrive.internal.state.LafState;
import javax.inject.Inject;

public class LafController {
    private final ControllerInterface controllerInterface;
    private LafState lafState;
    private static final String DISABLE_COMMAND = "laf disable\n";

    @Inject
    public LafController(ControllerInterface controllerInterface, LafState lafState) {
        this.controllerInterface = controllerInterface;
        this.lafState = lafState;
    }

    public void stopFreedrive() {
        this.controllerInterface.runScript("set freedrive mode False\n");
    }

    public void updateController() {
        if (this.lafState.isAllAxesFree()) {
            this.controllerInterface.runScript(DISABLE_COMMAND);
            return;
        }
        String freeaxesScript = this.lafState.getFreeaxesScript();
        this.controllerInterface.runScript(freeaxesScript);
    }

    public void startFreedrive() {
        this.controllerInterface.runScript("set freedrive mode True\n");
    }
}

