/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.controllerinterface;

import com.ur.lang.EqualsUtil;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.polyscope.freedrive.panel.FreedrivePanel;
import com.ur.util.event.Subscription;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.runtime.ControlMode;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RobotModeListener {
    private Recipe<com.ur.monitor.model.RobotMode> robotModeRecipe;
    private com.ur.monitor.model.RobotMode lastRobotMode = null;
    private FreedrivePanel freedrivePanel;

    @Inject
    public RobotModeListener(FreedrivePanel freedrivePanel, @Source(value=com.ur.monitor.model.RobotMode.class) Recipe<com.ur.monitor.model.RobotMode> robotModeRecipe) {
        this.robotModeRecipe = robotModeRecipe;
        this.freedrivePanel = freedrivePanel;
    }

    public Subscription subscribe() {
        return this.robotModeRecipe.subscribe((Consumer)new RobotStateConsumer());
    }

    public boolean isRobotInFreedriveMode() {
        if (this.lastRobotMode == null || this.lastRobotMode.getControlMode() == null) {
            return false;
        }
        return this.lastRobotMode.getControlMode().equals((Object)ControlMode.TEACH);
    }

    public boolean isProgramRunning() {
        return this.lastRobotMode.isProgramRunning();
    }

    public boolean isRobotReady() {
        if (this.lastRobotMode != null && this.lastRobotMode.getRobotMode() != null) {
            return this.lastRobotMode.getRobotMode().equals((Object)RobotMode.RUNNING) && this.isSafetyModeAllowed(this.lastRobotMode.getSafetyMode()) != false && !this.lastRobotMode.isProgramRunning();
        }
        return false;
    }

    private Boolean isSafetyModeAllowed(SafetyMode safetyMode) {
        return EqualsUtil.equalsOneOf((Object)safetyMode, (Object[])new SafetyMode[]{SafetyMode.NORMAL, SafetyMode.REDUCED, SafetyMode.RECOVERY, SafetyMode.VALIDATE_JOINT_ID});
    }

    private class RobotStateConsumer
    implements Consumer<com.ur.monitor.model.RobotMode> {
        private RobotStateConsumer() {
        }

        public void accept(com.ur.monitor.model.RobotMode robotMode) {
            RobotModeListener.this.lastRobotMode = robotMode;
            if (!RobotModeListener.this.isSafetyModeAllowed(RobotModeListener.this.lastRobotMode.getSafetyMode()).booleanValue()) {
                RobotModeListener.this.freedrivePanel.hide(true);
            }
            if (RobotModeListener.this.lastRobotMode.getRobotMode().equals((Object)RobotMode.IDLE) || RobotModeListener.this.lastRobotMode.getRobotMode().equals((Object)RobotMode.BACKDRIVE)) {
                RobotModeListener.this.freedrivePanel.setIdleOrBackdriveMode();
            } else {
                RobotModeListener.this.freedrivePanel.setNotIdleOrBackdriveMode();
            }
        }
    }
}

