/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.controllerinterface;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.polyscope.freedrive.panel.FreedrivePanel;
import com.ur.util.event.EventManager;
import com.ur.view.constants.comm.RobotMessageType;
import javax.inject.Inject;

public class SafetyMessageListener
implements RobotMessageListener {
    private final FreedrivePanel freedrivePanel;

    @Inject
    public SafetyMessageListener(EventManager eventManager, FreedrivePanel freedrivePanel) {
        this.freedrivePanel = freedrivePanel;
        eventManager.addStrongListener(RobotMessageListener.class, (Object)this);
    }

    public void handleRobotMessage(RobotMessage robotMessage) {
        if (robotMessage.type == RobotMessageType.SAFETY_MODE && !robotMessage.errorCode.equals((Object)ErrorCode.NO_ERROR)) {
            this.freedrivePanel.hide(true);
            if (robotMessage.errorCode.equals((Object)ErrorCode.JOINT_POSITION_LIMIT_PROTECTIVE_STOP)) {
                this.freedrivePanel.signalJointLimitProtectiveStop();
            }
        }
    }
}

