/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.controllerinterface;

import com.ur.monitor.RobotState;
import com.ur.polyscope.controllerinterface.PackageConsumer;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.freedrive.internal.controllerinterface.SingularityInfoModelSource;
import com.ur.polyscope.freedrive.internal.state.SingularityStateHolder;
import com.ur.view.constants.comm.RobotStatePackageType;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SingularityInfoPackageConsumer
implements RobotStatePackageConsumer {
    private static final RobotStatePackageType type = RobotStatePackageType.SINGULARITY_INFO;
    static final int SIZE_IN_BYTES = PackageConsumer.NumberOf.bytes((int)2);
    private final SingularityInfoModelSource modelSource;

    @Inject
    public SingularityInfoPackageConsumer(SingularityInfoModelSource modelSource) {
        this.modelSource = modelSource;
    }

    public int consume(DataInput stream, int messageLength) throws IOException {
        if (messageLength < SIZE_IN_BYTES) {
            throw new IndexOutOfBoundsException(String.format("Consuming MoveSense data from controller: message size in bytes to be consumed: %d, required: %d.", messageLength, SIZE_IN_BYTES));
        }
        int singularityLevel = stream.readByte() & 0xFF;
        int singularityType = stream.readByte() & 0xFF;
        int readCount = PackageConsumer.NumberOf.bytes((int)2);
        SingularityStateHolder singularityStateHolder = new SingularityStateHolder(singularityLevel, singularityType);
        this.modelSource.emit(singularityStateHolder);
        return readCount;
    }

    public void initialize(RobotState robotState) {
    }

    public RobotStatePackageType getPackageType() {
        return type;
    }
}

