/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.impl;

import com.google.inject.TypeLiteral;
import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.ServicesBinder;
import com.ur.lang.react.Recipe;
import com.ur.polyscope.controllerinterface.ControllerConnectionListener;
import com.ur.polyscope.controllerinterface.RobotStatePackageConsumer;
import com.ur.polyscope.freedrive.internal.TextResource;
import com.ur.polyscope.freedrive.internal.controllerinterface.FreedriveListener;
import com.ur.polyscope.freedrive.internal.controllerinterface.LafControllerConnectionListener;
import com.ur.polyscope.freedrive.internal.controllerinterface.RobotModeListener;
import com.ur.polyscope.freedrive.internal.controllerinterface.SafetyMessageListener;
import com.ur.polyscope.freedrive.internal.controllerinterface.SingularityInfoModelSource;
import com.ur.polyscope.freedrive.internal.controllerinterface.SingularityInfoPackageConsumer;
import com.ur.polyscope.freedrive.internal.controllerinterface.SingularityListener;
import com.ur.polyscope.freedrive.internal.impl.TextResourceImpl;
import com.ur.polyscope.freedrive.internal.mocca.MoccaHeaderMenuExtension;
import com.ur.polyscope.freedrive.internal.mocca.MoccaLogoSettings;
import com.ur.polyscope.freedrive.internal.state.SingularityStateHolder;
import com.ur.polyscope.freedrive.internal.swing.FreedrivePanelImpl;
import com.ur.polyscope.freedrive.internal.swing.LAFSettingsView;
import com.ur.polyscope.freedrive.internal.visualizer.ElbowSingularityVisualization;
import com.ur.polyscope.freedrive.internal.visualizer.HeadSingularityVisualization;
import com.ur.polyscope.freedrive.internal.visualizer.Wrist1SingularityVisualization;
import com.ur.polyscope.freedrive.internal.visualizer.Wrist3SingularityVisualization;
import com.ur.polyscope.freedrive.panel.FreedrivePanel;
import com.ur.polyscope.visualizer.element.VisualizerElement;
import com.ur.swing.extensible.ExtensionPointServiceBinder;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.i18n.LocalizationResource;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.Subscription;

public class ServiceBinderImpl
implements ServicesBinder {
    private Subscription freedriveSubscription;
    private Subscription robotModeSubscription;
    private Subscription singularityLevel;

    public void bind(Binder binder) {
        binder.bindClass(TextResource.class, TextResourceImpl.class);
        binder.bindToExtensionPoint(LocalizationResource.class, TextResourceImpl.class);
        binder.bindClass(FreedrivePanel.class, FreedrivePanelImpl.class);
        ExtensionPointServiceBinder.registerExtensionPoints((Binder)binder, FreedrivePanelImpl.class);
        binder.bindProvider((TypeLiteral)new TypeLiteral<Recipe<SingularityStateHolder>>(){}, SingularityInfoModelSource.class);
        binder.bindToExtensionPoint(RobotStatePackageConsumer.class, SingularityInfoPackageConsumer.class);
        binder.bindToExtensionPoint(VisualizerElement.class, HeadSingularityVisualization.class);
        binder.bindToExtensionPoint(VisualizerElement.class, Wrist3SingularityVisualization.class);
        binder.bindToExtensionPoint(VisualizerElement.class, Wrist1SingularityVisualization.class);
        binder.bindToExtensionPoint(VisualizerElement.class, ElbowSingularityVisualization.class);
        if (MoccaLogoSettings.isMoccaMasterLogoEnabled()) {
            binder.bindToExtensionPoint(MenuExtension.class, MoccaHeaderMenuExtension.class);
        }
    }

    public void load(Builder builder) {
        builder.get(SafetyMessageListener.class);
        builder.get(LAFSettingsView.class);
        this.robotModeSubscription = ((RobotModeListener)builder.get(RobotModeListener.class)).subscribe();
        this.freedriveSubscription = ((FreedriveListener)builder.get(FreedriveListener.class)).subscribe();
        this.singularityLevel = ((SingularityListener)builder.get(SingularityListener.class)).subscribe();
        EventNotificationService.register(null, ControllerConnectionListener.class, (Object)builder.get(LafControllerConnectionListener.class));
    }

    void unsubscribe() {
        if (this.freedriveSubscription != null) {
            this.freedriveSubscription.dispose();
        }
        if (this.robotModeSubscription != null) {
            this.robotModeSubscription.dispose();
        }
        if (this.singularityLevel != null) {
            this.singularityLevel.dispose();
        }
    }
}

