/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.joint;

import com.ur.lang.react.Recipe;
import com.ur.math.Angle;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.JointType;
import com.ur.polyscope.freedrive.internal.swing.LEDPanel;
import com.ur.polyscope.robot.configuration.joint.JointPositionRangeProvider;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class JointHelper {
    private static final float JOINT_RADIAN_THRESHOLD = Angle.from((double)10.0, (Angle.Unit)Angle.Unit.DEGREES).asFloat();
    private LEDPanel ledPanel;
    private int[] lastJointStateArray;
    private JointPositionRangeProvider jointPositionRangeProvider;

    @Inject
    public JointHelper(JointPositionRangeProvider jointPositionRangeProvider, @Source(value=Arm.class) Recipe<Arm> armRecipe) {
        this.jointPositionRangeProvider = jointPositionRangeProvider;
        armRecipe.executeOnUIThread().distinctUntilChanged().subscribe(arm -> {
            if (this.ledPanel == null) {
                return;
            }
            int[] jointStateArray = new int[]{0, 0, 0, 0, 0, 0};
            for (int i = 0; i < JointType.values().length; ++i) {
                boolean warn;
                Angle joint = Angle.from((double)arm.getActualJointsPosition().getJoint(i), (Angle.Unit)Angle.Unit.RADIANS);
                Angle jointMaxDegree = Angle.from((double)(this.getJointPositionRangeProvider().getMaximumCombinedPosition(JointType.fromJointNumber((int)i)) - (double)JOINT_RADIAN_THRESHOLD), (Angle.Unit)Angle.Unit.RADIANS);
                Angle jointMinDegree = Angle.from((double)(this.getJointPositionRangeProvider().getMinimumCombinedPosition(JointType.fromJointNumber((int)i)) + (double)JOINT_RADIAN_THRESHOLD), (Angle.Unit)Angle.Unit.RADIANS);
                boolean bl = warn = joint.isLargerThan(jointMaxDegree) || !joint.isLargerThan(jointMinDegree);
                if (!warn) continue;
                jointStateArray[i] = 1;
            }
            if (this.lastJointStateArray == null || !Arrays.equals(jointStateArray, this.lastJointStateArray)) {
                this.lastJointStateArray = jointStateArray;
                this.ledPanel.signalJointLimitChange(jointStateArray);
            } else if (!Arrays.equals(jointStateArray, this.lastJointStateArray)) {
                this.ledPanel.signalJointLimitChange(jointStateArray);
            }
        });
    }

    public JointPositionRangeProvider getJointPositionRangeProvider() {
        return this.jointPositionRangeProvider;
    }

    public void informAboutLedpanelReady(LEDPanel ledPanel) {
        this.ledPanel = ledPanel;
    }
}

