/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.state;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.freedrive.internal.state.Preset;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.feature.FeatureModel;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class LafState {
    private Feature feature;
    private int x;
    private int y;
    private int z;
    private int rx;
    private int ry;
    private int rz;
    private DecimalFormat decimalFormat;
    private static final String TCP_TOOL_CONSTANT = "tcp";

    @Inject
    public LafState(FeatureModel featureModel) {
        this.feature = featureModel.getBaseFeature();
        this.updatePresetsInternal(Preset.FREE);
        this.decimalFormat = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"0", (Locale)Locale.ENGLISH);
        this.decimalFormat.setMaximumFractionDigits(340);
    }

    public Feature getSelectedFeature() {
        return this.feature;
    }

    public boolean isAllAxesFree() {
        return Arrays.equals(this.getSelectionVector(), Preset.FREE.toIntArray());
    }

    public void updateState(Feature feature) {
        this.feature = feature;
    }

    public void updateState(Preset preset) {
        this.updatePresetsInternal(preset);
    }

    private void updatePresetsInternal(Preset preset) {
        int[] arr = new int[]{preset.getX(), preset.getY(), preset.getZ(), preset.getRx(), preset.getRy(), preset.getRz()};
        this.updateState(arr);
    }

    public void updateState(int[] arr) {
        this.x = arr[0];
        this.y = arr[1];
        this.z = arr[2];
        this.rx = arr[3];
        this.ry = arr[4];
        this.rz = arr[5];
    }

    int[] getSelectionVector() {
        int[] selectionVector = new int[]{this.x, this.y, this.z, this.rx, this.ry, this.rz};
        return selectionVector;
    }

    public String getFreeaxesScript() {
        String poseString = TCP_TOOL_CONSTANT;
        if (!"tool".equalsIgnoreCase(this.feature.getName())) {
            poseString = this.decimalFormat.format(this.feature.getPose().getPosition().getX(Length.Unit.M)) + " " + this.decimalFormat.format(this.feature.getPose().getPosition().getY(Length.Unit.M)) + " " + this.decimalFormat.format(this.feature.getPose().getPosition().getZ(Length.Unit.M)) + " " + this.decimalFormat.format(this.feature.getPose().getRotation().getRX(Angle.Unit.RAD)) + " " + this.decimalFormat.format(this.feature.getPose().getRotation().getRY(Angle.Unit.RAD)) + " " + this.decimalFormat.format(this.feature.getPose().getRotation().getRZ(Angle.Unit.RAD));
        }
        String selection = String.format("%d %d %d %d %d %d", this.x, this.y, this.z, this.rx, this.ry, this.rz);
        return String.format("laf enable %s %s%n", selection, poseString);
    }
}

