/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.state;

import java.util.Arrays;

public enum Preset {
    FREE(1, 1, 1, 1, 1, 1),
    TRANSLATION(1, 1, 1, 0, 0, 0),
    PLANE(1, 1, 0, 0, 0, 0),
    ROTATE(0, 0, 0, 1, 1, 1);

    private final int x;
    private final int y;
    private final int z;
    private final int rx;
    private final int ry;
    private final int rz;

    private Preset(int x, int y, int z, int rx, int ry, int rz) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
    }

    public static Preset valueOf(int[] values) {
        for (Preset preset : Preset.values()) {
            if (!Arrays.equals(preset.toIntArray(), values)) continue;
            return preset;
        }
        return null;
    }

    public int[] toIntArray() {
        return new int[]{this.x, this.y, this.z, this.rx, this.ry, this.rz};
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getRx() {
        return this.rx;
    }

    public int getRy() {
        return this.ry;
    }

    public int getRz() {
        return this.rz;
    }
}

