/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.state;

import com.ur.monitor.StreamedModel;
import com.ur.polyscope.freedrive.internal.state.SingularityState;
import com.ur.polyscope.freedrive.internal.state.SingularityType;
import java.util.EnumSet;

public class SingularityStateHolder
implements StreamedModel {
    private int singularityLevel;
    private int singularityType;

    public SingularityStateHolder(int singularityLevel, int singularityType) {
        this.singularityLevel = singularityLevel;
        this.singularityType = singularityType;
    }

    public void setSingularityLevel(int singularityLevel) {
        this.singularityLevel = singularityLevel;
    }

    public void setSingularityType(int singularityType) {
        this.singularityType = singularityType;
    }

    public SingularityState getSingularityState() {
        return this.resolveColor();
    }

    public EnumSet<SingularityType> getSingularityTypes() {
        return this.resolveType();
    }

    private SingularityState resolveColor() {
        if (this.singularityLevel == 0) {
            return SingularityState.INACTIVE;
        }
        if (this.singularityLevel == 1) {
            return SingularityState.NEAR_SINGULARITY;
        }
        if (this.singularityLevel == 2) {
            return SingularityState.IN_SINGULARITY;
        }
        return SingularityState.INACTIVE;
    }

    private EnumSet<SingularityType> resolveType() {
        int[] runner = new int[]{this.singularityType};
        EnumSet<SingularityType> result = EnumSet.noneOf(SingularityType.class);
        EnumSet.allOf(SingularityType.class).stream().sorted((o1, o2) -> o2.getValue() - o1.getValue()).forEach(item -> {
            if (runner[0] >= item.getValue()) {
                result.add((SingularityType)((Object)item));
                runner[0] = runner[0] - item.getValue();
            }
        });
        return result;
    }

    public double getSingularityLevel() {
        return this.singularityLevel;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityStateHolder that = (SingularityStateHolder)o;
        return that.singularityLevel == this.singularityLevel && that.singularityType == this.singularityType;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.singularityLevel);
        return (int)(temp ^ temp >>> 32);
    }
}

