/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.swing;

import com.ur.polyscope.freedrive.internal.ImageResource;
import com.ur.polyscope.freedrive.internal.TextResource;
import com.ur.polyscope.freedrive.internal.controllerinterface.LafController;
import com.ur.polyscope.freedrive.internal.controllerinterface.RobotModeListener;
import com.ur.polyscope.freedrive.internal.controllerinterface.SingularityInfoModelSource;
import com.ur.polyscope.freedrive.internal.feature.FeatureComboBoxModel;
import com.ur.polyscope.freedrive.internal.feature.InstallationTcpHelper;
import com.ur.polyscope.freedrive.internal.joint.JointHelper;
import com.ur.polyscope.freedrive.internal.state.LafState;
import com.ur.polyscope.freedrive.internal.state.Preset;
import com.ur.polyscope.freedrive.internal.state.SingularityStateHolder;
import com.ur.polyscope.freedrive.internal.swing.AxisButton;
import com.ur.polyscope.freedrive.internal.swing.LEDPanel;
import com.ur.polyscope.freedrive.internal.swing.RoundRectangleButton;
import com.ur.polyscope.freedrive.panel.FreedrivePanel;
import com.ur.polyscope.freedrive.settings.FreedriveSettings;
import com.ur.polyscope.freedrive.settings.SettingsChangedListener;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.geomfeature.urcaps.FeatureWrapService;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.JFrameUtils;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.extensible.AddToView;
import com.ur.swing.extensible.Extension;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssignerExt;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.feature.FeatureModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.metal.MetalToggleButtonUI;

@Singleton
@Extension(value="freedriveBehaviour")
public class FreedrivePanelImpl
implements FreedrivePanel,
AddToView,
SettingsChangedListener {
    private static final String OVERLAY_NAME = "freedriveDialog";
    private static final int PANEL_WIDTH = 352;
    private static final int PANEL_MARGIN = 20;
    private static final int PANEL_COOLDOWN = 300;
    private static final int FEATURE_LABEL_WIDTH = 110;
    private static final Color COLOR_CUSTOM_RED = new Color(250, 109, 109);
    private static final Color COLOR_CUSTOM_GREEN = new Color(100, 208, 102);
    private static final Color COLOR_CUSTOM_BLUE = new Color(82, 160, 211);
    private JPanel freedrivePane;
    private JDialog freedriveDialog;
    private int polyscopeFrameHeight;
    private boolean isPinned;
    private final FeatureModel featureModel;
    private final LafState lafState;
    private final TextResource textResource;
    private final FeatureWrapService featureWrapService;
    private final LafController controller;
    private final InstallationTcpHelper installationTcpHelper;
    private final RobotModeListener robotModeListener;
    private JComboBox<SpatialFeature> featureJComboBox;
    private List<JToggleButton> presetButtonList;
    private List<JToggleButton> toggleButtonList;
    private final JLabel lblTcp = new JLabel("tcp label placeholder");
    private ButtonGroup presetButtonGroup;
    private JLabel holdLabel;
    private JToggleButton freedrivePinButton;
    private JLabel presetNameLabel;
    private long timeClosed = 0L;
    private JButton swFreedriveButton;
    private LEDPanel ledPanel;
    private JToggleButton btnFree;
    private boolean isRobotInIdleOrBackdriveMode = false;
    private JLabel freedrivePinButtonLabel;
    private JLabel freedriveArrowIconLabel;
    private final HelpIdAssignerExt helpIdAssignerExt;
    private final JointHelper jointHelper;
    boolean panelLocationInitialized = false;
    private JLabel freedriveLabel;
    private Font labelFont;
    private FrameDragListener frameDragListener;
    private final SingularityInfoModelSource modelSource;
    private boolean isSWFreedriveButtonPressed = false;
    private static final MetalToggleButtonUI metalButtonUI = new MetalToggleButtonUI(){

        @Override
        protected Color getSelectColor() {
            return G5LookAndFeel.INFO_FILL_COLOR;
        }
    };

    @Inject
    public FreedrivePanelImpl(FeatureModel featureModel, LafState lafState, TextResource textResource, FeatureWrapService featureWrapService, LafController controller, InstallationTcpHelper installationTcpHelper, RobotModeListener robotModeListener, HelpIdAssignerExt helpIdAssignerExt, JointHelper jointHelper, SingularityInfoModelSource modelSource) {
        this.featureModel = featureModel;
        this.lafState = lafState;
        this.textResource = textResource;
        this.featureWrapService = featureWrapService;
        this.controller = controller;
        this.installationTcpHelper = installationTcpHelper;
        this.robotModeListener = robotModeListener;
        this.helpIdAssignerExt = helpIdAssignerExt;
        this.jointHelper = jointHelper;
        this.modelSource = modelSource;
        FreedriveSettings.setSettingsChangedListener((SettingsChangedListener)this);
    }

    public void showPinned() {
        this.isPinned = true;
        this.show();
    }

    public void show() {
        this.showPanel();
    }

    public void hide(boolean force) {
        if (force || !this.isPinned) {
            this.hidePanel();
        } else {
            this.freedriveDialog.requestFocus();
            this.setSWFreedriveButtonEnabled(true);
        }
    }

    public void updateSingularityLevel(SingularityStateHolder singularityStateHolder) {
        if (this.ledPanel != null) {
            this.ledPanel.updateState(singularityStateHolder);
        }
    }

    private void initPanel() {
        this.freedriveDialog = new JDialog(this.freedriveDialog);
        this.freedriveDialog.setUndecorated(true);
        this.freedrivePane = FreedrivePanelImpl.createBoxLayoutPanel(40, 40, 1, 0.5f);
        this.freedriveDialog.setVisible(false);
        this.freedriveDialog.setResizable(false);
        this.freedriveDialog.setAlwaysOnTop(true);
        this.freedriveDialog.setName(OVERLAY_NAME);
        this.freedriveDialog.setTitle(OVERLAY_NAME);
        this.freedriveDialog.setBackground(Color.BLACK);
        this.frameDragListener = new FrameDragListener(this.freedriveDialog);
        this.freedriveDialog.addMouseListener(this.frameDragListener);
        this.freedriveDialog.addMouseMotionListener(this.frameDragListener);
        this.freedrivePane.setVisible(true);
        this.freedrivePane.setBackground(Color.WHITE);
        this.freedriveDialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                if (FreedrivePanelImpl.this.robotModeListener.isRobotInFreedriveMode()) {
                    return;
                }
                FreedrivePanelImpl.this.freedrivePinButton.setSelected(false);
                FreedrivePanelImpl.this.hidePanel();
                if (FreedrivePanelImpl.this.swFreedriveButton.getModel().isPressed()) {
                    FreedrivePanelImpl.this.controller.stopFreedrive();
                }
            }
        });
        this.freedriveDialog.getContentPane().add(this.freedrivePane);
        JFrame frame = (JFrame)JFrameUtils.getApplicationMainFrame().get();
        boolean runningOnARobot = "root".equals(System.getProperty("user.name"));
        this.polyscopeFrameHeight = runningOnARobot ? frame.getHeight() : frame.getHeight() - frame.getInsets().top;
        JPanel singularityArea = FreedrivePanelImpl.createBoxLayoutPanel(352, 40, 2, 0.0f);
        this.freedrivePane.add((Component)singularityArea, Float.valueOf(0.0f));
        this.setupUpperFreedriveButtonArea();
        JPanel headlineArea = FreedrivePanelImpl.createBoxLayoutPanel(352, 20, 2, 0.0f);
        headlineArea.add(Box.createRigidArea(new Dimension(20, 1)));
        JLabel lblConstrainedControl = this.createLabelWithFont(this.textResource.constrainedControl(), 12, 1);
        headlineArea.add(lblConstrainedControl);
        this.freedrivePane.add(FreedrivePanelImpl.createBoxLayoutPanel(352, 7, 2, 0.0f));
        this.freedrivePane.add(headlineArea);
        JPanel activeTcpArea = FreedrivePanelImpl.createBoxLayoutPanel(352, 20, 2, 0.0f);
        JPanel tcpLabelContainer = new JPanel();
        FlowLayout layoutManager = new FlowLayout(2);
        tcpLabelContainer.setLayout(layoutManager);
        activeTcpArea.add(tcpLabelContainer);
        activeTcpArea.add(Box.createRigidArea(new Dimension(20, 1)));
        JLabel labelActiveTcp = this.createLabelWithFont(this.textResource.activeTcp(), 11, 0);
        tcpLabelContainer.add(labelActiveTcp);
        tcpLabelContainer.add(this.lblTcp);
        this.lblTcp.setFont(labelActiveTcp.getFont());
        this.lblTcp.setName("TCPLabel");
        this.freedrivePane.add(activeTcpArea);
        this.freedrivePane.add(FreedrivePanelImpl.createBoxLayoutPanel(352, 2, 2, 0.0f));
        int featureBoxHeight = 40;
        JPanel featureArea = FreedrivePanelImpl.createBoxLayoutPanel(352, featureBoxHeight, 2, 0.0f);
        this.freedrivePane.add(featureArea);
        this.freedrivePane.add(Box.createRigidArea(new Dimension(1, 8)));
        featureArea.add(Box.createRigidArea(new Dimension(20, 1)));
        JPanel featureLeftHeadlineBox = FreedrivePanelImpl.createBoxLayoutPanel(110, featureBoxHeight, 0, 1.0f);
        featureLeftHeadlineBox.setAlignmentY(0.5f);
        featureLeftHeadlineBox.setBorder(new LineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR));
        featureArea.add(featureLeftHeadlineBox);
        JLabel featureLabel = this.createLabelWithFont(this.textResource.feature(), 12, 0);
        featureLeftHeadlineBox.add(Box.createRigidArea(new Dimension(8, 20)));
        featureLeftHeadlineBox.add(featureLabel);
        JPanel featureComboBoxPanel = new JPanel(new BorderLayout());
        FreedrivePanelImpl.setDimension(featureComboBoxPanel, new Dimension(198, featureBoxHeight));
        featureComboBoxPanel.setBorder(new LineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR));
        this.featureJComboBox = new JComboBox();
        this.featureJComboBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        ComboBoxRenderer.bindRenderer(this.featureJComboBox, (RenderingStrategy)new RenderingStrategy(){

            public String getText(Object o) {
                return o.toString();
            }

            public Icon getIcon(Object o) {
                return null;
            }

            public boolean hasError(Object o) {
                return false;
            }
        });
        this.featureJComboBox.setFont(featureLabel.getFont());
        this.featureJComboBox.setAlignmentY(0.0f);
        this.featureJComboBox.setAlignmentY(0.5f);
        featureComboBoxPanel.add(this.featureJComboBox, "East");
        FreedrivePanelImpl.setDimension(this.featureJComboBox, 190, featureBoxHeight);
        featureArea.add(featureComboBoxPanel);
        this.featureJComboBox.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                SpatialFeature f = (SpatialFeature)itemEvent.getItem();
                this.lafState.updateState(this.featureWrapService.wrapFeature(f));
                this.controller.updateController();
            }
        });
        this.updateFeatureComboItems();
        JPanel presetsArea = FreedrivePanelImpl.createBoxLayoutPanel(352, 70, 2, 0.0f);
        presetsArea.add(Box.createRigidArea(new Dimension(20, 1)));
        this.freedrivePane.add(presetsArea);
        presetsArea.add(this.createPresetPanel());
        singularityArea.setBackground(G5LookAndFeel.PRESSED_CONTROL);
        singularityArea.add(Box.createRigidArea(new Dimension(10, 20)));
        this.ledPanel = new LEDPanel(this.textResource, this.lafState, this.btnFree, this.modelSource);
        this.ledPanel.setAlignmentX(0.0f);
        this.jointHelper.informAboutLedpanelReady(this.ledPanel);
        singularityArea.add(this.ledPanel);
        JPanel xyzArea = FreedrivePanelImpl.createBoxLayoutPanel(352, 170, 0, 0.0f);
        xyzArea.setBackground(G5LookAndFeel.PRESSED_CONTROL);
        xyzArea.add(this.createAxesTogglePanel());
        this.freedrivePane.add(xyzArea);
        this.updatePresetSelectionWhenAxesAreSelected();
    }

    private void setupUpperFreedriveButtonArea() {
        JPanel upperFreedriveArea = FreedrivePanelImpl.createBoxLayoutPanel(352, 80, 2, 0.0f);
        this.swFreedriveButton = new RoundRectangleButton("");
        this.swFreedriveButton.setLayout(new BorderLayout());
        this.freedriveLabel = new JLabel(this.textResource.freedrive());
        this.freedriveLabel.setFont(this.swFreedriveButton.getFont());
        this.freedriveLabel.setForeground(G5LookAndFeel.INFO_BORDER_COLOR);
        this.freedriveLabel.setHorizontalAlignment(0);
        this.freedriveLabel.setAlignmentX(0.5f);
        this.holdLabel = new JLabel(this.textResource.pressAndHold());
        this.labelFont = this.holdLabel.getFont();
        this.holdLabel.setForeground(G5LookAndFeel.INFO_BORDER_COLOR);
        this.holdLabel.setHorizontalAlignment(0);
        this.holdLabel.setAlignmentX(0.5f);
        this.swFreedriveButton.add((Component)this.freedriveLabel, "North");
        this.swFreedriveButton.add((Component)this.holdLabel, "South");
        this.swFreedriveButton.setFocusPainted(false);
        this.swFreedriveButton.setForeground(G5LookAndFeel.INFO_BORDER_COLOR);
        FreedrivePanelImpl.setDimension(this.swFreedriveButton, new Dimension(308, 50));
        this.swFreedriveButton.setAlignmentX(0.5f);
        this.swFreedriveButton.addMouseListener(new SWFreedriveButtonListener(false));
        upperFreedriveArea.add(Box.createRigidArea(new Dimension(20, 1)));
        JPanel freedriveButtonPanel = FreedrivePanelImpl.createBoxLayoutPanel(308, 50, 1, 0.5f);
        freedriveButtonPanel.setAlignmentY(0.5f);
        freedriveButtonPanel.setAlignmentX(0.5f);
        freedriveButtonPanel.add(this.swFreedriveButton);
        upperFreedriveArea.add(freedriveButtonPanel);
        this.freedrivePane.add(upperFreedriveArea);
    }

    public void onSettingsChanged(boolean newState) {
        if (this.freedriveDialog == null) {
            this.initPanel();
        }
        if (newState) {
            this.helpIdAssignerExt.updateHelpId((JComponent)this.freedrivePinButton, (JComponent)this.freedrivePinButton, "gui:freedrive");
            this.freedriveArrowIconLabel.setIcon(ImageResource.freedriveArrow());
            this.freedrivePinButtonLabel.setIcon(null);
            if (this.robotModeListener.isRobotInFreedriveMode()) {
                this.showPanel();
            }
        } else {
            this.btnFree.setSelected(true);
            this.updateButtonsWhenPresetIsSelected();
            this.helpIdAssignerExt.updateHelpId((JComponent)this.freedrivePinButton, (JComponent)this.freedrivePinButton, "gui:movetab_freedrive");
            this.freedriveArrowIconLabel.setIcon(null);
            this.freedrivePinButtonLabel.setIcon(ImageResource.freedriveIcon());
            this.freedrivePinButton.setSelected(false);
            this.hide(true);
        }
    }

    private JPanel createPresetPanel() {
        JPanel presetBox = FreedrivePanelImpl.createBoxLayoutPanel(352, 60, 2, 0.0f);
        ActionListener presetClickedListener = e -> this.updateButtonsWhenPresetIsSelected();
        MouseListener mouseExitedListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JToggleButton button = (JToggleButton)e.getSource();
                if (button.getModel().isPressed() && !button.isSelected()) {
                    button.getModel().setPressed(false);
                    button.getModel().setArmed(false);
                }
            }
        };
        this.presetButtonGroup = new ButtonGroup();
        this.btnFree = new JToggleButton(ImageResource.free());
        this.btnFree.addActionListener(presetClickedListener);
        this.btnFree.addMouseListener(mouseExitedListener);
        this.btnFree.setName(Preset.FREE.name());
        this.presetButtonGroup.add(this.btnFree);
        this.stylePresetButton(this.btnFree);
        JToggleButton btnPlane = new JToggleButton(ImageResource.plane());
        btnPlane.setName(Preset.PLANE.name());
        btnPlane.addActionListener(presetClickedListener);
        btnPlane.addMouseListener(mouseExitedListener);
        this.presetButtonGroup.add(btnPlane);
        this.stylePresetButton(btnPlane);
        JToggleButton btnTranslation = new JToggleButton(ImageResource.translate());
        btnTranslation.setName(Preset.TRANSLATION.name());
        btnTranslation.addActionListener(presetClickedListener);
        btnTranslation.addMouseListener(mouseExitedListener);
        this.presetButtonGroup.add(btnTranslation);
        this.stylePresetButton(btnTranslation);
        JToggleButton btnRotate = new JToggleButton(ImageResource.rotate());
        btnRotate.setName(Preset.ROTATE.name());
        btnRotate.addActionListener(presetClickedListener);
        btnRotate.addMouseListener(mouseExitedListener);
        this.presetButtonGroup.add(btnRotate);
        this.stylePresetButton(btnRotate);
        this.presetButtonList = new ArrayList<JToggleButton>();
        this.presetButtonList.add(this.btnFree);
        this.presetButtonList.add(btnPlane);
        this.presetButtonList.add(btnTranslation);
        this.presetButtonList.add(btnRotate);
        int btnWidth = 74;
        int btnHeight = 66;
        FreedrivePanelImpl.setDimension(this.btnFree, btnWidth, btnHeight);
        FreedrivePanelImpl.setDimension(btnTranslation, btnWidth, btnHeight);
        FreedrivePanelImpl.setDimension(btnPlane, btnWidth, btnHeight);
        FreedrivePanelImpl.setDimension(btnRotate, btnWidth, btnHeight);
        presetBox.add(this.btnFree);
        presetBox.add(Box.createRigidArea(new Dimension(4, 1)));
        presetBox.add(btnTranslation);
        presetBox.add(Box.createRigidArea(new Dimension(4, 1)));
        presetBox.add(btnPlane);
        presetBox.add(Box.createRigidArea(new Dimension(4, 1)));
        presetBox.add(btnRotate);
        return presetBox;
    }

    private JPanel createPresetNamePanel() {
        JPanel presetNamePanel = FreedrivePanelImpl.createBoxLayoutPanel(352, 30, 3, 0.5f);
        this.presetNameLabel = this.createLabelWithFont(this.textResource.free(), 12, 0);
        FreedrivePanelImpl.setDimension(this.presetNameLabel, new Dimension(350, 30));
        this.presetNameLabel.setHorizontalAlignment(0);
        this.presetNameLabel.setForeground(Color.GRAY);
        presetNamePanel.setBackground(G5LookAndFeel.PRESSED_CONTROL);
        presetNamePanel.add(this.presetNameLabel);
        return presetNamePanel;
    }

    private JPanel createAxesTogglePanel() {
        ActionListener onOffAxisListener = e -> this.updatePresetSelectionWhenAxesAreSelected();
        ItemListener onOffAxisItemListener = e -> {
            JToggleButton button = (JToggleButton)e.getSource();
            if (button.isSelected()) {
                button.setForeground(Color.WHITE);
            } else {
                button.setForeground(Color.BLACK);
            }
        };
        this.freedrivePane.add(Box.createRigidArea(new Dimension(0, 4)));
        LineBorder grayLineBorder = new LineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR, 1);
        EmptyBorder emptyBorder = new EmptyBorder(5, 20, 20, 20);
        CompoundBorder insideBorder = new CompoundBorder(grayLineBorder, emptyBorder);
        CompoundBorder axesPanelBorder = new CompoundBorder(new MatteBorder(0, 20, 0, 20, Color.WHITE), insideBorder);
        JPanel axesPanel = FreedrivePanelImpl.createBoxLayoutPanel(348, 170, 1, 0.5f);
        axesPanel.setBorder(axesPanelBorder);
        axesPanel.setBackground(G5LookAndFeel.PRESSED_CONTROL);
        axesPanel.add(this.createPresetNamePanel());
        JPanel onOffPanel = new JPanel(new GridLayout(3, 2, 20, -1));
        onOffPanel.setBackground(G5LookAndFeel.PRESSED_CONTROL);
        AxisButton x = new AxisButton(" X  ", COLOR_CUSTOM_RED);
        x.setName("x");
        x.addActionListener(onOffAxisListener);
        x.addItemListener(onOffAxisItemListener);
        AxisButton y = new AxisButton(" Y  ", COLOR_CUSTOM_GREEN);
        y.setName("y");
        y.addActionListener(onOffAxisListener);
        y.addItemListener(onOffAxisItemListener);
        AxisButton z = new AxisButton(" Z  ", COLOR_CUSTOM_BLUE);
        z.setName("z");
        z.addActionListener(onOffAxisListener);
        z.addItemListener(onOffAxisItemListener);
        AxisButton rx = new AxisButton(" RX", COLOR_CUSTOM_RED);
        rx.setName("rx");
        rx.addActionListener(onOffAxisListener);
        rx.addItemListener(onOffAxisItemListener);
        AxisButton ry = new AxisButton(" RY", COLOR_CUSTOM_GREEN);
        ry.setName("ry");
        ry.addActionListener(onOffAxisListener);
        ry.addItemListener(onOffAxisItemListener);
        AxisButton rz = new AxisButton(" RZ", COLOR_CUSTOM_BLUE);
        rz.setName("rz");
        rz.addActionListener(onOffAxisListener);
        rz.addItemListener(onOffAxisItemListener);
        this.toggleButtonList = new ArrayList<JToggleButton>();
        this.toggleButtonList.add(x);
        this.toggleButtonList.add(y);
        this.toggleButtonList.add(z);
        this.toggleButtonList.add(rx);
        this.toggleButtonList.add(ry);
        this.toggleButtonList.add(rz);
        onOffPanel.add(x);
        onOffPanel.add(rx);
        onOffPanel.add(y);
        onOffPanel.add(ry);
        onOffPanel.add(z);
        onOffPanel.add(rz);
        axesPanel.add(onOffPanel);
        return axesPanel;
    }

    public void addComponent(JComponent jComponent) {
        this.freedrivePinButton = (JToggleButton)jComponent;
        this.freedrivePinButton.setLayout(new BorderLayout());
        this.freedrivePinButton.setFocusPainted(false);
        this.freedrivePinButton.addMouseListener(new SWFreedriveButtonListener(true));
        for (MouseListener mouseListener : jComponent.getMouseListeners()) {
            this.freedrivePinButton.addMouseListener(mouseListener);
        }
        this.freedrivePinButtonLabel = new JLabel(this.textResource.freedrive(), 0);
        this.freedrivePinButtonLabel.setFont(this.freedrivePinButton.getFont());
        this.freedrivePinButton.add((Component)this.freedrivePinButtonLabel, "Center");
        FreedrivePinButtonListener freedrivePinButtonListener = new FreedrivePinButtonListener();
        this.freedrivePinButton.addItemListener(freedrivePinButtonListener);
        this.freedrivePinButton.setBorder(new JButton().getBorder());
        this.freedrivePinButton.setBackground(Color.WHITE);
        this.freedrivePinButton.setUI(metalButtonUI);
        this.freedrivePinButton.setHorizontalTextPosition(2);
        this.freedriveArrowIconLabel = new JLabel();
        if (FreedriveSettings.isLAFEnabled()) {
            this.freedriveArrowIconLabel.setIcon(ImageResource.freedriveArrow());
            this.helpIdAssignerExt.assignHelpId((JComponent)this.freedrivePinButton, "gui:freedrive");
        } else {
            this.freedrivePinButtonLabel.setIcon(ImageResource.freedriveIcon());
            this.helpIdAssignerExt.assignHelpId((JComponent)this.freedrivePinButton, "gui:movetab_freedrive");
        }
        this.freedrivePinButton.add((Component)this.freedriveArrowIconLabel, "East");
        this.freedrivePinButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (FreedriveSettings.isLAFEnabled() && FreedrivePanelImpl.this.isRobotInIdleOrBackdriveMode) {
                    FreedrivePanelImpl.this.controller.startFreedrive();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (FreedriveSettings.isLAFEnabled() && FreedrivePanelImpl.this.isRobotInIdleOrBackdriveMode) {
                    FreedrivePanelImpl.this.controller.stopFreedrive();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (FreedriveSettings.isLAFEnabled() && FreedrivePanelImpl.this.isRobotInIdleOrBackdriveMode) {
                    FreedrivePanelImpl.this.controller.stopFreedrive();
                }
            }
        });
    }

    public void setSWFreedriveButtonActive() {
        if (FreedriveSettings.isLAFEnabled()) {
            this.holdLabel.setText(this.textResource.active());
            if (!this.robotModeListener.isRobotInFreedriveMode() || this.isSWFreedriveButtonPressed) {
                this.swFreedriveButton.setBackground(G5LookAndFeel.INFO_FILL_COLOR);
                this.setSWFreedriveButtonEnabled(true);
            } else {
                this.swFreedriveButton.setBackground(Color.WHITE);
                this.setSWFreedriveButtonEnabled(false);
            }
        }
    }

    public void setSWFreedriveButtonNotActive() {
        if (FreedriveSettings.isLAFEnabled()) {
            this.holdLabel.setText(this.textResource.pressAndHold());
            this.swFreedriveButton.setBackground(Color.WHITE);
            this.setSWFreedriveButtonEnabled(!this.robotModeListener.isRobotInFreedriveMode() || this.isSWFreedriveButtonPressed);
        }
    }

    private void updatePresetSelectionWhenAxesAreSelected() {
        int[] arr = new int[6];
        for (int i = 0; i < this.toggleButtonList.size(); ++i) {
            JToggleButton btn = this.toggleButtonList.get(i);
            arr[i] = btn.isSelected() ? 1 : 0;
        }
        Preset presetMatch = Preset.valueOf(arr);
        if (presetMatch != null) {
            for (JToggleButton presetButton : this.presetButtonList) {
                if (!presetButton.getName().equalsIgnoreCase(presetMatch.name()) || presetButton.isSelected()) continue;
                presetButton.setSelected(true);
                this.presetNameLabel.setText(this.getPresetText(presetMatch));
            }
        } else {
            this.presetButtonGroup.clearSelection();
            this.presetNameLabel.setText(this.textResource.custom());
        }
        this.lafState.updateState(arr);
        this.ledPanel.resolveState();
        this.controller.updateController();
    }

    private void updateButtonsWhenPresetIsSelected() {
        for (JToggleButton presetButton : this.presetButtonList) {
            Preset preset;
            if (!presetButton.isSelected()) continue;
            this.toggleButtonList.get(0).setSelected((preset = Preset.valueOf(presetButton.getName())).getX() == 1);
            this.toggleButtonList.get(1).setSelected(preset.getY() == 1);
            this.toggleButtonList.get(2).setSelected(preset.getZ() == 1);
            this.toggleButtonList.get(3).setSelected(preset.getRx() == 1);
            this.toggleButtonList.get(4).setSelected(preset.getRy() == 1);
            this.toggleButtonList.get(5).setSelected(preset.getRz() == 1);
            this.presetNameLabel.setText(this.getPresetText(preset));
            this.lafState.updateState(preset);
            this.controller.updateController();
            break;
        }
        this.ledPanel.resolveState();
    }

    private String getPresetText(Preset preset) {
        String presetText;
        switch (preset) {
            case FREE: {
                presetText = this.textResource.free();
                break;
            }
            case TRANSLATION: {
                presetText = this.textResource.translation();
                break;
            }
            case PLANE: {
                presetText = this.textResource.plane();
                break;
            }
            case ROTATE: {
                presetText = this.textResource.rotate();
                break;
            }
            default: {
                presetText = this.textResource.custom();
            }
        }
        return presetText;
    }

    private void updateFeatureComboItems() {
        SpatialFeature selectedFeature;
        ArrayList<SpatialFeature> featureList = new ArrayList<SpatialFeature>();
        featureList.add(this.featureWrapService.unwrapFeature((Feature)this.featureModel.getBaseFeature()));
        featureList.add(this.featureWrapService.unwrapFeature((Feature)this.featureModel.getToolFeature()));
        for (Feature geomFeature : this.featureModel.getGeomFeatures()) {
            SpatialFeature spatialFeature = this.featureWrapService.unwrapFeature(geomFeature);
            if (!spatialFeature.isDefined() || !spatialFeature.isFirstLevelFeature()) continue;
            featureList.add(spatialFeature);
        }
        FeatureComboBoxModel featureComboBoxModel = new FeatureComboBoxModel(featureList);
        this.featureJComboBox.setModel(featureComboBoxModel);
        if (!featureList.contains(this.featureWrapService.unwrapFeature(this.lafState.getSelectedFeature()))) {
            selectedFeature = this.featureWrapService.unwrapFeature((Feature)this.featureModel.getBaseFeature());
            featureComboBoxModel.setSelectedItem(selectedFeature);
        } else {
            selectedFeature = this.featureWrapService.unwrapFeature(this.lafState.getSelectedFeature());
            featureComboBoxModel.setSelectedItem(selectedFeature);
        }
    }

    private void stylePresetButton(JToggleButton button) {
        button.setVerticalAlignment(0);
        button.setLayout(new BorderLayout());
        LineBorder border = new LineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR);
        button.setBorder(border);
        button.setBackground(Color.white);
        button.setUI(metalButtonUI);
        button.setFocusable(false);
        FreedrivePanelImpl.setDimension(button, 40, 40);
    }

    private void showPanel() {
        if (FreedriveSettings.isLAFEnabled()) {
            if (this.freedriveDialog == null) {
                this.initPanel();
            }
            if (this.robotModeListener.isProgramRunning()) {
                return;
            }
            this.lblTcp.setText(this.installationTcpHelper.getTCP());
            if (!this.freedriveDialog.isVisible()) {
                this.resizePanel();
                this.freedrivePane.setBorder(new LineBorder(G5LookAndFeel.INFO_BORDER_COLOR, 2));
                this.updateFeatureComboItems();
                this.freedriveDialog.setVisible(true);
            }
        }
    }

    private void setSWFreedriveButtonEnabled(boolean enabled) {
        if (enabled) {
            this.freedriveLabel.setForeground(G5LookAndFeel.INFO_BORDER_COLOR);
            this.holdLabel.setFont(this.labelFont);
            this.swFreedriveButton.removeMouseListener(this.frameDragListener);
            this.swFreedriveButton.removeMouseMotionListener(this.frameDragListener);
        } else {
            this.freedriveLabel.setForeground(Color.BLACK);
            this.holdLabel.setFont(this.freedriveLabel.getFont());
            this.swFreedriveButton.addMouseListener(this.frameDragListener);
            this.swFreedriveButton.addMouseMotionListener(this.frameDragListener);
        }
        this.swFreedriveButton.setEnabled(enabled);
    }

    private void hidePanel() {
        if (this.freedriveDialog != null && this.freedriveDialog.isVisible()) {
            this.freedriveDialog.setVisible(false);
            this.timeClosed = System.currentTimeMillis();
        }
    }

    private void resizePanel() {
        JFrame mainFrame = (JFrame)JFrameUtils.getApplicationMainFrame().get();
        int dialogHeight = this.polyscopeFrameHeight - 320;
        this.freedriveDialog.setSize(352, dialogHeight);
        if (!this.panelLocationInitialized) {
            Point panelDefaultLocation = new Point(mainFrame.getLocation().x + mainFrame.getWidth() - 354, mainFrame.getLocation().y + mainFrame.getHeight() - (dialogHeight + 45));
            this.freedriveDialog.setLocation(panelDefaultLocation);
            this.panelLocationInitialized = true;
        }
        boolean isOutsideScreen = false;
        Point fixedLocation = this.freedriveDialog.getLocation();
        if (this.freedriveDialog.getLocation().x < mainFrame.getLocation().x) {
            isOutsideScreen = true;
            fixedLocation.x = mainFrame.getLocation().x;
        }
        if (this.freedriveDialog.getLocation().x > mainFrame.getLocation().x + mainFrame.getWidth() - 352) {
            isOutsideScreen = true;
            fixedLocation.x = mainFrame.getLocation().x + mainFrame.getWidth() - this.freedriveDialog.getWidth();
        }
        if (this.freedriveDialog.getLocation().y < mainFrame.getLocation().y) {
            isOutsideScreen = true;
            fixedLocation.y = mainFrame.getLocation().y;
        }
        if (this.freedriveDialog.getLocation().y > mainFrame.getLocation().y + mainFrame.getHeight() - (dialogHeight + 35)) {
            isOutsideScreen = true;
            fixedLocation.y = mainFrame.getLocation().y + mainFrame.getHeight() - this.freedriveDialog.getHeight();
        }
        if (isOutsideScreen) {
            this.freedriveDialog.setLocation(fixedLocation);
        }
    }

    public void setIdleOrBackdriveMode() {
        if (!this.isRobotInIdleOrBackdriveMode && FreedriveSettings.isLAFEnabled()) {
            this.freedrivePinButtonLabel.setText("<html><tag><b>" + this.textResource.backdrive() + "</b><br><FONT SIZE=3>" + this.textResource.pressAndHold() + "</FONT></tag></html>");
            this.freedriveArrowIconLabel.setIcon(null);
            this.freedrivePinButtonLabel.setIcon(ImageResource.freedriveIcon());
            this.isRobotInIdleOrBackdriveMode = true;
        }
    }

    public void setNotIdleOrBackdriveMode() {
        if (this.isRobotInIdleOrBackdriveMode && FreedriveSettings.isLAFEnabled()) {
            this.freedrivePinButtonLabel.setText(this.textResource.freedrive());
            this.freedriveArrowIconLabel.setIcon(ImageResource.freedriveArrow());
            this.freedrivePinButtonLabel.setIcon(null);
            this.isRobotInIdleOrBackdriveMode = false;
        }
    }

    public void signalJointLimitProtectiveStop() {
        if (this.btnFree != null) {
            this.btnFree.setSelected(true);
            this.updateButtonsWhenPresetIsSelected();
        }
    }

    private static void setDimension(JComponent component, Dimension dimension) {
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
    }

    private static void setDimension(JComponent component, int width, int height) {
        Dimension dimension = new Dimension(width, height);
        FreedrivePanelImpl.setDimension(component, dimension);
    }

    static JPanel createBoxLayoutPanel(int width, int height, int axis, float horizontalAlignment) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, axis));
        panel.setAlignmentX(horizontalAlignment);
        panel.setAlignmentY(0.0f);
        FreedrivePanelImpl.setDimension(panel, width, height);
        return panel;
    }

    private JLabel createLabelWithFont(String text, int size, int font) {
        JLabel label = new JLabel(text);
        label.setFont(label.getFont().deriveFont(font, size));
        return label;
    }

    public static class FrameDragListener
    extends MouseAdapter {
        private final JDialog frame;
        private Point mouseDownCompCoords = null;

        FrameDragListener(JDialog frame) {
            this.frame = frame;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseDownCompCoords = null;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseDownCompCoords = new Point(e.getLocationOnScreen().x - this.frame.getLocation().x, e.getLocationOnScreen().y - this.frame.getLocation().y);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point currCoords = e.getLocationOnScreen();
            if (currCoords != null && this.mouseDownCompCoords != null) {
                this.frame.setLocation(currCoords.x - this.mouseDownCompCoords.x, currCoords.y - this.mouseDownCompCoords.y);
            }
        }
    }

    private class SWFreedriveButtonListener
    implements MouseListener {
        private boolean sourceButtonIsOldFreedriveButton;

        public SWFreedriveButtonListener(boolean sourceButtonIsOldFreedriveButton) {
            this.sourceButtonIsOldFreedriveButton = sourceButtonIsOldFreedriveButton;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if ((!this.sourceButtonIsOldFreedriveButton && FreedrivePanelImpl.this.swFreedriveButton.isEnabled()) ^ !FreedriveSettings.isLAFEnabled()) {
                FreedrivePanelImpl.this.isSWFreedriveButtonPressed = true;
                FreedrivePanelImpl.this.controller.startFreedrive();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.stopFreedrive();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.stopFreedrive();
        }

        private void stopFreedrive() {
            if (!this.sourceButtonIsOldFreedriveButton && FreedriveSettings.isLAFEnabled() && FreedrivePanelImpl.this.freedriveDialog != null && FreedrivePanelImpl.this.swFreedriveButton.isEnabled()) {
                FreedrivePanelImpl.this.controller.stopFreedrive();
            }
            if (this.sourceButtonIsOldFreedriveButton && !FreedriveSettings.isLAFEnabled()) {
                FreedrivePanelImpl.this.controller.stopFreedrive();
                FreedrivePanelImpl.this.freedrivePinButton.setSelected(false);
            }
            FreedrivePanelImpl.this.isSWFreedriveButtonPressed = false;
        }
    }

    private class FreedrivePinButtonListener
    implements ItemListener {
        private FreedrivePinButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (FreedrivePanelImpl.this.freedrivePinButton.isSelected()) {
                if (System.currentTimeMillis() - FreedrivePanelImpl.this.timeClosed > 300L && FreedrivePanelImpl.this.robotModeListener.isRobotReady()) {
                    FreedrivePanelImpl.this.showPinned();
                } else {
                    FreedrivePanelImpl.this.freedrivePinButton.setSelected(false);
                }
            } else {
                FreedrivePanelImpl.this.isPinned = false;
                FreedrivePanelImpl.this.hidePanel();
            }
        }
    }
}

