/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.swing;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.freedrive.internal.TextResource;
import com.ur.polyscope.freedrive.settings.FreedriveSettings;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.swing.CardPanel;
import com.ur.swing.OnOffSwitchWithStatus;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.platform.ActionPanelDefinition;
import com.ur.swing.platform.SetupSite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

@Singleton
public class LAFSettingsView
extends CardPanel
implements AdminLockListener {
    protected static final String SYSTEM_ADMIN_PASSWORD = "systemPassword";
    private static final String MENU_NAME = "menu.ConstrainedFreedriveSettings";
    private static final String PANEL_NAME = "panel.ConstrainedFreedriveSettings";
    private static final String ON_OFF_STATUS_SWITCH_NAME = "onOffStatus.ConstrainedFreedriveSettings";
    private final transient TextResource textResource;
    private final transient RequireAdminPasswordFooter passwordFooter;
    private final transient AdminLock adminLock;
    protected final OnOffSwitchWithStatus onOffSwitchWithStatus;

    @Inject
    public LAFSettingsView(SetupSite setupSite, RequireAdminPasswordFooter passwordFooter, ViewContext viewContext, AdminLock adminLock) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.passwordFooter = passwordFooter;
        this.adminLock = adminLock;
        this.putClientProperty("LAFSettingsView", "LockAxesFreedrive");
        this.onOffSwitchWithStatus = new OnOffSwitchWithStatus(viewContext.getFontFactory());
        this.initComponents();
        this.registerViewInSetupSite(setupSite);
        if (FeatureToggle.isActive((String)SYSTEM_ADMIN_PASSWORD)) {
            adminLock.addListener((AdminLockListener)this);
        }
    }

    public Object exit() {
        this.cleanup();
        return super.exit();
    }

    private void cleanup() {
        this.passwordFooter.resetPasswordField();
    }

    private void initComponents() {
        JPanel contentPanel = new JPanel();
        contentPanel.setName(PANEL_NAME);
        contentPanel.setLayout(new BoxLayout(contentPanel, 3));
        contentPanel.setAlignmentX(0.0f);
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 3));
        content.setAlignmentX(0.0f);
        content.setAlignmentY(0.0f);
        JPanel box1 = LAFSettingsView.createBoxLayoutPanel(600, 40, 2, 0.0f);
        JPanel onOffSwitchPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.onOffSwitchWithStatus.setPreferredSize(new Dimension(460, 40));
        this.onOffSwitchWithStatus.setName(ON_OFF_STATUS_SWITCH_NAME);
        this.onOffSwitchWithStatus.setSwitchName(ON_OFF_STATUS_SWITCH_NAME);
        this.onOffSwitchWithStatus.getComponent(1).setBackground(Color.LIGHT_GRAY);
        onOffSwitchPanel.add((Component)this.onOffSwitchWithStatus);
        this.onOffSwitchWithStatus.setSelected(FreedriveSettings.isLAFEnabled());
        this.onOffSwitchWithStatus.addItemListener(e -> this.setFeatureEnabled(this.onOffSwitchWithStatus.isSelected()));
        box1.add(onOffSwitchPanel);
        content.add(box1);
        contentPanel.add(Box.createRigidArea(new Dimension(30, 30)));
        contentPanel.add(content);
        this.setLayout(new BorderLayout());
        this.add(this.createCard(this.textResource.laf(), contentPanel), "Center");
        this.addPasswordFooter();
        if (FeatureToggle.isActive((String)SYSTEM_ADMIN_PASSWORD) && this.adminLock.isLocked()) {
            this.doLock();
        } else {
            this.doUnlock();
        }
    }

    private void setFeatureEnabled(boolean value) {
        FreedriveSettings.setLAFEnabled((boolean)value);
    }

    private void registerViewInSetupSite(SetupSite setupSite) {
        setupSite.addActionForPanel(new ActionPanelDefinition(this.textResource.laf(), MENU_NAME, (CardPanel)this));
    }

    private static void setDimension(JComponent component, Dimension dimension) {
        component.setMaximumSize(dimension);
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
    }

    private static void setDimension(JComponent component, int width, int height) {
        Dimension dimension = new Dimension(width, height);
        LAFSettingsView.setDimension(component, dimension);
    }

    private static JPanel createBoxLayoutPanel(int width, int height, int axis, float horizontalAlignment) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, axis));
        panel.setAlignmentX(horizontalAlignment);
        panel.setAlignmentY(0.0f);
        LAFSettingsView.setDimension(panel, width, height);
        return panel;
    }

    private void addPasswordFooter() {
        JPanel footerPanel = this.passwordFooter.getFooterPanel();
        this.add(this.createCard(null, footerPanel), "South");
        if (!FeatureToggle.isActive((String)SYSTEM_ADMIN_PASSWORD)) {
            footerPanel.setVisible(false);
        }
    }

    private JPanel createCard(String cardTitle, JComponent panel) {
        JPanel result = new JPanel(new BorderLayout());
        if (cardTitle != null) {
            result.setBorder((Border)new CardBorder(cardTitle));
        }
        result.add((Component)panel, "Center");
        return result;
    }

    public void doUnlock() {
        this.onOffSwitchWithStatus.setEnabled(true);
    }

    public void doLock() {
        this.onOffSwitchWithStatus.setEnabled(false);
    }
}

