/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.swing;

import com.ur.monitor.model.JointType;
import com.ur.polyscope.freedrive.internal.ImageResource;
import com.ur.polyscope.freedrive.internal.TextResource;
import com.ur.polyscope.freedrive.internal.controllerinterface.SingularityInfoModelSource;
import com.ur.polyscope.freedrive.internal.state.LafState;
import com.ur.polyscope.freedrive.internal.state.SingularityState;
import com.ur.polyscope.freedrive.internal.state.SingularityStateHolder;
import com.ur.polyscope.freedrive.internal.state.SingularityType;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jdesktop.swingx.JXLabel;

public class LEDPanel
extends JPanel {
    public static final int LED_LABEL_WIDTH = 332;
    public static final int LED_LABEL_HEIGHT = 40;
    private final transient TextResource textResource;
    private final JXLabel labelLed;
    private transient SingularityStateHolder lastLevelReceivedState;
    private int[] jointStateArray = new int[]{0, 0, 0, 0, 0, 0};
    private final transient LafState lafState;
    private final JToggleButton btnFree;
    private static final Border SINGULARIY_BORDER = new LineBorder(Color.YELLOW, 3);
    private static final Border DEFAULT_PRESET_BUTTON_BORDER = new LineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR);
    private static final String JOINT_NAME_PART_1 = "Joint_";
    private static final String JOINT_NAME_PART_2 = "_name";
    private final SingularityInfoModelSource modelSource;

    public LEDPanel(TextResource textResource, LafState lafState, JToggleButton btnFree, SingularityInfoModelSource modelSource) {
        this.lafState = lafState;
        this.btnFree = btnFree;
        this.modelSource = modelSource;
        this.setLayout(new BorderLayout());
        this.textResource = textResource;
        this.labelLed = new JXLabel("placeholder content placeholder content", ImageResource.G5LedGreen(), 2);
        this.labelLed.setMinimumSize(new Dimension(332, 40));
        this.labelLed.setMaximumSize(new Dimension(332, 40));
        this.labelLed.setPreferredSize(new Dimension(332, 40));
        this.labelLed.setMaxLineSpan(332);
        this.labelLed.setFont(this.labelLed.getFont().deriveFont(0, 12.0f));
        this.labelLed.setBorder(BorderFactory.createEmptyBorder());
        this.labelLed.setLineWrap(true);
        this.setBackground(G5LookAndFeel.PRESSED_CONTROL);
        this.add((Component)this.labelLed, "West");
    }

    void updateState(SingularityStateHolder singularityStateHolder) {
        this.lastLevelReceivedState = singularityStateHolder;
        this.resolveState();
    }

    private boolean isSingularityEligibleForShowing() {
        return !this.lafState.isAllAxesFree() && this.lastLevelReceivedState != null;
    }

    private String getResourceByJointNumber(int jointNumber) {
        return this.textResource.get(JOINT_NAME_PART_1 + jointNumber + JOINT_NAME_PART_2);
    }

    void resolveState() {
        int numberOfJointsInViolation = this.numberOfJointsInViolation();
        if (this.btnFree != null) {
            this.btnFree.setBorder(DEFAULT_PRESET_BUTTON_BORDER);
        }
        if (this.lafState.isAllAxesFree()) {
            this.modelSource.emit(new SingularityStateHolder(0, 0));
        }
        boolean isSingularityWarningShowed = false;
        if (this.isSingularityEligibleForShowing()) {
            if (this.lastLevelReceivedState.getSingularityState().equals((Object)SingularityState.NEAR_SINGULARITY)) {
                this.labelLed.setText(this.getSingularityText(this.lastLevelReceivedState.getSingularityTypes()) + " " + this.textResource.yellowLED());
                this.labelLed.setIcon(ImageResource.G5LedYellow());
                this.labelLed.setVisible(true);
                isSingularityWarningShowed = true;
            } else if (this.lastLevelReceivedState.getSingularityState().equals((Object)SingularityState.IN_SINGULARITY)) {
                this.labelLed.setText(this.getSingularityText(this.lastLevelReceivedState.getSingularityTypes()) + " " + this.textResource.redLED());
                this.labelLed.setIcon(ImageResource.G5LedRed());
                this.labelLed.setVisible(true);
                isSingularityWarningShowed = true;
                if (this.btnFree != null && !this.btnFree.isSelected()) {
                    this.btnFree.setBorder(SINGULARIY_BORDER);
                }
            }
        }
        if (!isSingularityWarningShowed) {
            this.handleWarningMessage(numberOfJointsInViolation);
        }
    }

    private void handleWarningMessage(int numberOfJointsInViolation) {
        if (numberOfJointsInViolation == 1) {
            this.labelLed.setIcon(ImageResource.G5LedYellow());
            int indexJointAboveThreshold = IntStream.of(this.jointStateArray).boxed().collect(Collectors.toList()).indexOf(1);
            JointType jointType = JointType.fromJointNumber((int)indexJointAboveThreshold);
            this.labelLed.setText(this.textResource.specificJointLimitWarning(this.getResourceByJointNumber(jointType.getJointNumber())));
            this.labelLed.setVisible(true);
        } else if (numberOfJointsInViolation > 1) {
            this.labelLed.setIcon(ImageResource.G5LedYellow());
            this.labelLed.setText(this.textResource.multipleJointLimitWarning());
            this.labelLed.setVisible(true);
        } else {
            this.labelLed.setText("");
            this.labelLed.setVisible(false);
        }
    }

    private String getSingularityText(EnumSet<SingularityType> singularityTypes) {
        ArrayList strings = new ArrayList();
        singularityTypes.forEach(item -> {
            switch (item) {
                case ELBOW: {
                    strings.add(this.textResource.Elbow());
                    break;
                }
                case HEAD: {
                    strings.add(this.textResource.Head());
                    break;
                }
                case WRIST: {
                    strings.add(this.textResource.Wrist());
                }
            }
        });
        return String.join((CharSequence)" and ", strings);
    }

    private int numberOfJointsInViolation() {
        return IntStream.of(this.jointStateArray).reduce(Integer::sum).getAsInt();
    }

    public void signalJointLimitChange(int[] jointStateArray) {
        this.jointStateArray = (int[])jointStateArray.clone();
        this.resolveState();
    }
}

