/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.freedrive.internal.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;

public class RoundRectangleButton
extends JButton {
    Shape shape;

    RoundRectangleButton(String label) {
        super(label);
        this.setContentAreaFilled(false);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, 25, 25);
        super.paintComponent(graphics);
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isEnabled()) {
            graphics.setColor(this.getForeground());
        } else {
            graphics.setColor(Color.white);
        }
        graphics.drawRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, 25, 25);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.shape == null || !this.shape.getBounds().equals(this.getBounds())) {
            this.shape = new RoundRectangle2D.Float(0.0f, 0.0f, this.getSize().width, this.getSize().height, 25.0f, 25.0f);
        }
        return this.shape.contains(x, y);
    }
}

